/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.compiler.uml.BridgePackage;
import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.UmlElement;
import java.util.HashMap;
import java.util.List;

public abstract class PackagesFactory {
    public static final String PACKAGES_KEY = "ch.e2e.builder.compiler.uml.packages";
    public static final String PACKAGE_ALIASES = "Aliases";
    public static final String PACKAGE_BACKEND_INTERFACES = "Backend Interfaces";
    public static final String PACKAGE_BACKEND_SERVICES = "Backend Services";
    public static final String PACKAGE_BASETYPES = "Base Types";
    public static final String PACKAGE_BASECOMPONENT = "Base Components";
    public static final String PACKAGE_CUSTOMIZATION = "E2E Customizations";
    public static final String PACKAGE_DEPLOYMENT = "File View";
    public static final String PACKAGE_COMPONENT = "Component View";
    public static final String PACKAGE_COMPONENTS = "Components";
    public static final String PACKAGE_ARTIFACTS = "Artifacts";
    public static final String PACKAGE_RESOURCES = "Resources";
    public static final String PACKAGE_SERVICES = "Services";
    public static final String PACKAGE_TEMPLATES = "Templates";
    public static final String PACKAGE_TEST_SERVICES = "Test Services";
    public static final String PACKAGE_IMPORTED_TYPES = "Imported Types";
    public static final String PACKAGE_LIBRARIES = "Libraries";
    private Helpers helpers;
    private HashMap<String, BridgePackage> packageMap;

    protected Helpers getHelpers() {
        return this.helpers;
    }

    protected PackagesFactory(Helpers helpers) {
        this.helpers = helpers;
        this.packageMap = new HashMap();
    }

    public void reset() {
        this.packageMap.clear();
    }

    public BridgePackage getPackage(String key) {
        return this.getPackage(key, null);
    }

    public final BridgePackage getPackage(String key, BridgeStereotype stereotype) {
        BridgePackage result = this.packageMap.get(this.createFullQualifiedKey(key));
        if (result == null && (result = this.findPackage(key, stereotype)) != null) {
            this.addPackage(result);
        }
        return result;
    }

    public BridgePackage getPackage(BridgePackage parent, String name, BridgeStereotype stereotype) {
        return this.getPackage(parent.getKey() + '/' + name, stereotype);
    }

    public BridgePackage createPackages(String key, BridgePackage parent, BridgeStereotype stereotype) {
        String[] names;
        if (key.startsWith(this.getRootPackage().getKey() + '/')) {
            key = key.substring(this.getRootPackage().getKey().length() + 1);
        }
        for (String s : names = key.split("/")) {
            parent = this.createPackage(s, parent, stereotype);
        }
        return parent;
    }

    public BridgePackage getInternalComponentDiagramPackage() {
        BridgePackage componentPackage = this.getComponentDiagramPackage();
        if (componentPackage.getModule() != null) {
            componentPackage = this.createPackages(PACKAGE_COMPONENT, this.getRootPackage(), this.getHelpers().getStereotypeFactory().getStereotype("Repository"));
        }
        return componentPackage;
    }

    public BridgePackage getInternalDeploymentDiagramPackage() {
        BridgePackage deploymentPackage = this.getDeploymentDiagramPackage();
        if (deploymentPackage.getModule() != null) {
            deploymentPackage = this.createPackages(PACKAGE_DEPLOYMENT, this.getRootPackage(), this.getHelpers().getStereotypeFactory().getStereotype("Repository"));
        }
        return deploymentPackage;
    }

    protected void addPackage(BridgePackage bridgePackage) {
        String key = this.createFullQualifiedKey(bridgePackage.getKey());
        if (bridgePackage.getModule() != null) {
            key = bridgePackage.getModule().getName() + '/' + key;
        }
        this.packageMap.put(key, bridgePackage);
    }

    private String createFullQualifiedKey(String key) {
        String rootKey = this.getRootPackage().getKey();
        if (rootKey == null) {
            rootKey = this.getRootPackage().getName();
            this.getRootPackage().setKey(rootKey);
        }
        if (!key.startsWith(rootKey)) {
            key = rootKey + '/' + key;
        }
        return key;
    }

    protected BridgePackage internalGetPackage(String key) {
        return this.packageMap.get(key);
    }

    protected BridgePackage createPackage(String name, BridgePackage parent, BridgeStereotype stereotype) {
        BridgePackage result = new BridgePackage(name, null, this.getHelpers());
        result.setKey(parent.getKey() + '/' + name);
        result.setStereotype(stereotype);
        parent.addPackage(result);
        this.addPackage(result);
        return result;
    }

    public abstract List<BridgePackage> getRepositoryPackages();

    public abstract List<BridgePackage> getInternalRootPackages();

    public abstract BridgePackage getDeploymentDiagramPackage();

    public abstract BridgePackage getComponentDiagramPackage();

    public abstract BridgePackage createRootPackage();

    public abstract void setElementPackage(UmlElement var1, Object var2);

    public abstract void setStereotypePackage(BridgeStereotype var1);

    protected abstract BridgePackage findPackage(String var1, BridgeStereotype var2);

    public abstract BridgePackage getRootPackage();

    public abstract void createReference(BridgePackage var1) throws Exception;
}

