/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.LogicalPathGenerator;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Module {
    private String name;
    private String moduleId;
    private String extender;
    private String extenderVersion;
    private ArrayList<String> mountPoints;
    private URI uri;
    private Helpers helpers;

    public Helpers getHelpers() {
        return this.helpers;
    }

    protected Module(String name, Helpers helpers) {
        this(name, name, helpers);
    }

    protected Module(String name, String moduleId, Helpers helpers) {
        this.name = name;
        this.moduleId = moduleId;
        this.helpers = helpers;
        this.mountPoints = new ArrayList();
    }

    public String getName() {
        return this.name;
    }

    public String getExtender() {
        return this.extender;
    }

    public void setExtender(String extender) {
        this.extender = extender;
    }

    public String getExtenderVersion() {
        return this.extenderVersion;
    }

    public void setExtenderVersion(String extenderVersion) {
        this.extenderVersion = extenderVersion;
    }

    public boolean containsMountPoint(String mountPointID) {
        return this.mountPoints.contains(mountPointID);
    }

    public ArrayList<String> getMountPoints() {
        return this.mountPoints;
    }

    public void addMountPointId(String mountPointId) {
        if (!this.mountPoints.contains(mountPointId)) {
            this.mountPoints.add(mountPointId);
        }
    }

    public URI getURI() {
        return this.uri;
    }

    public void setURI(URI uri) {
        this.uri = uri;
    }

    public boolean equals(Object obj) {
        return obj != null && super.equals(obj);
    }

    public Element toXmi(Document ownerDocument, String rootElementID, String modelFolder) {
        Element moduleElement = ownerDocument.createElement("module");
        moduleElement.setAttribute("autoloadType", "ALWAYS_LOAD");
        moduleElement.setAttribute("loadIndex", "false");
        moduleElement.setAttribute("readOnly", "true");
        moduleElement.setAttribute("requiredVersion", "-1");
        LogicalPathGenerator path = new LogicalPathGenerator(System.getProperty("ch.e2e.builder.application.home"), modelFolder);
        String uri = path.translate(this.uri);
        moduleElement.setAttribute("resource", uri);
        moduleElement.setAttribute("moduleId", this.moduleId);
        Collections.sort(this.mountPoints);
        for (String mountPoint : this.mountPoints) {
            Element mountElement = ownerDocument.createElement("mount");
            mountElement.setAttribute("mountPoint", mountPoint);
            if (rootElementID != null) {
                mountElement.setAttribute("mountedOn", rootElementID);
            }
            moduleElement.appendChild(mountElement);
        }
        return moduleElement;
    }
}

