/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.base.tools.XmiIDFactory;
import ch.e2e.builder.compiler.uml.Activity;
import ch.e2e.builder.compiler.uml.ArrayAccessException;
import ch.e2e.builder.compiler.uml.BridgeClass;
import ch.e2e.builder.compiler.uml.BridgePackage;
import ch.e2e.builder.compiler.uml.BridgeParameter;
import ch.e2e.builder.compiler.uml.Comment;
import ch.e2e.builder.compiler.uml.Direction;
import ch.e2e.builder.compiler.uml.ElementWithVisibility;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.Module;
import ch.e2e.builder.compiler.uml.TypedElement;
import ch.e2e.builder.compiler.uml.UmlElement;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BridgeOperation
extends UmlElement
implements Comparable,
TypedElement,
ElementWithVisibility,
Cloneable {
    private BridgeParameter returnType;
    private boolean isStatic = false;
    private boolean isAbstract = false;
    private String visibility = "public";
    private boolean fromContext = false;
    private Method method;
    private Boolean nameBasedOperationSyntax = false;

    public BridgeOperation(String name, Comment comment, Helpers helpers) {
        super(name, comment, helpers);
        this.setName(name);
        this.method = new EmptyMethod();
    }

    public void setNamedBasedOperationSyntax(Boolean nameBasedOperationSyntax) {
        this.nameBasedOperationSyntax = nameBasedOperationSyntax;
    }

    public void addParameter(BridgeParameter parameter) {
        this.getAllChildren().add(parameter);
        if (parameter.getDirection().equals((Object)Direction.RETURN)) {
            this.returnType = parameter;
        }
    }

    public ArrayList<UmlElement> getParameters() {
        return this.getAllChildren();
    }

    public void setParameters(ArrayList<UmlElement> parameters) {
        this.setChildren(parameters);
        for (UmlElement param : parameters) {
            if (!((BridgeParameter)param).getDirection().equals((Object)Direction.RETURN)) continue;
            this.returnType = (BridgeParameter)param;
        }
    }

    public BridgeParameter getReturnType() {
        if (this.returnType == null && this.isFromContext()) {
            BridgeParameter out = null;
            int n = 0;
            for (UmlElement p : this.getParameters()) {
                if (!((BridgeParameter)p).getDirection().equals((Object)Direction.OUT)) continue;
                out = (BridgeParameter)p;
                ++n;
            }
            if (n == 1) {
                this.returnType = out;
            }
        }
        return this.returnType;
    }

    @Override
    public boolean isArray() {
        return this.getReturnType().isArray();
    }

    @Override
    public int compareTo(Object o) {
        return o instanceof BridgeOperation ? this.getName().compareToIgnoreCase(((BridgeOperation)o).getName()) : 0;
    }

    public void setMethod(Activity activity) {
        this.method = new Method(activity);
    }

    @Override
    protected String getXMIElementName() {
        return "ownedOperation";
    }

    @Override
    public Element toChildXMI(Document ownerDocument, XmiIDFactory xmiIDFactory) {
        Element result = this.toXMI(ownerDocument, xmiIDFactory);
        this.method.toXmi(result, xmiIDFactory);
        return result;
    }

    public boolean equals(Object obj) {
        return obj instanceof BridgeOperation && this.equals((BridgeOperation)obj);
    }

    private boolean equals(BridgeOperation other) {
        boolean equal;
        boolean bl = equal = this.getName().equals(other.getName()) && this.getParameters().size() == other.getParameters().size();
        if (equal) {
            int length = this.getParameters().size();
            for (int i = 0; i < length && equal; ++i) {
                equal = this.getParameters().get(i).equals(other.getParameters().get(i));
            }
        }
        return equal;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public boolean isFromContext() {
        return this.fromContext;
    }

    public void setFromContext(boolean fromContext) {
        this.fromContext = fromContext;
    }

    @Override
    public String getSignature() {
        StringBuilder signature = new StringBuilder(this.getName() + "(");
        BridgeParameter returnParam = this.getReturnType();
        boolean firstParam = true;
        for (UmlElement p : this.getParameters()) {
            BridgeParameter bridgeParam = (BridgeParameter)p;
            if (bridgeParam.getDirection() == Direction.OUT || bridgeParam.getDirection() == Direction.RETURN) {
                if (returnParam != null) continue;
                returnParam = bridgeParam;
                continue;
            }
            if (firstParam) {
                signature.append(bridgeParam.getSignature());
                firstParam = false;
                continue;
            }
            signature.append(", ").append(bridgeParam.getSignature());
        }
        signature.append(")");
        if (returnParam != null) {
            BridgeClass type;
            if (returnParam.isArray()) {
                try {
                    type = returnParam.getArrayElementType();
                    signature.append(type == null ? " : [no type]" : type.getSignature()).append("[]");
                }
                catch (ArrayAccessException e) {
                    throw new IllegalStateException(e);
                }
            } else {
                type = returnParam.getTypeClass();
                signature.append(type == null ? " : [no type]" : type.getSignature());
            }
        }
        return signature.toString();
    }

    public String getNameBasedSignature() {
        StringBuilder signature = new StringBuilder(this.getName() + "(");
        boolean firstIn = true;
        for (UmlElement p : this.getParameters()) {
            BridgeParameter param = (BridgeParameter)p;
            if (firstIn) {
                signature.append(param.getName());
                firstIn = false;
                continue;
            }
            signature.append(", ").append(param.getName());
        }
        signature.append(")");
        return signature.toString();
    }

    @Override
    public BridgeClass getArrayElementType() throws ArrayAccessException {
        BridgeParameter returnType = this.getReturnType();
        return returnType == null ? null : returnType.getArrayElementType();
    }

    @Override
    public BridgeClass getTypeClass() {
        BridgeParameter r = this.getReturnType();
        return r == null ? null : r.getTypeClass();
    }

    @Override
    public void setTypeClass(BridgeClass type) {
    }

    @Override
    public List<Module> getAllUsedModules() {
        ArrayList<Module> result = new ArrayList<Module>();
        ArrayList<UmlElement> children = this.getAllChildren();
        for (UmlElement child : children) {
            BridgeClass type = ((BridgeParameter)child).getTypeClass();
            if (type == null || type.getModule() == null || result.contains(type.getModule())) continue;
            result.add(type.getModule());
        }
        return result;
    }

    @Override
    public List<UmlElement> getAllChildrenUsingOtherModule() {
        ArrayList<UmlElement> result = new ArrayList<UmlElement>();
        ArrayList<UmlElement> children = this.getAllChildren();
        for (UmlElement child : children) {
            BridgeClass type = ((BridgeParameter)child).getTypeClass();
            if (type == null || result.contains(type)) continue;
            result.add(type);
        }
        return result;
    }

    @Override
    public String getVisibility() {
        return this.visibility;
    }

    @Override
    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    @Override
    protected Element createXMIElement(String elementName, Document ownerDocument, XmiIDFactory xmiIDFactory) {
        Element element = ownerDocument.createElement(elementName);
        element.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:type", "uml:" + this.getBaseclass());
        String name = this.getName();
        if (name != null) {
            element.setAttribute("name", name);
        }
        element.setAttribute("visibility", this.visibility);
        element.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:id", this.getXmiID());
        this.appendDescription(element, ownerDocument, xmiIDFactory);
        if (this.isStatic) {
            element.setAttribute("isStatic", "true");
        }
        if (this.isAbstract) {
            element.setAttribute("isAbstract", "true");
        }
        this.method.toXmi(element, xmiIDFactory);
        return element;
    }

    @Override
    public String getBaseclass() {
        return "Operation";
    }

    @Override
    protected String getIdKey() {
        String result = this.nameBasedOperationSyntax != false ? this.getNameBasedSignature() : this.getSignature();
        BridgePackage owningPackage = null;
        for (UmlElement parent = this.getParent(); parent != null; parent = parent.getParent()) {
            result = parent.getName() + result;
            owningPackage = parent.getOwningPackage();
        }
        result = this.getOwningPackageKey(owningPackage) + result;
        return result;
    }

    @Override
    public String toString() {
        StringBuilder signature = new StringBuilder(this.getName() + "(");
        boolean firstIn = true;
        for (UmlElement p : this.getParameters()) {
            BridgeParameter param = (BridgeParameter)p;
            if (param.getDirection() == Direction.OUT || param.getDirection() == Direction.RETURN) continue;
            if (firstIn) {
                signature.append(param.getName());
                firstIn = false;
                continue;
            }
            signature.append(", ").append(param.getName());
        }
        signature.append(")");
        return signature.toString();
    }

    public BridgeOperation createImplementationCopy(Module module) {
        BridgeOperation operation = new BridgeOperation(this.getName(), new Comment("", this.getHelpers()), this.getHelpers());
        operation.isStatic = this.isStatic;
        operation.isAbstract = this.isAbstract;
        operation.visibility = this.visibility;
        operation.fromContext = this.fromContext;
        if (this.returnType != null) {
            operation.returnType = this.returnType.createCopy(module);
        }
        this.copyStereotypesAndProperties(operation);
        operation.setModule(module);
        for (UmlElement child : this.getParameters()) {
            BridgeParameter copy = ((BridgeParameter)child).createCopy(module);
            if (copy.getName().equals("self")) {
                copy.setName("_self");
            }
            operation.addParameter(copy);
        }
        return operation;
    }

    private class EmptyMethod
    extends Method {
        public EmptyMethod() {
            super(null);
        }

        @Override
        protected void toXmi(Element operation, XmiIDFactory xmiIDFactory) {
        }
    }

    private class Method {
        private Activity activity;

        public Method(Activity activity) {
            this.activity = activity;
        }

        protected void toXmi(Element operation, XmiIDFactory xmiIDFactory) {
            Element method = operation.getOwnerDocument().createElement("method");
            method.setAttribute("idref", this.activity.getXmiID());
            operation.appendChild(method);
        }
    }
}

