/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.base.tools.XmiIDFactory;
import ch.e2e.builder.compiler.uml.BridgeDependency;
import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.Comment;
import ch.e2e.builder.compiler.uml.DeploymentElement;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.Module;
import ch.e2e.builder.compiler.uml.UmlElement;
import java.util.ArrayList;
import javax.swing.Icon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BridgeInstance
extends DeploymentElement {
    private DeploymentElement classifierArtifact;
    private boolean selectable;

    public BridgeInstance(String name, Comment comment, Helpers helpers) {
        super(name, comment, (BridgeStereotype)null, helpers);
    }

    public BridgeInstance(DeploymentElement classifierArtifact, Helpers helpers) {
        super("", new Comment("", helpers), helpers.getStereotypeFactory().getStereotype("E2EDeploymentInstance"), helpers);
        this.classifierArtifact = classifierArtifact;
    }

    public DeploymentElement getClassifierArtifact() {
        return this.classifierArtifact;
    }

    public void setClassifierArtifact(DeploymentElement classifierArtifact) {
        this.classifierArtifact = classifierArtifact;
    }

    @Override
    public String toDisplayText() {
        return super.getName().length() == 0 && this.classifierArtifact != null ? this.classifierArtifact.getName() : super.getName();
    }

    @Override
    public boolean isSelectable() {
        return this.selectable;
    }

    @Override
    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    @Override
    public Icon getIcon() {
        return this.classifierArtifact.getIcon();
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    public ArrayList<BridgeDependency> getDependencies() {
        ArrayList<BridgeDependency> result = new ArrayList<BridgeDependency>(this.classifierArtifact.getBridgeDependencies().getDependencies());
        for (UmlElement child : this.classifierArtifact.getChildren()) {
            result.addAll(((DeploymentElement)child).getBridgeDependencies().getDependencies());
        }
        return result;
    }

    @Override
    public Element toChildXMI(Document ownerDocument, XmiIDFactory xmiIDFactory) {
        Element deployment = ownerDocument.createElement("deployment");
        deployment.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:type", "uml:Deployment");
        deployment.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:id", this.getXmiID() + "Deployment");
        deployment.setAttribute("visibility", "public");
        Element supplier = ownerDocument.createElement("supplier");
        supplier.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:idref", this.getXmiID());
        deployment.appendChild(supplier);
        Element client = ownerDocument.createElement("client");
        client.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:idref", this.getParent().getXmiID());
        deployment.appendChild(client);
        Element artifact = ownerDocument.createElement("deployedArtifact");
        artifact.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:idref", this.getXmiID());
        deployment.appendChild(artifact);
        return deployment;
    }

    @Override
    protected void addClassifierDependency(Document ownerDocument, Element xmiElement, XmiIDFactory xmiIDFactory) {
        if (this.classifierArtifact != null) {
            Element classifierElement = ownerDocument.createElement("classifier");
            if (this.checkModule(this.classifierArtifact.getModule())) {
                classifierElement.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:idref", this.classifierArtifact.getXmiID());
            } else {
                Module module = this.classifierArtifact.getModule();
                classifierElement.setAttribute("href", module.getName() + '#' + this.classifierArtifact.getXmiID());
                classifierElement.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:type", "uml:" + this.classifierArtifact.getBaseclass());
                Element xmiExtension = ownerDocument.createElementNS("http://schema.omg.org/spec/XMI/2.1", "xmi:Extension");
                classifierElement.appendChild(xmiExtension);
                xmiExtension.setAttribute("extender", module.getExtender() + ' ' + module.getExtenderVersion());
                xmiExtension.setAttribute("extenderID", module.getExtender() + ' ' + module.getExtenderVersion());
                Element referenceExtension = ownerDocument.createElement("referenceExtension");
                referenceExtension.setAttribute("referentPath", this.classifierArtifact.getQualifiedName());
                referenceExtension.setAttribute("referentType", this.classifierArtifact.getBaseclass());
                xmiExtension.appendChild(referenceExtension);
            }
            xmiElement.appendChild(classifierElement);
        }
    }

    @Override
    public String getBaseclass() {
        return "InstanceSpecification";
    }

    @Override
    public String toString() {
        return this.toDisplayText();
    }

    @Override
    public UmlElement[] getAdditionalElements() {
        return new UmlElement[]{this.classifierArtifact};
    }
}

