/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.resource;

import java.io.File;
import java.io.IOException;
import java.util.TreeSet;

public class ResourceContainer
extends File {
    private TreeSet<File> children;
    private String name;
    private File archive;

    public ResourceContainer(String name, File archive) {
        super("");
        this.name = name;
        this.archive = archive;
        this.children = new TreeSet();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.getName();
    }

    @Override
    public String getAbsolutePath() {
        return this.getName();
    }

    @Override
    public File getAbsoluteFile() {
        return this;
    }

    @Override
    public File getCanonicalFile() throws IOException {
        return this;
    }

    @Override
    public String getCanonicalPath() throws IOException {
        return this.archive.getParentFile().getCanonicalPath();
    }

    @Override
    public File getParentFile() {
        return this.archive;
    }

    public TreeSet<File> getChildren() {
        return this.children;
    }

    public void addChild(File child) {
        this.children.add(child);
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public boolean isAbsolute() {
        return true;
    }
}

