/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types.substitutions;

import ch.e2e.builder.compiler.build.types.substitutions.JavaVariable;
import ch.e2e.builder.compiler.build.types.substitutions.Variable;

public class JavaMemoryVariable
extends Variable
implements JavaVariable {
    public JavaMemoryVariable(String name, String friendlyId, String label, String defaultValue, String type) {
        super(name, friendlyId, label, defaultValue, type, null);
    }

    @Override
    public void mergeDefaultValue(String value) {
        int oldSize;
        int newSize = this.readMemorySize(value.substring(4).trim());
        if (newSize > (oldSize = this.readMemorySize(this.getDefaultValue().substring(4).trim()))) {
            this.setDefaultValue(value);
        }
    }

    private int readMemorySize(String value) {
        char unit = value.charAt(value.length() - 1);
        int heap = Integer.parseInt(value.substring(0, value.length() - 1));
        if (unit == 'm' || unit == 'M') {
            heap *= 1000000;
        } else if (unit == 'k' || unit == 'K') {
            heap *= 1000;
        }
        return heap;
    }

    @Override
    public String getMergeStrategyName() {
        return "JavaOption";
    }
}

