/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types;

import ch.e2e.builder.compiler.build.types.E2EBuilderDataType;
import ch.e2e.builder.compiler.build.types.XmiFile;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.builder.compiler.error.DocumentErrorHandler;
import java.io.File;

public class Xmi2Exmi
implements E2EBuilderDataType {
    private XmiFile srcfile;
    private File targetFile;

    public Xmi2Exmi(UmlDocument document) {
        this.srcfile = new XmiFile(document);
        this.targetFile = document.getBridgeXmiFile();
    }

    @Override
    public boolean isUpToDate(CompilableObject configuration) {
        boolean upToDate = this.targetFile.exists();
        if (upToDate) {
            upToDate = this.srcfile.lastModified() < this.targetFile.lastModified();
            UmlDocument umlDocument = this.srcfile.getUmlDocument();
            if (upToDate && umlDocument != null) {
                DocumentErrorHandler errorHandler = umlDocument.getErrorHandler();
                File errorLogfile = errorHandler.getLogfile();
                upToDate = !errorLogfile.exists() || errorLogfile.lastModified() > umlDocument.lastModified();
            }
        }
        return upToDate;
    }

    public XmiFile getSrcfile() {
        return this.srcfile;
    }

    public File getTargetFile() {
        return this.targetFile;
    }
}

