/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2angular.clean;

import ch.e2e.builder.compiler.build.tasks.constants.Folders;
import ch.e2e.builder.compiler.build.tasks.model.model2angular.clean.AngularCleanWorkspaceTask;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.document.json.bpmn.BpmnDefinitions;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class AngularTaskProjectCleanTask
extends AngularCleanWorkspaceTask {
    public static Boolean select(String id) {
        return id.endsWith("angular/task.clean");
    }

    public AngularTaskProjectCleanTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> result = super.getSourceSet();
        result.addAll(this.getBpmnIds());
        return super.getSourceSet();
    }

    @Override
    protected Set<String> getProjectDirectories() {
        return this.getBpmnFileNames().stream().map(bpmnName -> Folders.angular_projects_PROJECT_src_app_process_PROCESS_tasks(this.getAngularProjectName(), bpmnName)).collect(Collectors.toSet());
    }

    @Override
    protected Set<String> getUpToDateProjects() throws Exception {
        HashSet<String> result = new HashSet<String>();
        this.getBpmnIds().forEach(id -> {
            BpmnDefinitions bpmnDefinitions = ((JsonDocumentSource)this.getSourceManager().getSource((String)id)).getJsonDocument(BpmnDefinitions.class);
            if (bpmnDefinitions != null && bpmnDefinitions.getProcess() != null) {
                bpmnDefinitions.getProcess().forEach(bpmnProcess -> {
                    if (bpmnProcess.getUserTask() != null) {
                        bpmnProcess.getUserTask().forEach(bpmnUserTask -> {
                            if (bpmnUserTask.getExtensionElements() != null && bpmnUserTask.getExtensionElements().getForm() != null && bpmnUserTask.getExtensionElements().getForm().getForm() != null && !bpmnUserTask.getExtensionElements().getForm().getForm().equals("")) {
                                result.add(Folders.angular_projects_PROJECT_src_app_process_PROCESS_tasks_TASK(this.getAngularProjectName(), bpmnProcess.getName(), bpmnUserTask.getName()));
                            }
                        });
                    }
                });
            }
        });
        return result;
    }

    private Set<String> getBpmnFileNames() {
        try {
            return Files.walk(this.getSourceManager().getProjectFolder().toPath().resolve("bpmn"), new FileVisitOption[0]).map(Path::getFileName).map(Path::toString).filter(fileName -> fileName.endsWith(".bpmn.json")).map(bpmn -> bpmn.replace(".bpmn.json", "")).collect(Collectors.toSet());
        }
        catch (IOException e) {
            return Collections.emptySet();
        }
    }

    private Set<String> getBpmnIds() {
        return this.getBpmnFileNames().stream().map(ch.e2e.builder.compiler.build.tasks.constants.Files::bpmn__PROCESS_bpmn_xml).collect(Collectors.toSet());
    }
}

