/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.libraries;

import ch.e2e.builder.compiler.build.UnzipTask;
import ch.e2e.builder.compiler.build.tasks.constants.Files;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;

public class UnzipLibraryTask
extends UnzipTask {
    public static Boolean select(String id) {
        return id.endsWith(".library.zip.file.list");
    }

    public UnzipLibraryTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected Set<String> getSourceSet() {
        HashSet<String> set = new HashSet<String>();
        set.add(this.getSourceId());
        return set;
    }

    @Override
    protected String getDestinationFileExtension() {
        return ".library.zip.file.list";
    }

    @Override
    protected String getSourceId() {
        return this.getDestinationFilePathWithoutExtension() + ".library.xlib";
    }

    @Override
    protected String getEntryTargetPath(ZipEntry zipEntry) {
        if (zipEntry.getName().endsWith(".lrep")) {
            return Files.libs__LIBRARY_lrep(this.getDestinationFileNameWithoutExtension());
        }
        if (zipEntry.getName().endsWith(".tgz")) {
            return "angular/libraries/" + zipEntry.getName();
        }
        return super.getEntryTargetPath(zipEntry);
    }
}

