/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model;

import ch.e2e.builder.compiler.build.tasks.constants.Files;
import ch.e2e.builder.compiler.build.tasks.model.XmlPartsExtractionTask;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.document.JsonDocument;
import ch.e2e.builder.compiler.utils.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.jaxb.JAXBContextFactory;

public class BpmnExtractionTask
extends XmlPartsExtractionTask
implements JsonDocumentSource {
    public static Boolean select(String id) {
        return id.endsWith(".userTask.bpmnPart.xml");
    }

    public BpmnExtractionTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected String getDestinationFileExtension() {
        return ".bpmnPart.xml";
    }

    @Override
    protected String getSourcePath() {
        return Files.bpmn__PROCESS_bpmn_xml(this.getDestinationFile().getParentFile().getName());
    }

    @Override
    protected Set<String> getPartsToExtractXpath() {
        HashSet<String> xpaths = new HashSet<String>();
        String elementTypeSearch = StringUtils.substringAfter(this.getDestinationFileNameWithoutExtension(), ".");
        String elementName = StringUtils.substringBefore(this.getDestinationFileNameWithoutExtension(), ".");
        xpaths.add(String.format("//bpmn:definitions/bpmn:process/bpmn:%s[@name = '%s']", elementTypeSearch, elementName));
        return xpaths;
    }

    @Override
    protected Map<String, String> getNamespaces() {
        Map<String, String> namespaces = super.getNamespaces();
        namespaces.put("bpmn", "http://www.omg.org/spec/BPMN/20100524/MODEL");
        return namespaces;
    }

    @Override
    public <T extends JsonDocument> T getJsonDocument(Class<T> type) {
        try {
            JAXBContext jaxbContext = JAXBContextFactory.createContext((Class[])new Class[]{type}, new HashMap());
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            return (T)((JsonDocument)jaxbUnmarshaller.unmarshal((Source)new StreamSource(this.getDestinationFile()), type).getValue());
        }
        catch (Exception exception) {
            return null;
        }
    }
}

