/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks;

import ch.e2e.ant.AntStarter;
import ch.e2e.bridge.server.JavaAddOn;
import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.base.error.BuilderException;
import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CompileConfigurationTask;
import ch.e2e.builder.compiler.build.tasks.JarfileNotFoundException;
import ch.e2e.builder.compiler.build.tasks.Logging;
import ch.e2e.builder.compiler.build.tasks.control.CompileControl;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.builder.compiler.error.DefaultCompilerError;
import ch.e2e.builder.compiler.error.JavaCompileError;
import ch.e2e.dom.DomUtilities;
import ch.e2e.io.FileUtilities;
import ch.e2e.io.OutputDestination;
import ch.e2e.io.SystemErrRedirector;
import ch.e2e.io.SystemOutRedirector;
import ch.e2e.logging.PerformanceLogger;
import ch.e2e.resource.Properties;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JavaWrapperCompilerTask
extends CompileConfigurationTask {
    private CompilerOutput compilerOut = new CompilerOutput();
    private CompilerOutput compilerErr = new CompilerOutput();
    private FileFilter javaFileFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.getAbsolutePath().endsWith(".java");
        }
    };

    public JavaWrapperCompilerTask() {
        super(new CompileControl[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        long start = PerformanceLogger.start((String)this.getCompilerId(), (String)this.getUmlDocument().getName());
        boolean outEnabled = SystemOutRedirector.getInstance().isEnabled();
        boolean errEnabled = SystemErrRedirector.getInstance().isEnabled();
        try {
            SystemOutRedirector.getInstance().addOutputDestination((OutputDestination)this.compilerOut);
            SystemOutRedirector.getInstance().setEnabled(true);
            SystemErrRedirector.getInstance().addOutputDestination((OutputDestination)this.compilerErr);
            SystemErrRedirector.getInstance().setEnabled(true);
            this.buildWrapperJar();
        }
        catch (JarfileNotFoundException e) {
            this.showError(e.getMessage());
            HashMap<String, String> parameter = new HashMap<String, String>();
            parameter.put("absolute path", e.getMessage());
            DefaultCompilerError error = new DefaultCompilerError("error.jarfile.to.deploy.not.found", parameter);
            this.getErrorHandler().error((AbstractBuilderError)error);
        }
        catch (org.apache.tools.ant.BuildException e) {
            this.showError(e.getMessage());
            String details = this.compilerErr.messages.toString();
            JavaCompileError error = new JavaCompileError(details.length() == 0 ? e.getMessage() : details);
            this.getErrorHandler().error((AbstractBuilderError)error);
        }
        catch (Throwable ex) {
            String message = ex.getMessage();
            this.showFatalError(message);
            ex.printStackTrace();
            BuilderException exception = new BuilderException("error.build.exception", ex);
            this.getErrorHandler().error((AbstractBuilderError)exception);
        }
        finally {
            SystemOutRedirector.getInstance().removeOutputDestination((OutputDestination)this.compilerOut);
            SystemOutRedirector.getInstance().setEnabled(outEnabled);
            SystemErrRedirector.getInstance().removeOutputDestination((OutputDestination)this.compilerErr);
            SystemErrRedirector.getInstance().setEnabled(errEnabled);
        }
        PerformanceLogger.stop((String)this.getCompilerId(), (String)this.getUmlDocument().getName(), (long)start);
    }

    @Override
    protected String getCompilerId() {
        return "java.wrapper.compiler";
    }

    private void buildWrapperJar() throws IOException, ParserConfigurationException, SAXException, TransformerException {
        File folder = this.getUmlDocument().getDocumentWorkingFolder();
        ArrayList<String> sources = this.createSources(this.getUmlDocument());
        if (sources.size() > 0) {
            File wrapperFolder = new File(folder, "wrapper");
            File buildFile = new File(wrapperFolder, "build.xml");
            if (!buildFile.exists()) {
                this.copyBuildFile(buildFile, sources);
            }
            for (CompilableObject compilableObject : this.getCompilableObjects()) {
                Properties properties = new Properties();
                String classpath = this.createClasspath(compilableObject.getJarfiles());
                properties.setProperty("classpath", classpath);
                properties.setProperty("jarfile", "wrapper.jar");
                File releaseFolder = new File(folder, "wrapper/lib");
                properties.setProperty("release.folder", releaseFolder.getAbsolutePath());
                properties.setProperty("sources", sources);
                try {
                    Logging.logger.info("using the classloader " + this.getClass().getClassLoader() + " to load 'ch.e2e.ant.AntStarter'");
                    Logging.logger.info("classpath = " + classpath);
                    this.getClass().getClassLoader().loadClass("ch.e2e.ant.AntStarter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                AntStarter.getInstance().start(buildFile, properties);
            }
        }
    }

    private ArrayList<String> createSources(UmlDocument umlDocument) {
        ArrayList<String> sources = new ArrayList<String>();
        this.addDocumentSourcefolders(umlDocument, sources, new ArrayList<String>());
        return sources;
    }

    private void addDocumentSourcefolders(UmlDocument umlDocument, ArrayList<String> sources, ArrayList<String> checkedDocuments) {
        checkedDocuments.add(umlDocument.getUniqueId());
        File sourceFolder = new File(umlDocument.getDocumentWorkingFolder(), "wrapper/src");
        if (sourceFolder.exists() && FileUtilities.getFileList((File)sourceFolder, (FileFilter)this.javaFileFilter, (boolean)true).length > 0) {
            sources.add(sourceFolder.getAbsolutePath());
        }
        for (String id : umlDocument.getDocumentInfo().getDependsFile().getIncludesFiles().keySet()) {
            if (checkedDocuments.contains(id)) continue;
            this.addDocumentSourcefolders(this.getUmlDocumentFactory().getUmlDocumentById(id), sources, checkedDocuments);
        }
    }

    private void copyBuildFile(File buildFile, ArrayList<String> sources) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        String buildFileTemplate = this.getProperty("wrapper.buildfile");
        Document document = DomUtilities.parseFromClasspath((String)buildFileTemplate, (boolean)false, (boolean)false, (boolean)false);
        NodeList javacElements = document.getDocumentElement().getElementsByTagName("javac");
        if (javacElements != null && javacElements.getLength() == 1) {
            Element javacElement = (Element)javacElements.item(0);
            for (String s : sources) {
                Element src = document.createElement("src");
                src.setAttribute("path", s);
                javacElement.appendChild(src);
            }
        }
        DomUtilities.serialize((File)buildFile, (Document)document, (boolean)true);
    }

    private String createClasspath(String[] jarfiles) throws JarfileNotFoundException {
        String pathSeparator = System.getProperty("path.separator", ";");
        String addonPath = JavaAddOn.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        try {
            addonPath = URLDecoder.decode(JavaAddOn.class.getProtectionDomain().getCodeSource().getLocation().getPath(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        StringBuilder classpath = new StringBuilder(addonPath).append(pathSeparator);
        File jarfileFolder = this.getUmlDocument().getSettings().getJarFolder();
        for (String jarfileName : jarfiles) {
            File jarfile = new File(jarfileFolder, jarfileName);
            if (!jarfile.exists()) continue;
            classpath.append(jarfile.getAbsolutePath()).append(pathSeparator);
        }
        return classpath.toString();
    }

    @Override
    public String toString() {
        return "javaWrapperCompile";
    }

    private class CompilerOutput
    implements OutputDestination {
        private StringBuffer messages = new StringBuffer();

        private CompilerOutput() {
        }

        public void println() {
            this.messages.append("\n");
        }

        public void println(String outString) {
            this.messages.append(outString).append("\n");
        }

        public void print(String outString) {
            this.messages.append(outString);
        }
    }
}

