/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.dom4j;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.option.dom4j.DOM4JDocumentWrapper;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.util.SteppingNavigator;
import net.sf.saxon.tree.util.SteppingNode;
import net.sf.saxon.tree.wrapper.AbstractNodeWrapper;
import net.sf.saxon.tree.wrapper.SiblingCountingNode;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;

public class DOM4JNodeWrapper
extends AbstractNodeWrapper
implements SiblingCountingNode,
SteppingNode<DOM4JNodeWrapper> {
    protected Node node;
    protected short nodeKind;
    private DOM4JNodeWrapper parent;
    protected int index;

    protected DOM4JNodeWrapper(Node node, DOM4JNodeWrapper parent, int index) {
        this.node = node;
        this.parent = parent;
        this.index = index;
    }

    protected static DOM4JNodeWrapper makeWrapper(Node node, DOM4JDocumentWrapper docWrapper) {
        return DOM4JNodeWrapper.makeWrapper(node, docWrapper, null, -1);
    }

    protected static DOM4JNodeWrapper makeWrapper(Node node, DOM4JDocumentWrapper docWrapper, DOM4JNodeWrapper parent, int index) {
        DOM4JNodeWrapper wrapper;
        Short nodeType = node.getNodeType();
        switch (nodeType) {
            case 1: {
                wrapper = new DOM4JNodeWrapper(node, parent, index);
                wrapper.nodeKind = 1;
                break;
            }
            case 2: {
                wrapper = new DOM4JNodeWrapper(node, parent, index);
                wrapper.nodeKind = (short)2;
                break;
            }
            case 3: 
            case 4: {
                wrapper = new DOM4JNodeWrapper(node, parent, index);
                wrapper.nodeKind = (short)3;
                break;
            }
            case 9: {
                wrapper = (DOM4JNodeWrapper)docWrapper.getRootNode();
                if (wrapper != null) break;
                wrapper = new DOM4JNodeWrapper(node, parent, index);
                wrapper.nodeKind = (short)9;
                break;
            }
            case 8: {
                wrapper = new DOM4JNodeWrapper(node, parent, index);
                wrapper.nodeKind = (short)8;
                break;
            }
            case 7: {
                wrapper = new DOM4JNodeWrapper(node, parent, index);
                wrapper.nodeKind = (short)7;
                break;
            }
            case 13: {
                wrapper = new DOM4JNodeWrapper(node, parent, index);
                wrapper.nodeKind = (short)13;
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad node type in dom4j! " + node.getClass() + " instance " + node);
            }
        }
        wrapper.treeInfo = docWrapper;
        return wrapper;
    }

    @Override
    public DOM4JDocumentWrapper getTreeInfo() {
        return (DOM4JDocumentWrapper)this.treeInfo;
    }

    public Node getUnderlyingNode() {
        return this.node;
    }

    @Override
    public int getNodeKind() {
        return this.nodeKind;
    }

    @Override
    public String getSystemId() {
        return this.getTreeInfo().getSystemId();
    }

    @Override
    public void setSystemId(String uri) {
        this.getTreeInfo().setSystemId(uri);
    }

    @Override
    public int compareOrder(NodeInfo other) {
        if (other instanceof SiblingCountingNode) {
            return Navigator.compareOrder(this, (SiblingCountingNode)other);
        }
        return -other.compareOrder(this);
    }

    @Override
    public CharSequence getStringValueCS() {
        return DOM4JNodeWrapper.getStringValue(this.node);
    }

    private static String getStringValue(Node node) {
        Short nodeType = node.getNodeType();
        switch (nodeType) {
            case 1: 
            case 9: {
                return node.getStringValue();
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                return node.getText();
            }
            case 13: {
                return ((Namespace)node).getURI();
            }
        }
        return "";
    }

    @Override
    public String getLocalPart() {
        switch (this.nodeKind) {
            case 1: 
            case 2: {
                return this.node.getName();
            }
            case 3: 
            case 8: 
            case 9: {
                return "";
            }
            case 7: {
                return ((ProcessingInstruction)this.node).getTarget();
            }
            case 13: {
                return ((Namespace)this.node).getPrefix();
            }
        }
        return null;
    }

    @Override
    public String getPrefix() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getNamespacePrefix();
            }
            case 2: {
                return ((Attribute)this.node).getNamespacePrefix();
            }
        }
        return "";
    }

    @Override
    public String getURI() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getNamespaceURI();
            }
            case 2: {
                return ((Attribute)this.node).getNamespaceURI();
            }
        }
        return "";
    }

    @Override
    public String getDisplayName() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getQualifiedName();
            }
            case 2: {
                return ((Attribute)this.node).getQualifiedName();
            }
            case 7: 
            case 13: {
                return this.getLocalPart();
            }
        }
        return "";
    }

    @Override
    public DOM4JNodeWrapper getParent() {
        Branch parenti;
        if (this.parent == null && (parenti = DOM4JNodeWrapper.getInternalParent(this.node, (DOM4JNodeWrapper)this.treeInfo.getRootNode())) != null) {
            this.parent = DOM4JNodeWrapper.makeWrapper((Node)parenti, this.getTreeInfo());
            return this.parent;
        }
        return this.parent;
    }

    private static Branch getInternalParent(Node node, DOM4JNodeWrapper container) {
        if (node.getNodeType() == 9) {
            return null;
        }
        Element e = node.getParent();
        if (e != null) {
            return e;
        }
        Document d = node.getDocument();
        if (d != null) {
            return d;
        }
        return DOM4JDocumentWrapper.searchForParent((Branch)container.node, node);
    }

    @Override
    public int getSiblingPosition() {
        if (this.index == -1) {
            NodeInfo n;
            AxisIterator iter;
            int ix = 0;
            this.getParent();
            switch (this.nodeKind) {
                case 1: 
                case 3: 
                case 7: 
                case 8: {
                    DOM4JNodeWrapper parent = this.getParent();
                    List children = parent.getNodeKind() == 9 ? ((Document)parent.node).content() : ((Element)parent.node).content();
                    for (Object n2 : children) {
                        if (n2 == this.node) {
                            this.index = ix;
                            return this.index;
                        }
                        ++ix;
                    }
                    throw new IllegalStateException("DOM4J node not linked to parent node");
                }
                case 2: {
                    iter = this.parent.iterateAxis((byte)2);
                    break;
                }
                case 13: {
                    iter = this.parent.iterateAxis((byte)8);
                    break;
                }
                default: {
                    this.index = 0;
                    return this.index;
                }
            }
            while ((n = iter.next()) != null) {
                if (n.equals(this)) {
                    this.index = ix;
                    return this.index;
                }
                ++ix;
            }
            throw new IllegalStateException("DOM4J node not linked to parent node");
        }
        return this.index;
    }

    @Override
    protected AxisIterator iterateAttributes(NodeTest nodeTest) {
        return new Navigator.AxisFilter(new AttributeEnumeration(this), nodeTest);
    }

    @Override
    protected AxisIterator iterateChildren(NodeTest nodeTest) {
        if (this.hasChildNodes()) {
            return new Navigator.AxisFilter(new ChildEnumeration(this, true, true), nodeTest);
        }
        return EmptyIterator.OfNodes.THE_INSTANCE;
    }

    @Override
    protected AxisIterator iterateSiblings(NodeTest nodeTest, boolean forwards) {
        return new Navigator.AxisFilter(new ChildEnumeration(this, false, forwards), nodeTest);
    }

    @Override
    protected AxisIterator iterateDescendants(NodeTest nodeTest, boolean includeSelf) {
        if (includeSelf) {
            return new SteppingNavigator.DescendantAxisIterator<DOM4JNodeWrapper>(this, true, nodeTest);
        }
        if (this.hasChildNodes()) {
            return new SteppingNavigator.DescendantAxisIterator<DOM4JNodeWrapper>(this, false, nodeTest);
        }
        return EmptyIterator.OfNodes.THE_INSTANCE;
    }

    @Override
    public String getAttributeValue(String uri, String local) {
        if (this.nodeKind == 1) {
            for (Object o : ((Element)this.node).attributes()) {
                Attribute att = (Attribute)o;
                if (!att.getName().equals(local) || !att.getNamespaceURI().equals(uri)) continue;
                return att.getValue();
            }
        }
        return null;
    }

    @Override
    public NodeInfo getRoot() {
        return this.treeInfo.getRootNode();
    }

    @Override
    public boolean hasChildNodes() {
        switch (this.nodeKind) {
            case 9: {
                return true;
            }
            case 1: {
                return ((Branch)this.node).nodeCount() > 0;
            }
        }
        return false;
    }

    @Override
    public void generateId(FastStringBuffer buffer) {
        Navigator.appendSequentialKey(this, buffer, true);
    }

    @Override
    public DOM4JNodeWrapper getNextSibling() {
        Branch parenti = (Branch)this.getParent().node;
        int count = parenti.nodeCount();
        int i = parenti.indexOf(this.node);
        if (++i < count) {
            return DOM4JNodeWrapper.makeWrapper(parenti.node(i), this.getTreeInfo());
        }
        return null;
    }

    @Override
    public DOM4JNodeWrapper getPreviousSibling() {
        Branch parenti = (Branch)this.getParent().node;
        int i = parenti.indexOf(this.node);
        if (--i >= 0) {
            return DOM4JNodeWrapper.makeWrapper(parenti.node(i), this.getTreeInfo());
        }
        return null;
    }

    @Override
    public DOM4JNodeWrapper getFirstChild() {
        Node nodei = this.node;
        if (nodei.hasContent()) {
            int count = ((Branch)nodei).nodeCount();
            for (int i = 0; i < count; ++i) {
                Node child = ((Branch)nodei).node(i);
                if (child.getNodeType() == 13 || child.getNodeType() == 2) continue;
                return DOM4JNodeWrapper.makeWrapper(child, this.getTreeInfo(), this, 0);
            }
        }
        return null;
    }

    @Override
    public DOM4JNodeWrapper getSuccessorElement(DOM4JNodeWrapper anchor, String uri, String local) {
        Node stop = anchor == null ? null : anchor.node;
        Node next = this.node;
        while ((next = DOM4JNodeWrapper.getFollowingNode(next, stop, (DOM4JNodeWrapper)this.treeInfo.getRootNode())) != null && (next.getNodeType() != 1 || uri != null && !uri.equals(((Element)next).getNamespaceURI()) || local != null && !local.equals(next.getName()))) {
        }
        if (next == null) {
            return null;
        }
        return DOM4JNodeWrapper.makeWrapper(next, this.getTreeInfo());
    }

    private static Node getFollowingNode(Node start, Node anchor, DOM4JNodeWrapper container) {
        int i;
        if (start.hasContent()) {
            int count = ((Branch)start).nodeCount();
            for (i = 0; i < count; ++i) {
                Node child = ((Branch)start).node(i);
                if (child.getNodeType() == 13 || child.getNodeType() == 2) continue;
                return child;
            }
        }
        if (start == anchor) {
            return null;
        }
        Node p = start;
        Branch q;
        while ((q = DOM4JNodeWrapper.getInternalParent(p, container)) != null) {
            i = q.indexOf(p) + 1;
            if (i < q.nodeCount()) {
                return q.node(i);
            }
            if (q == anchor) {
                return null;
            }
            p = q;
        }
        return null;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof DOM4JNodeWrapper)) {
            return false;
        }
        DOM4JNodeWrapper ow = (DOM4JNodeWrapper)other;
        if (this.node instanceof Namespace) {
            return this.getLocalPart().equals(ow.getLocalPart()) && this.getParent().equals(ow.getParent());
        }
        return this.node.equals(ow.node);
    }

    @Override
    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] buffer) {
        if (this.node instanceof Element) {
            Element elem = (Element)this.node;
            List namespaces = elem.declaredNamespaces();
            if (namespaces == null || namespaces.isEmpty()) {
                return NamespaceBinding.EMPTY_ARRAY;
            }
            int count = namespaces.size();
            if (count == 0) {
                return NamespaceBinding.EMPTY_ARRAY;
            }
            NamespaceBinding[] result = buffer == null || count > buffer.length ? new NamespaceBinding[count] : buffer;
            int n = 0;
            for (Namespace namespace : namespaces) {
                String prefix = namespace.getPrefix();
                String uri = namespace.getURI();
                result[n++] = new NamespaceBinding(prefix, uri);
            }
            if (count < result.length) {
                result[count] = null;
            }
            return result;
        }
        return null;
    }

    private final class ChildEnumeration
    implements AxisIterator {
        private DOM4JNodeWrapper start;
        private DOM4JNodeWrapper commonParent;
        private ListIterator<Node> children;
        private int ix = 0;
        private boolean downwards;
        private boolean forwards;

        public ChildEnumeration(DOM4JNodeWrapper start, boolean downwards, boolean forwards) {
            this.start = start;
            this.downwards = downwards;
            this.forwards = forwards;
            this.commonParent = downwards ? start : start.getParent();
            this.children = this.commonParent.getNodeKind() == 9 ? ((Document)this.commonParent.node).content().listIterator() : ((Element)this.commonParent.node).content().listIterator();
            if (downwards) {
                if (!forwards) {
                    while (this.children.hasNext()) {
                        this.children.next();
                        ++this.ix;
                    }
                }
            } else {
                this.ix = start.getSiblingPosition();
                if (forwards) {
                    for (int i = 0; i <= this.ix; ++i) {
                        this.children.next();
                    }
                    ++this.ix;
                } else {
                    for (int i = 0; i < this.ix; ++i) {
                        this.children.next();
                    }
                    --this.ix;
                }
            }
        }

        @Override
        public NodeInfo next() {
            if (this.forwards) {
                if (this.children.hasNext()) {
                    Node nextChild = this.children.next();
                    if (nextChild instanceof DocumentType || nextChild instanceof Namespace) {
                        ++this.ix;
                        return this.next();
                    }
                    if (nextChild instanceof Entity) {
                        throw new IllegalStateException("Unexpanded entity in DOM4J tree");
                    }
                    return DOM4JNodeWrapper.makeWrapper(nextChild, DOM4JNodeWrapper.this.getTreeInfo(), this.commonParent, this.ix++);
                }
                return null;
            }
            if (this.children.hasPrevious()) {
                Node nextChild = this.children.previous();
                if (nextChild instanceof DocumentType || nextChild instanceof Namespace) {
                    --this.ix;
                    return this.next();
                }
                if (nextChild instanceof Entity) {
                    throw new IllegalStateException("Unexpanded entity in DOM4J tree");
                }
                return DOM4JNodeWrapper.makeWrapper(nextChild, DOM4JNodeWrapper.this.getTreeInfo(), this.commonParent, this.ix--);
            }
            return null;
        }
    }

    private final class AttributeEnumeration
    implements AxisIterator {
        private Iterator<Node> atts;
        private int ix = 0;
        private DOM4JNodeWrapper start;

        public AttributeEnumeration(DOM4JNodeWrapper start) {
            this.start = start;
            this.atts = ((Element)start.node).attributes().iterator();
        }

        @Override
        public final NodeInfo next() {
            if (this.atts.hasNext()) {
                return DOM4JNodeWrapper.makeWrapper(this.atts.next(), DOM4JNodeWrapper.this.getTreeInfo(), this.start, this.ix++);
            }
            return null;
        }
    }
}

