/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.border.BevelBorder;

public class RoundBevelBorder
extends BevelBorder {
    public RoundBevelBorder(int bevelType) {
        super(bevelType);
    }

    public RoundBevelBorder(int bevelType, Color highlight, Color shadow) {
        super(bevelType, highlight, shadow);
    }

    public RoundBevelBorder(int bevelType, Color highlightOuterColor, Color highlightInnerColor, Color shadowOuterColor, Color shadowInnerColor) {
        super(bevelType, highlightOuterColor, highlightInnerColor, shadowOuterColor, shadowInnerColor);
    }

    @Override
    protected void paintRaisedBevel(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.translate(x, y);
        g.setColor(this.getHighlightOuterColor(c));
        g.drawLine(0, 4, 0, height - 6);
        g.drawLine(4, 0, width - 5, 0);
        g.drawArc(0, 0, 8, 8, 90, 90);
        g.drawArc(0, height - 9, 8, 8, 180, 90);
        g.setColor(this.getHighlightInnerColor(c));
        g.drawLine(1, 4, 1, height - 6);
        g.drawLine(5, 1, width - 6, 1);
        g.drawArc(1, 1, 6, 6, 90, 90);
        g.drawArc(1, height - 8, 6, 6, 180, 90);
        g.setColor(this.getShadowOuterColor(c));
        g.drawLine(4, height - 1, width - 6, height - 1);
        g.drawLine(width - 1, 5, width - 1, height - 5);
        g.drawArc(width - 9, 0, 8, 8, 0, 90);
        g.drawArc(width - 9, height - 9, 8, 8, 270, 90);
        g.setColor(this.getShadowInnerColor(c));
        g.drawLine(4, height - 2, width - 6, height - 2);
        g.drawLine(width - 2, 5, width - 2, height - 5);
        g.drawArc(width - 8, 1, 6, 6, 0, 90);
        g.drawArc(width - 8, height - 8, 6, 6, 270, 90);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    @Override
    protected void paintLoweredBevel(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.translate(x, y);
        g.setColor(this.getShadowInnerColor(c));
        g.drawLine(0, 4, 0, height - 5);
        g.drawLine(4, 0, width - 5, 0);
        g.drawArc(0, 0, 8, 8, 90, 90);
        g.drawArc(0, height - 9, 8, 8, 180, 90);
        g.setColor(this.getShadowOuterColor(c));
        g.drawLine(1, 4, 1, height - 5);
        g.drawLine(4, 1, width - 5, 1);
        g.drawArc(1, 1, 6, 6, 90, 90);
        g.drawArc(1, height - 8, 6, 6, 180, 90);
        g.setColor(this.getHighlightOuterColor(c));
        g.drawLine(5, height - 1, width - 5, height - 1);
        g.drawLine(width - 1, 5, width - 1, height - 6);
        g.drawArc(width - 9, 0, 8, 8, 0, 90);
        g.drawArc(width - 10, height - 10, 8, 8, 270, 90);
        g.setColor(this.getHighlightInnerColor(c));
        g.drawLine(5, height - 2, width - 6, height - 2);
        g.drawLine(width - 2, 6, width - 2, height - 6);
        g.drawArc(width - 9, 1, 6, 6, 0, 90);
        g.drawArc(width - 9, height - 9, 6, 6, 270, 90);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }
}

