/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import ch.e2e.print.PrintJob;
import ch.e2e.print.PrintTools;
import ch.e2e.resource.ImageLoader;
import ch.e2e.swing.DialogConstants;
import ch.e2e.swing.InputDoubleField;
import ch.e2e.swing.ModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Comparator;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class PrintDialog
extends ModalDialog
implements DialogConstants {
    private static PrintDialog printDialog;
    private static PrintService[] printServices;
    private static PrintService printService;
    private OrientationRequested orientation = OrientationRequested.PORTRAIT;
    private JRadioButton portrait;
    private JRadioButton landscape;
    private MarginSelection left;
    private MarginSelection right;
    private MarginSelection top;
    private MarginSelection bottom;
    private JComboBox printerBox;
    private JComboBox paperBox;
    private MediaSizeName page = MediaSizeName.ISO_A4;
    private MediaPrintableArea printableArea;

    private PrintDialog(JDialog owner, Icon icon) {
        super((Dialog)owner, translator.getTranslation("printdialog.title"), translator.getTranslation("printdialog.internaltitle"), translator.getTranslation("printdialog.subtitle"), icon == null ? ImageLoader.loadIcon((String)"ch/e2e/swing/print.icon.gif", (boolean)false, (ClassLoader)PrintDialog.class.getClassLoader()) : icon, 3);
        this.initialize();
    }

    private PrintDialog(Frame owner, Icon icon) {
        super(owner, translator.getTranslation("printdialog.title"), translator.getTranslation("printdialog.internaltitle"), translator.getTranslation("printdialog.subtitle"), icon == null ? ImageLoader.loadIcon((String)"ch/e2e/swing/print.icon.gif", (boolean)false, (ClassLoader)PrintDialog.class.getClassLoader()) : icon, 3);
        this.initialize();
    }

    private void initialize() {
        this.createGui();
    }

    public static PrintJob printDialog(JFrame owner) {
        return PrintDialog.showPrintDialog(PrintDialog.getPrintDialog(owner, null));
    }

    public static PrintJob printDialog(JFrame owner, Icon icon) {
        return PrintDialog.showPrintDialog(PrintDialog.getPrintDialog(owner, icon));
    }

    public static PrintJob printDialog(Frame owner) {
        return PrintDialog.showPrintDialog(PrintDialog.getPrintDialog(owner, null));
    }

    public static PrintJob printDialog(Frame owner, Icon icon) {
        return PrintDialog.showPrintDialog(PrintDialog.getPrintDialog(owner, icon));
    }

    public static PrintJob printDialog(JDialog owner) {
        return PrintDialog.showPrintDialog(PrintDialog.getPrintDialog(owner, null));
    }

    public static PrintJob printDialog(JDialog owner, Icon icon) {
        return PrintDialog.showPrintDialog(PrintDialog.getPrintDialog(owner, icon));
    }

    private static PrintJob showPrintDialog(PrintDialog printDialog) {
        PrintJob result = null;
        printDialog.printerBox.setSelectedItem(printService);
        printDialog.paperBox.setSelectedItem(printDialog.page);
        int close = printDialog.showDialog();
        if (close == 1) {
            printService = (PrintService)printDialog.printerBox.getSelectedItem();
            HashPrintRequestAttributeSet printAttributeSet = new HashPrintRequestAttributeSet();
            printDialog.orientation = printDialog.getOrientation();
            printAttributeSet.add(printDialog.orientation);
            printAttributeSet.add(new Copies(1));
            HashDocAttributeSet docAttributeSet = new HashDocAttributeSet();
            printDialog.page = (MediaSizeName)printDialog.paperBox.getSelectedItem();
            docAttributeSet.add(printDialog.page);
            printDialog.printableArea = printDialog.getPrintableArea();
            docAttributeSet.add(printDialog.printableArea);
            result = new PrintJob(printService.createPrintJob(), printAttributeSet, docAttributeSet);
        }
        return result;
    }

    private static PrintDialog getPrintDialog(JFrame owner, Icon icon) {
        if (printDialog == null) {
            printDialog = new PrintDialog((Frame)owner, icon);
        } else if (!printDialog.getOwner().equals(owner)) {
            printDialog = new PrintDialog((Frame)owner, icon);
        }
        return printDialog;
    }

    private static PrintDialog getPrintDialog(Frame owner, Icon icon) {
        if (printDialog == null) {
            printDialog = new PrintDialog(owner, icon);
        } else if (!printDialog.getOwner().equals(owner)) {
            printDialog = new PrintDialog(owner, icon);
        }
        return printDialog;
    }

    private static PrintDialog getPrintDialog(JDialog owner, Icon icon) {
        if (printDialog == null) {
            printDialog = new PrintDialog(owner, icon);
        } else if (!printDialog.getOwner().equals(owner)) {
            printDialog = new PrintDialog(owner, icon);
        }
        return printDialog;
    }

    private OrientationRequested getOrientation() {
        OrientationRequested result = this.portrait.isSelected() ? OrientationRequested.PORTRAIT : OrientationRequested.LANDSCAPE;
        return result;
    }

    private MediaPrintableArea getPrintableArea() {
        float left = this.left.getValue(1000);
        float right = this.right.getValue(1000);
        float top = this.top.getValue(1000);
        float bottom = this.bottom.getValue(1000);
        MediaSize pageSize = MediaSize.getMediaSizeForName(this.page);
        float width = pageSize.getSize(1000)[0];
        float height = pageSize.getSize(1000)[1];
        return new MediaPrintableArea(left, top, width - left - right, height - top - bottom, 1000);
    }

    private void createGui() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 5, 5);
        c.fill = 0;
        c.anchor = 18;
        this.add((Component)new JLabel(translator.getTranslation("printdialog.printer")), c);
        this.printerBox = new JComboBox<PrintService>(printServices);
        this.printerBox.setRenderer(new PrinterBoxCellRenderer());
        this.printerBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PrintDialog.this.printerChanged();
            }
        });
        c.weightx = 1.0;
        c.fill = 2;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.printerBox, c);
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 0;
        c.insets = new Insets(0, 0, 5, 5);
        this.add((Component)new JLabel(translator.getTranslation("printdialog.pagesize")), c);
        c.weightx = 1.0;
        c.fill = 2;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 5, 0);
        this.paperBox = new JComboBox<MediaSizeName>(this.getMediaSizeNames());
        this.paperBox.setRenderer(new PaperBoxCellRenderer());
        this.paperBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PrintDialog.this.paperChanged();
            }
        });
        this.add((Component)this.paperBox, c);
        this.add((Component)this.createOrientationPanel(), c);
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.createMarginPanel(), c);
    }

    private MediaSizeName[] getMediaSizeNames() {
        return new MediaSizeName[]{MediaSizeName.ISO_A5, MediaSizeName.ISO_A4, MediaSizeName.ISO_A3, MediaSizeName.NA_LETTER};
    }

    private void printerChanged() {
    }

    private void paperChanged() {
        this.page = (MediaSizeName)this.paperBox.getSelectedItem();
        this.fillPageFormatFields();
    }

    private JPanel createOrientationPanel() {
        JPanel orientation = new JPanel(new GridLayout(2, 1));
        orientation.setBorder(new TitledBorder(translator.getTranslation("printdialog.orientation")));
        ButtonGroup orientationGroup = new ButtonGroup();
        this.portrait = new JRadioButton(translator.getTranslation("printdialog.portrait"));
        orientationGroup.add(this.portrait);
        orientation.add(this.portrait);
        this.landscape = new JRadioButton(translator.getTranslation("printdialog.landscape"));
        orientationGroup.add(this.landscape);
        orientation.add(this.landscape);
        return orientation;
    }

    private JPanel createMarginPanel() {
        JPanel margins = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 0, 5, 5);
        margins.setBorder(new TitledBorder(translator.getTranslation("printdialog.margins")));
        c.gridwidth = 1;
        margins.add((Component)new JLabel(translator.getTranslation("printdialog.left"), 2), c);
        this.left = new MarginSelection(200.0);
        margins.add((Component)this.left, c);
        c.insets = new Insets(5, 15, 5, 5);
        margins.add((Component)new JLabel(translator.getTranslation("printdialog.right"), 2), c);
        this.right = new MarginSelection(200.0);
        c.insets = new Insets(5, 0, 5, 5);
        c.gridwidth = 0;
        margins.add((Component)this.right, c);
        c.gridwidth = 1;
        margins.add((Component)new JLabel(translator.getTranslation("printdialog.top"), 2), c);
        this.top = new MarginSelection(200.0);
        margins.add((Component)this.top, c);
        c.insets = new Insets(5, 15, 5, 5);
        margins.add((Component)new JLabel(translator.getTranslation("printdialog.bottom"), 2), c);
        c.insets = new Insets(5, 0, 5, 5);
        c.gridwidth = 0;
        this.bottom = new MarginSelection(200.0);
        margins.add((Component)this.bottom, c);
        return margins;
    }

    private void fillPageFormatFields() {
        if (this.orientation == OrientationRequested.PORTRAIT) {
            this.portrait.setSelected(true);
        } else {
            this.landscape.setSelected(true);
        }
        if (this.printableArea != null) {
            float left = this.printableArea.getX(1000);
            this.left.setValue(left, 1000);
            float width = this.printableArea.getWidth(1000);
            this.right.setValue(width - left, 1000);
            float top = this.printableArea.getY(1000);
            this.top.setValue(top, 1000);
            float height = this.printableArea.getWidth(1000);
            this.bottom.setValue(height - top, 1000);
        } else {
            this.left.setValue(15.0f, 1000);
            this.right.setValue(15.0f, 1000);
            this.top.setValue(10.0f, 1000);
            this.bottom.setValue(10.0f, 1000);
        }
    }

    static {
        DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        printServices = PrintServiceLookup.lookupPrintServices(flavor, null);
        Arrays.sort(printServices, new PrintServiceComparator());
        printService = PrintServiceLookup.lookupDefaultPrintService();
    }

    private static class PrintServiceComparator
    implements Comparator {
        private PrintServiceComparator() {
        }

        public int compare(Object o1, Object o2) {
            PrintService p1 = (PrintService)o1;
            PrintService p2 = (PrintService)o2;
            return p1.getName().compareTo(p2.getName());
        }
    }

    private static class MarginSelection
    extends JPanel
    implements ItemListener {
        private static final Object[] units = new Object[]{ModalDialog.translator.getTranslation("printdialog.milimeter"), ModalDialog.translator.getTranslation("printdialog.inches")};
        private int lastSelectedIndex = 0;
        private JComboBox unitSelection;
        private InputDoubleField size;

        private MarginSelection(double max) {
            super(new BorderLayout(5, 5));
            this.createGui(max);
        }

        private void createGui(double max) {
            this.size = new InputDoubleField(0.0, max);
            this.add((Component)this.size, "Center");
            this.unitSelection = new JComboBox<Object>(units);
            this.add((Component)this.unitSelection, "East");
            this.unitSelection.addItemListener(this);
        }

        private void setValue(float value, int unit) {
            if (unit == 1000) {
                this.size.setValue(this.lastSelectedIndex == 0 ? (double)value : (double)((float)PrintTools.milimeter2Inches(value)));
            } else if (unit == 25400) {
                this.size.setValue(this.lastSelectedIndex == 0 ? (double)((float)PrintTools.inches2Milimeter(value)) : (double)value);
            }
        }

        public float getValue(int unit) {
            float result = 0.0f;
            if (unit == 1000) {
                result = this.lastSelectedIndex == 0 ? (float)this.size.getValue() : (float)PrintTools.inches2Milimeter(this.size.getValue());
            } else if (unit == 25400) {
                result = this.lastSelectedIndex == 0 ? (float)PrintTools.milimeter2Inches(this.size.getValue()) : (float)this.size.getValue();
            }
            return result;
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            double actualValue = this.size.getValue();
            if (this.lastSelectedIndex != this.unitSelection.getSelectedIndex()) {
                this.lastSelectedIndex = this.unitSelection.getSelectedIndex();
                if (this.lastSelectedIndex == 0) {
                    this.size.setValue(PrintTools.inches2Milimeter(actualValue));
                } else {
                    this.size.setValue(PrintTools.milimeter2Inches(actualValue));
                }
            }
        }
    }

    private class PaperBoxCellRenderer
    extends DefaultListCellRenderer {
        private PaperBoxCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            MediaSize size = MediaSize.getMediaSizeForName((MediaSizeName)value);
            String name = value.toString();
            int i = name.indexOf("-");
            String type = i == -1 ? "" : name.substring(0, i);
            name = name.substring(i + 1).toUpperCase();
            value = type.equalsIgnoreCase("na") ? name + " (" + size.getSize(25400)[0] + " x " + size.getSize(25400)[1] + " inch)" : name + " (" + size.getSize(1000)[0] + " x " + size.getSize(1000)[1] + " mm)";
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    private class PrinterBoxCellRenderer
    extends DefaultListCellRenderer {
        private PrinterBoxCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            value = ((PrintService)value).getName();
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

