/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.test.options;

import ch.e2e.test.options.Option;
import ch.e2e.test.options.StringOption;
import ch.e2e.util.StringTools;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class StringListOption
extends Option<Collection<StringOption>> {
    private String elementName;

    public StringListOption(String name, int index) {
        this(name, (Collection<StringOption>)new ArrayList<StringOption>(), index);
    }

    public StringListOption(String name, Collection<StringOption> defaultValue, int index) {
        this(name, "string", defaultValue, index);
    }

    public StringListOption(String name, String elementName, Collection<StringOption> defaultValue, int index) {
        super(name, defaultValue, index);
        this.elementName = elementName;
    }

    public void add(String value) {
        this.add(value, false);
    }

    public void add(String value, boolean inherited) {
        if (this.getValue() == null) {
            this.setValue((Collection<StringOption>)new ArrayList<StringOption>());
        }
        StringOption string = new StringOption(this.elementName, this.elementName, null, ((Collection)this.getValue()).size());
        string.setValue(value);
        string.setInherited(inherited);
        ((Collection)this.getValue()).add(string);
    }

    public boolean contains(String value) {
        boolean result;
        block1: {
            StringOption option;
            result = false;
            if (this.getValue() == null) break block1;
            Iterator iterator = ((Collection)this.getValue()).iterator();
            while (iterator.hasNext() && !(result = ((String)(option = (StringOption)iterator.next()).getValue()).equals(value))) {
            }
        }
        return result;
    }

    @Override
    public void setValue(Collection<StringOption> value) {
        if (value != null) {
            value = new ArrayList<StringOption>(value);
        }
        super.setValue(value);
    }

    @Override
    public Collection<StringOption> createValue(String valueString) {
        ArrayList<StringOption> result = null;
        if (valueString != null) {
            result = new ArrayList<StringOption>();
            try {
                String[] strings;
                for (String s : strings = StringTools.createStringArray((String)valueString)) {
                    StringOption string = new StringOption(this.elementName, this.elementName, null, ((Collection)this.getValue()).size());
                    string.setValue(s);
                    result.add(string);
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public Collection<String> getStringValues() {
        Collection value;
        ArrayList<String> result = new ArrayList<String>();
        Collection collection = value = this.getValue() == null ? (Collection)this.getDefaultValue() : (Collection)this.getValue();
        if (value != null) {
            for (StringOption option : value) {
                if (option.getValue() == null) continue;
                result.add((String)option.getValue());
            }
        }
        return result;
    }

    @Override
    public void setInherited(boolean inherited) {
        if (this.getValue() != null) {
            for (StringOption option : (Collection)this.getValue()) {
                option.setInherited(inherited);
            }
        }
    }

    @Override
    public Collection<StringOption> createCopyOfValue() {
        ArrayList<StringOption> copiedValue = null;
        if (this.getValue() != null) {
            copiedValue = new ArrayList<StringOption>();
            for (StringOption option : (Collection)this.getValue()) {
                StringOption copy = (StringOption)option.createCopy();
                copiedValue.add(copy);
            }
        }
        return copiedValue;
    }

    @Override
    public Option<Collection<StringOption>> createCopyInstance() {
        StringListOption result = new StringListOption(this.getName(), this.getIndex());
        result.elementName = this.elementName;
        return result;
    }

    @Override
    public void merge(Option<Collection<StringOption>> copy) {
        if (copy.getValue() != null) {
            if (this.getValue() == null) {
                this.setValue(copy.getValue());
            } else {
                for (StringOption option : copy.getValue()) {
                    if (((Collection)this.getValue()).contains(option)) continue;
                    ((Collection)this.getValue()).add(option);
                }
            }
        }
    }
}

