/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.test.options;

import ch.e2e.test.TestDocumentPreprocessor;
import ch.e2e.test.options.FileOption;
import ch.e2e.test.options.Option;
import ch.e2e.test.options.StringOption;
import java.io.File;
import org.w3c.dom.Element;

public class PreprocessorOption
extends Option<TestDocumentPreprocessor> {
    private boolean indent;
    private StringOption scriptName;
    private FileOption scriptFile;
    private boolean enabled;

    public PreprocessorOption(String name, int index) {
        super(name, index);
        this.enabled = false;
        this.scriptName = new StringOption(name + "_scriptName", 0);
        this.scriptFile = new FileOption(name + " Script File", 0);
        this.indent = true;
    }

    public PreprocessorOption(String name, TestDocumentPreprocessor defaultValue, int index) {
        super(name, defaultValue, index);
        this.enabled = defaultValue.isEnabled();
        this.indent = defaultValue.isIndent();
        this.scriptName = new StringOption(name + "_scriptName", defaultValue.getScriptName(), 0);
        this.scriptFile = new FileOption(name + " Script File", defaultValue.getScriptFile(), 0);
    }

    @Override
    public TestDocumentPreprocessor createValue(String valueString) {
        TestDocumentPreprocessor result = new TestDocumentPreprocessor(this.scriptName.getValue() == null ? (String)this.scriptName.getDefaultValue() : (String)this.scriptName.getValue(), this.indent);
        result.setEnabled(this.enabled);
        result.setScriptFile(new File(valueString));
        return result;
    }

    public boolean isIndent() {
        return this.indent;
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    public String getScriptName() {
        return this.scriptName.getValue() == null ? (String)this.scriptName.getDefaultValue() : (String)this.scriptName.getValue();
    }

    public void setScriptName(String scriptName) {
        this.scriptName.setValue(scriptName);
    }

    public FileOption getScriptFile() {
        return this.scriptFile;
    }

    public void setScriptFile(File scriptFile) {
        this.scriptFile.setValue(scriptFile);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void setValue(TestDocumentPreprocessor value) {
        super.setValue(value);
        this.enabled = value != null && value.isEnabled();
        this.scriptName.setValue(value == null ? null : value.getScriptName());
        this.scriptFile.setValue(value == null ? null : value.getScriptFile());
        this.indent = value == null || value.isIndent();
    }

    @Override
    public Option<TestDocumentPreprocessor> createCopyInstance() {
        return new PreprocessorOption(this.getName(), this.getIndex());
    }

    @Override
    public TestDocumentPreprocessor createCopyOfValue() {
        TestDocumentPreprocessor result = null;
        TestDocumentPreprocessor preprocessor = (TestDocumentPreprocessor)this.getValue();
        if (preprocessor != null) {
            result = new TestDocumentPreprocessor(preprocessor.getScriptName(), preprocessor.isIndent());
            result.setEnabled(preprocessor.isEnabled());
            result.setScriptFile(preprocessor.getScriptFile());
            result.setLogFolder(preprocessor.getLogFolder());
        }
        return result;
    }

    @Override
    public void toXml(Element parent) {
        TestDocumentPreprocessor preprocessor = (TestDocumentPreprocessor)this.getValue();
        if (preprocessor != null) {
            preprocessor.toXml(parent);
        }
    }
}

