/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.test.options;

import ch.e2e.test.Utilities;
import ch.e2e.test.options.Option;

public class IntegerOption
extends Option<Integer> {
    private int minValue = Integer.MIN_VALUE;
    private int maxValue = Integer.MAX_VALUE;

    public IntegerOption(String name, int index) {
        super(name, index);
    }

    public IntegerOption(String name, String key, int index) {
        super(name, key, index);
    }

    public IntegerOption(String name, String key, Integer defaultValue, int index) {
        super(name, key, defaultValue, index);
    }

    public IntegerOption(String name, int defaultValue, int index) {
        super(name, defaultValue, index);
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    @Override
    public Integer createValue(String valueString) {
        return (Integer)Utilities.createValue(valueString, Integer.class);
    }

    @Override
    public Option<Integer> createCopyInstance() {
        IntegerOption result = new IntegerOption(this.getName(), this.getIndex());
        result.maxValue = this.maxValue;
        result.minValue = this.minValue;
        return result;
    }

    @Override
    public Integer createCopyOfValue() {
        return this.getValue() == null ? null : Integer.valueOf((Integer)this.getValue());
    }
}

