/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.test;

import ch.e2e.dom.DomUtilities;
import ch.e2e.test.TypeFactory;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class E2ETestSource {
    private String name;
    private Object value;
    private String type;
    private HashMap<String, ArrayList<Option>> options = new HashMap();

    public E2ETestSource(Element source) {
        this.name = source.getAttribute("name");
        this.type = source.hasAttribute("type") ? source.getAttribute("type") : "STRING";
        this.value = this.createValue(source, this.type);
        this.addOptions(source.getElementsByTagName("option"));
    }

    public boolean hasOption(String name) {
        return this.options.get(name) != null;
    }

    public Object getOption(String name) {
        Object result = null;
        ArrayList<Option> options = this.options.get(name);
        if (options != null && options.size() > 0) {
            result = options.get(0).getValue();
        }
        return result;
    }

    public ArrayList<Option> getOptions(String name) {
        return this.options.get(name);
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public Element toXml(Document ownerDocument) {
        Element source = ownerDocument.createElement("source");
        source.setAttribute("name", this.name);
        source.setAttribute("type", this.type);
        String value = this.value.toString();
        if (this.isSimpleString(value)) {
            source.setAttribute("value", value);
        } else {
            source.appendChild(ownerDocument.createTextNode(value));
        }
        return source;
    }

    public void cleanOut() {
        for (ArrayList<Option> list : this.options.values()) {
            list.clear();
        }
        this.options.clear();
    }

    private boolean isSimpleString(String value) {
        return value.indexOf(10) == -1 && value.indexOf(13) == -1 && value.indexOf(9) == -1;
    }

    private void addOptions(NodeList optionList) {
        if (optionList != null) {
            int length = optionList.getLength();
            for (int i = 0; i < length; ++i) {
                Element option = (Element)optionList.item(i);
                String name = option.getAttribute("name");
                ArrayList<Option> options = this.options.get(name);
                if (options == null) {
                    options = new ArrayList();
                    this.options.put(name, options);
                }
                String type = option.hasAttribute("type") ? option.getAttribute("type") : "STRING";
                options.add(new Option(type, this.createValue(option, type)));
            }
        }
    }

    private Object createValue(Element element, String type) {
        Object result = null;
        String value = element.hasAttribute("value") ? element.getAttribute("value") : DomUtilities.getTextValue((Element)element, (String)"");
        try {
            result = TypeFactory.getInstance().getType(type).newInstance(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public class Option {
        private String type;
        private Object value;

        public Option(String type, Object value) {
            this.type = type;
            this.value = value;
        }

        public String getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

