/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.uml.state;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.gui.event.OpenLinkEvent;
import ch.e2e.builder.trace.gui.event.SelectInTreeEvent;
import ch.e2e.builder.trace.gui.uml.AbstractCellAction;
import ch.e2e.builder.trace.gui.uml.CellWithContextMenu;
import ch.e2e.builder.trace.gui.uml.ContextMenu;
import ch.e2e.builder.trace.gui.uml.UmlCell;
import ch.e2e.builder.trace.gui.uml.UmlGraphConstants;
import ch.e2e.builder.trace.testcase.uml.GenericFlow;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import ch.e2e.event.EventController;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.util.EventObject;
import java.util.Map;

public class SignalCell
extends UmlCell
implements CellWithContextMenu {
    private static SignalContextMenu contextMenu;
    private GenericFlow flow;
    private E2EBuilderModule module;

    public SignalCell(Object userObject, E2EBuilderModule module) {
        super(userObject);
        this.module = module;
        this.setFlow(userObject);
        this.initialize();
    }

    @Override
    public E2EBuilderModule getModule() {
        return this.module;
    }

    private void setFlow(Object userObject) {
        if (userObject instanceof UmlObject) {
            int n = ((UmlObject)userObject).getChildCount();
            for (int i = 0; this.flow == null && i < n; ++i) {
                Object child = ((UmlObject)userObject).getChild(i);
                if (!(child instanceof GenericFlow)) continue;
                this.flow = (GenericFlow)child;
            }
        }
    }

    private void initialize() {
        UmlGraphConstants.setBackground((Map)this.attributes, (Color)UmlGraphConstants.WARNING_COLOR);
        UmlGraphConstants.setOpaque((Map)this.attributes, (boolean)true);
        UmlGraphConstants.setShowStereotype((Map)this.attributes, false);
        UmlGraphConstants.setVerticalAlignment((Map)this.attributes, (int)3);
        UmlGraphConstants.setBounds((Map)this.attributes, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, 120.0, 50.0));
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    public SignalContextMenu getContextMenu() {
        if (contextMenu == null) {
            contextMenu = new SignalContextMenu(this);
        }
        contextMenu.setCell(this);
        return contextMenu;
    }

    @Override
    public AbstractCellAction<? extends CellWithContextMenu> getDefaultAction() {
        return this.getContextMenu().getDefaultAction();
    }

    @Override
    public boolean isContextMenuAlwaysTriggered() {
        return false;
    }

    private static class SignalContextMenu
    extends ContextMenu<SignalCell> {
        public SignalContextMenu(SignalCell cell) {
            super(cell);
            this.createMenu();
        }

        @Override
        public void setCell(SignalCell cell) {
            super.setCell(cell);
            if (cell.flow != null) {
                this.setDefaultItem(this.getTranslation("uml.diagram.action.show.activity"));
            } else {
                this.setDefaultItem(this.getTranslation("uml.diagram.action.show.in.tree"));
            }
            this.setItemEnabled(this.getTranslation("uml.diagram.action.show.activity"), cell.flow != null);
        }

        private void createMenu() {
            this.addDefaultItem(new AbstractCellAction<SignalCell>(this.getTranslation("uml.diagram.action.show.in.tree")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object o = ((SignalCell)this.getCell()).getUserObject();
                    if (o instanceof UmlObject) {
                        EventController.fire((EventObject)new SelectInTreeEvent(this.getCell(), (UmlObject)o));
                    }
                }
            }, ACCELERATOR_SHOW_IN_TREE);
            this.addItem(new AbstractCellAction<SignalCell>(this.getTranslation("uml.diagram.action.show.activity")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GenericFlow flow = ((SignalCell)this.getCell()).flow;
                    if (flow != null) {
                        EventController.fire((EventObject)new OpenLinkEvent(this.getCell(), "file:///openActivity?activity=" + flow.getOriginalName()));
                    }
                }
            });
        }
    }
}

