/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.uml.activity;

import ch.e2e.builder.base.util.DateTimeUtil;
import ch.e2e.builder.trace.gui.uml.UmlGraphConstants;
import ch.e2e.builder.trace.gui.uml.UmlLineBorder;
import ch.e2e.builder.trace.gui.uml.activity.InfoCell;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.time.Instant;
import java.util.Map;
import javax.swing.JPanel;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.VertexView;

public class InfoView
extends VertexView {
    private static final InfoCellRenderer RENDERER = new InfoCellRenderer();

    public InfoView() {
    }

    public InfoView(Object cell) {
        super(cell);
    }

    public CellViewRenderer getRenderer() {
        return RENDERER;
    }

    protected static class InfoCellRenderer
    extends JPanel
    implements CellViewRenderer {
        private static final String DATE = "Date";
        private static final String LOCATION = "Location";
        private static final String TRACE_LEVEL = "Trace level";
        private static final String SERVER_VERSION = "Server version";
        private static final float TITLE_FONT_SIZE = 14.0f;
        private static final float BIG_FONT_SIZE = 20.0f;
        private static final int X = 0;
        private static final int Y = 0;
        private static final int WIDTH = 765;
        private static final int HEIGHT = 75;
        private static final int TITLE_WIDTH = 755;
        private static final int TITLE_X = 5;
        private static final int TITLE_Y = 5;
        private static final int TITLE_HEIGHT = 23;
        private static final int INFO_WIDTH = 755;
        private static final int INFO_HEIGHT = 36;
        private static final int INFO_X = 5;
        private static final int INFO_Y = 34;
        private static final int INFO1_X = 724;
        private static final int INFO_I_X = 739;
        private static final int INFO_I_Y = 60;
        private static final int INFO1_WIDTH = 36;
        private static final int INFO_LINE1_Y = 49;
        private static final int INFO_LINE2_Y = 64;
        private static final int LEFT_STRINGS_X = 10;
        private static final int TITLE_STRING_Y = 22;
        private Font normalFont;
        private Font titleFont;
        private Font boldFont;
        private Font bigFont;
        private Color borderColor;
        private int cornerRadius = -1;
        private String title;
        private String info;
        private String date;
        private String traceLevel;
        private String location;
        private String version;

        protected InfoCellRenderer() {
        }

        @Override
        public void paint(Graphics g) {
            Color color = g.getColor();
            this.normalFont = g.getFont();
            this.boldFont = this.getFont().deriveFont(1);
            this.titleFont = this.getFont().deriveFont(1, 14.0f);
            this.bigFont = this.getFont().deriveFont(1, 20.0f);
            this.paintBackground(g);
            this.paintTitle(g);
            this.paintInfo(g);
            this.setOpaque(false);
            g.setFont(this.normalFont);
            g.setColor(color);
        }

        private void paintBackground(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRoundRect(0, 0, 765, 75, this.cornerRadius, this.cornerRadius);
            g.setColor(this.borderColor);
            g.drawRoundRect(0, 0, 764, 74, this.cornerRadius, this.cornerRadius);
        }

        private void paintTitle(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g.setColor(UmlGraphConstants.LIGHT_GRAY);
            g2d.setPaint(new GradientPaint(5.0f, 5.0f, UmlGraphConstants.LIGHT_GRAY, 755.0f, 23.0f, UmlGraphConstants.DARK_GRAY));
            g.fillRoundRect(5, 5, 755, 23, this.cornerRadius, this.cornerRadius);
            g.setColor(Color.BLACK);
            g.drawRoundRect(5, 5, 754, 22, this.cornerRadius, this.cornerRadius);
            g.setFont(this.titleFont);
            g.drawString(this.title, 10, 22);
        }

        private void paintInfo(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            FontRenderContext frc = g2d.getFontRenderContext();
            g.setColor(UmlGraphConstants.LIGHT_GRAY);
            g.fillRoundRect(5, 34, 755, 36, this.cornerRadius, this.cornerRadius);
            g.setColor(Color.BLACK);
            g.drawRoundRect(5, 34, 754, 35, this.cornerRadius, this.cornerRadius);
            g.setColor(UmlGraphConstants.DARK_GRAY);
            g.fillRoundRect(724, 34, 36, 36, this.cornerRadius, this.cornerRadius);
            g.setColor(Color.BLACK);
            g.drawRoundRect(724, 34, 35, 35, this.cornerRadius, this.cornerRadius);
            g.setFont(this.boldFont);
            if (this.location.length() > 0) {
                TextLayout dateLabel = new TextLayout(DATE, this.boldFont, frc);
                TextLayout locationLabel = new TextLayout(LOCATION, this.boldFont, frc);
                TextLayout traceLevelLabel = new TextLayout(TRACE_LEVEL, this.boldFont, frc);
                TextLayout versionLabel = new TextLayout(SERVER_VERSION, this.boldFont, frc);
                TextLayout locationValue = new TextLayout(this.location, this.normalFont, frc);
                TextLayout traceLevelValue = new TextLayout(this.traceLevel, this.normalFont, frc);
                TextLayout versionValue = new TextLayout(this.version, this.normalFont, frc);
                int rightStringX = 724 - (int)(Math.max(traceLevelLabel.getBounds().getWidth(), versionLabel.getBounds().getWidth()) + Math.max(versionValue.getBounds().getWidth(), traceLevelValue.getBounds().getWidth())) - 25;
                int leftValuesX = 10 + (int)Math.max(dateLabel.getBounds().getWidth(), locationLabel.getBounds().getWidth()) + 20;
                int rightValuesX = rightStringX + (int)Math.max(traceLevelLabel.getBounds().getWidth(), versionLabel.getBounds().getWidth()) + 20;
                int leftValuesMaxWidth = rightStringX - leftValuesX - 25;
                int leftValuesWidth = (int)locationValue.getBounds().getWidth();
                if (leftValuesWidth > leftValuesMaxWidth) {
                    double factor = (double)leftValuesMaxWidth / (double)leftValuesWidth;
                    int length = (int)((double)this.location.length() * factor) - 4;
                    this.location = this.location.substring(0, length) + "...";
                }
                locationValue.getBounds().getWidth();
                dateLabel.draw(g2d, 10.0f, 49.0f);
                traceLevelLabel.draw(g2d, rightStringX, 49.0f);
                locationLabel.draw(g2d, 10.0f, 64.0f);
                versionLabel.draw(g2d, rightStringX, 64.0f);
                g.setFont(this.normalFont);
                g.drawString(this.date, leftValuesX, 49);
                traceLevelValue.draw(g2d, rightValuesX, 49.0f);
                g.drawString(this.location, leftValuesX, 64);
                versionValue.draw(g2d, rightValuesX, 64.0f);
            } else {
                g.setColor(Color.RED);
                g.drawString(this.info, 10, 49);
            }
            g.setColor(Color.BLACK);
            g.setFont(this.bigFont);
            g.drawString("i", 739, 60);
        }

        public Component getRendererComponent(JGraph graph, CellView view, boolean sel, boolean focus, boolean preview) {
            InfoCellRenderer component = null;
            if (view instanceof InfoView) {
                component = this;
                InfoCell cell = (InfoCell)((Object)view.getCell());
                this.title = graph.convertValueToString((Object)view);
                this.info = cell.getInfo();
                this.date = cell.getDate() == null ? "" : DateTimeUtil.formatLocalDateTime((Instant)cell.getDate());
                this.traceLevel = cell.getTraceLevel();
                this.location = cell.getLocation();
                this.version = cell.getServerVersion();
                this.installAttributes(view);
            }
            return component;
        }

        private void installAttributes(CellView view) {
            AttributeMap attributes = view.getAllAttributes();
            this.setOpaque(UmlGraphConstants.isOpaque((Map)attributes));
            this.setBorder(UmlGraphConstants.getBorder((Map)attributes));
            this.setBackground(UmlGraphConstants.GRAY);
            this.borderColor = UmlGraphConstants.getBorderColor((Map)attributes);
            this.cornerRadius = ((UmlLineBorder)this.getBorder()).getCornerRadius();
        }
    }
}

