/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.uml.activity;

import ch.e2e.builder.base.util.DateTimeUtil;
import ch.e2e.builder.trace.gui.uml.UmlGraphConstants;
import ch.e2e.builder.trace.gui.uml.UmlLineBorder;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.dom.DomUtilities;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import javax.swing.border.Border;
import javax.xml.parsers.ParserConfigurationException;
import org.jgraph.graph.DefaultGraphCell;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class InfoCell
extends DefaultGraphCell {
    private final String title;
    private String info = "";
    private Instant date;
    private String location = "";
    private String traceLevel = "";
    private String serverVersion = "";

    public InfoCell(Object userObject, String title) {
        super(userObject);
        this.title = title;
        this.initializeAttributes();
        if (userObject instanceof Testcase) {
            this.initialize((Testcase)userObject);
        } else if (userObject != null) {
            this.info = userObject.toString();
        }
    }

    public String getInfo() {
        return this.info;
    }

    public Instant getDate() {
        return this.date;
    }

    public String getTitle() {
        return this.title;
    }

    public String getLocation() {
        return this.location;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public String getTraceLevel() {
        return this.traceLevel;
    }

    public double getMaxY() {
        return UmlGraphConstants.getBounds((Map)this.attributes).getMaxY();
    }

    public String toString() {
        return this.title;
    }

    private void initialize(Testcase testcase) {
        try {
            Document infoDocument = DomUtilities.parse((File)new File(testcase.getTraceFolder(), "system.info"), (boolean)false, (boolean)false);
            Element info = infoDocument.getDocumentElement();
            Element lastRun = (Element)info.getElementsByTagName("lastRun").item(0);
            this.location = lastRun.getElementsByTagName("location").item(0).getTextContent();
            String dateString = lastRun.getElementsByTagName("date").item(0).getTextContent();
            if (dateString != null && !dateString.isEmpty()) {
                this.date = DateTimeUtil.toOffsetDateTime((String)dateString).toInstant();
            }
            if (testcase.getType() == 24 || testcase.getType() == 40) {
                this.traceLevel = "-";
            } else {
                Element trace = (Element)lastRun.getElementsByTagName("Trace").item(0);
                this.traceLevel = trace.getElementsByTagName("tracelevel").item(0).getTextContent();
                if (this.traceLevel.equals("Moderate")) {
                    this.traceLevel = "Truncated";
                }
            }
            this.serverVersion = info.getElementsByTagName("version").item(0).getTextContent();
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            // empty catch block
        }
    }

    private void initializeAttributes() {
        UmlGraphConstants.setOpaque((Map)this.attributes, (boolean)true);
        UmlGraphConstants.setConnectable((Map)this.attributes, (boolean)false);
        UmlGraphConstants.setSelectable((Map)this.attributes, (boolean)false);
        UmlGraphConstants.setSizeable((Map)this.attributes, (boolean)false);
        UmlGraphConstants.setMoveable((Map)this.attributes, (boolean)false);
        UmlGraphConstants.setBounds((Map)this.getAttributes(), (Rectangle2D)new Rectangle2D.Double(10.0, 10.0, 765.0, 75.0));
        UmlGraphConstants.setBorder((Map)this.getAttributes(), (Border)new UmlLineBorder(Color.BLACK, 10));
        UmlGraphConstants.setBorderColor((Map)this.getAttributes(), (Color)Color.BLACK);
    }
}

