/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.uml.activity;

import ch.e2e.builder.trace.gui.uml.UmlGraphConstants;
import ch.e2e.builder.trace.gui.uml.UmlVertexView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.VertexRenderer;

public class ExpansionNodeView
extends UmlVertexView {
    private static final ExpansionNodeRenderer RENDERER = new ExpansionNodeRenderer();

    public ExpansionNodeView() {
    }

    public ExpansionNodeView(Object cell) {
        super(cell);
    }

    @Override
    public CellViewRenderer getRenderer() {
        return RENDERER;
    }

    private static class ExpansionNodeRenderer
    extends VertexRenderer {
        private ExpansionNodeRenderer() {
        }

        public void paint(Graphics g) {
            try {
                if (this.gradientColor != null && !this.preview && this.isOpaque()) {
                    this.setOpaque(false);
                    Graphics2D g2d = (Graphics2D)g;
                    g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.getBackground(), this.getWidth(), this.getHeight(), this.gradientColor, true));
                    g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
                super.paint(g);
                this.paintSelectionBorder(g);
                this.paintArrows(g);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        private void paintArrows(Graphics g) {
            int dh;
            int h = dh = (int)((double)this.getHeight() / 6.0);
            for (int i = 0; i < 3; ++i) {
                g.drawLine(0, h, this.getWidth(), h);
                g.drawLine(this.getWidth() - 5, h - 2, this.getWidth() - 1, h);
                g.drawLine(this.getWidth() - 5, h + 2, this.getWidth() - 1, h);
                g.drawLine(0, h += dh, this.getWidth(), h);
                h += dh;
            }
        }

        protected void paintSelectionBorder(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            Stroke previousStroke = g2.getStroke();
            Color previousColor = g2.getColor();
            if (this.childrenSelected || this.selected) {
                g2.setStroke(UmlGraphConstants.SELECTION_STROKE);
                if (this.childrenSelected) {
                    g.setColor(this.gridColor);
                } else if (this.hasFocus && this.selected) {
                    g.setColor(this.lockedHandleColor);
                } else {
                    g.setColor(this.highlightColor);
                }
                Dimension d = this.getSize();
                g.drawRect(0, 0, d.width - 1, d.height - 1);
            }
            g2.setStroke(previousStroke);
            g2.setColor(previousColor);
        }
    }
}

