/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.testcase;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.gui.testcase.InspectionTreePanel;
import ch.e2e.builder.trace.gui.testcase.PreferencesPanel;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.TraceSettings;
import ch.e2e.builder.trace.testcase.uml.UmlTree;
import ch.e2e.dom.DomUtilities;
import ch.e2e.swing.InputIntegerField;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class TracePanel
extends PreferencesPanel {
    private final E2EBuilderModule module;
    private JCheckBox enableTrace;
    private JCheckBox useInspectionList;
    private JLabel inspectionListError;
    private TitledBorder traceTitledBorder;
    private JLabel inspectedActivities;
    private JRadioButton traceFull;
    private JRadioButton traceModerate;
    private JRadioButton ignoreAllParameter;
    private JRadioButton ignoreComplexParameter;
    private TitledBorder inspectionTitledBorder;
    private InputIntegerField maxSize;
    private JLabel maxSizeLabel;
    private JLabel mbLabel;
    private InspectionTreePanel inspectionTree;
    private boolean inspectionListMissing = false;

    public TracePanel(E2EBuilderModule module) {
        super(new GridBagLayout());
        this.module = module;
        this.createGui();
    }

    @Override
    public void setTestcase(Testcase testcase) {
        super.setTestcase(testcase);
        TraceSettings trace = testcase.getTraceSettings();
        this.enableTrace.setSelected(trace.isEnabled());
        this.traceFull.setSelected(trace.getTraceLevel() == TraceSettings.TraceLevel.Full);
        this.traceModerate.setSelected(trace.getTraceLevel() == TraceSettings.TraceLevel.Moderate);
        this.useInspectionList.setSelected(trace.isUseInspectionList());
        this.setInputEnabled(trace.isEnabled());
        File file = new File(testcase.getHome().getParentFile(), "inspection.list");
        if (file.canRead()) {
            try {
                this.inspectionTree.setRoot(DomUtilities.parse((File)file, (boolean)false, (boolean)false, (boolean)false), trace.getInspectionIds());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.inspectionListMissing = false;
            this.useInspectionList.setEnabled(true);
            this.inspectionListError.setVisible(false);
        } else {
            this.inspectionTree.setRoot(null, trace.getInspectionIds());
            this.inspectionListMissing = true;
            this.useInspectionList.setEnabled(false);
            this.inspectionListError.setVisible(true);
        }
        this.ignoreAllParameter.setSelected(trace.isIgnoreAllNotInspected());
        this.maxSize.setContent((Object)new Integer(trace.getMaxSize()));
    }

    @Override
    public boolean fillTestcase(Testcase testcase) {
        UmlTree umlTree;
        TraceSettings trace = testcase.getTraceSettings();
        boolean changed = this.traceSettingsChanged(trace);
        trace.setEnabled(this.enableTrace.isSelected());
        if (trace.setInspectedIds(this.inspectionTree.getInspectionIds()) && (umlTree = testcase.getUmlTree()) != null) {
            testcase.removeInspectionListeners();
            trace.checkInspection(umlTree);
        }
        trace.setUseInspectionList(this.useInspectionList.isSelected());
        if (this.traceFull.isSelected()) {
            trace.setTraceLevel(TraceSettings.TraceLevel.Full);
        } else {
            trace.setTraceLevel(TraceSettings.TraceLevel.Moderate);
        }
        trace.setIgnoreAllNotInspected(this.ignoreAllParameter.isSelected());
        trace.setMaxSize(((Number)this.maxSize.getContent()).intValue());
        return changed;
    }

    private boolean traceSettingsChanged(TraceSettings trace) {
        boolean changed;
        boolean bl = changed = trace.isEnabled() != this.enableTrace.isSelected();
        if (!changed && this.enableTrace.isSelected()) {
            boolean bl2 = changed = trace.getTraceLevel() == TraceSettings.TraceLevel.Full && !this.traceFull.isSelected() || trace.getTraceLevel() == TraceSettings.TraceLevel.Moderate && !this.traceModerate.isSelected() || trace.getMaxSize() != ((Number)this.maxSize.getContent()).intValue() || trace.isUseInspectionList() != this.useInspectionList.isSelected();
            if (!changed && this.useInspectionList.isSelected()) {
                changed = trace.isIgnoreAllNotInspected() != this.ignoreAllParameter.isSelected() || !trace.getInspectionIds().equals(this.inspectionTree.getInspectionIds());
            }
        }
        return changed;
    }

    private void createGui() {
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 0;
        this.enableTrace = this.module.createCheckBox("testcase.preferences.checkbox.enable.trace");
        this.add((Component)this.enableTrace, c);
        this.enableTrace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TracePanel.this.setInputEnabled(TracePanel.this.enableTrace.isSelected());
            }
        });
        JPanel traceSettingsPanel = new JPanel(new GridBagLayout());
        this.traceTitledBorder = this.module.createTitledBorder("testcase.preferences.label.trace.settings", (Border)new EtchedBorder(1));
        traceSettingsPanel.setBorder(this.traceTitledBorder);
        ButtonGroup traceLevel = new ButtonGroup();
        this.traceFull = this.module.createRadioButton("testcase.preferences.radio.trace.full");
        traceLevel.add(this.traceFull);
        this.traceModerate = this.module.createRadioButton("testcase.preferences.radio.trace.moderate");
        traceLevel.add(this.traceModerate);
        this.traceModerate.setSelected(true);
        traceSettingsPanel.add((Component)this.traceFull, c);
        traceSettingsPanel.add((Component)this.traceModerate, c);
        JPanel inspectionList = new JPanel();
        this.useInspectionList = this.module.createCheckBox("testcase.preferences.checkbox.inspectionlist");
        this.useInspectionList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TracePanel.this.setInspectionEnabled(TracePanel.this.useInspectionList.isSelected());
            }
        });
        inspectionList.add(this.useInspectionList);
        this.inspectionListError = new JLabel(this.module.getTranslation("testcase.preferences.label.inspection.list.missing", "(To use the inspection list import from repository.)"));
        this.inspectionListError.setVisible(false);
        inspectionList.add(this.inspectionListError);
        traceSettingsPanel.add((Component)inspectionList, c);
        JPanel inspectionPanel = this.createInspectionPanel(this.module, c);
        c.insets = new Insets(0, 0, 0, 0);
        traceSettingsPanel.add((Component)inspectionPanel, c);
        c.fill = 0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.insets = new Insets(0, 5, 0, 0);
        traceSettingsPanel.add((Component)this.createMaxSizePanel(this.module), c);
        c.fill = 1;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)traceSettingsPanel, c);
    }

    private JPanel createInspectionPanel(E2EBuilderModule traceViewer, GridBagConstraints c) {
        JPanel inspectionPanel = new JPanel(new GridBagLayout());
        this.inspectionTitledBorder = traceViewer.createTitledBorder("testcase.preferences.label.inspection.settings", (Border)new EtchedBorder(1));
        inspectionPanel.setBorder(this.inspectionTitledBorder);
        ButtonGroup inspectionTraceMode = new ButtonGroup();
        this.ignoreComplexParameter = traceViewer.createRadioButton("testcase.preferences.radio.ignore.complex.parameter");
        this.ignoreComplexParameter.setSelected(true);
        inspectionTraceMode.add(this.ignoreComplexParameter);
        inspectionPanel.add((Component)this.ignoreComplexParameter, c);
        this.ignoreAllParameter = traceViewer.createRadioButton("testcase.preferences.radio.ignore.all.parameter");
        inspectionTraceMode.add(this.ignoreAllParameter);
        inspectionPanel.add((Component)this.ignoreAllParameter, c);
        c.insets = new Insets(0, 6, 0, 0);
        this.inspectedActivities = traceViewer.createLabel("testcase.preferences.label.inspected.activities");
        inspectionPanel.add((Component)this.inspectedActivities, c);
        c.anchor = 17;
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        this.inspectionTree = new InspectionTreePanel();
        inspectionPanel.add((Component)this.inspectionTree, c);
        return inspectionPanel;
    }

    JPanel createMaxSizePanel(E2EBuilderModule traceViewer) {
        JPanel maxSizePanel = new JPanel(new GridLayout(1, 3, 5, 0));
        this.maxSizeLabel = traceViewer.createLabel("testcase.preferences.label.trace.max.size");
        maxSizePanel.add(this.maxSizeLabel);
        this.maxSize = new InputIntegerField(1, 999);
        maxSizePanel.add((Component)this.maxSize);
        this.mbLabel = new JLabel("MB");
        maxSizePanel.add(this.mbLabel);
        return maxSizePanel;
    }

    private void setInputEnabled(boolean enabled) {
        this.traceFull.setEnabled(enabled);
        this.traceModerate.setEnabled(enabled);
        if (enabled) {
            this.traceTitledBorder.setTitleColor(Color.BLACK);
            this.maxSizeLabel.setForeground(Color.BLACK);
            this.mbLabel.setForeground(Color.BLACK);
        } else {
            this.traceTitledBorder.setTitleColor(this.useInspectionList.getBackground().darker());
            this.maxSizeLabel.setForeground(this.useInspectionList.getBackground().darker());
            this.mbLabel.setForeground(this.useInspectionList.getBackground().darker());
        }
        this.useInspectionList.setEnabled(enabled && !this.inspectionListMissing);
        this.setInspectionEnabled(enabled & this.useInspectionList.isSelected());
        this.maxSize.setEnabled(enabled);
    }

    private void setInspectionEnabled(boolean enabled) {
        this.inspectionTree.setEnabled(enabled);
        this.ignoreAllParameter.setEnabled(enabled);
        this.ignoreComplexParameter.setEnabled(enabled);
        if (enabled) {
            this.inspectionTitledBorder.setTitleColor(Color.BLACK);
            this.inspectedActivities.setForeground(Color.BLACK);
        } else {
            this.inspectionTitledBorder.setTitleColor(this.useInspectionList.getBackground().darker());
            this.inspectedActivities.setForeground(this.useInspectionList.getBackground().darker());
        }
        SwingUtilities.updateComponentTreeUI(this);
    }
}

