/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.execute;

import ch.e2e.builder.base.application.E2EBuilderTransaction;
import ch.e2e.builder.base.gui.E2EBuilderInfoDialog;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.execute.HttpClient;
import ch.e2e.builder.trace.execute.Logging;
import ch.e2e.builder.trace.execute.RequestPool;
import ch.e2e.builder.trace.execute.SynchronousTestcaseRequest;
import ch.e2e.builder.trace.execute.TestcaseRunListener;
import ch.e2e.builder.trace.request.SOAPFault;
import ch.e2e.builder.trace.request.SOAPResponse;
import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcase;
import ch.e2e.builder.trace.testcase.AdapterTemplateInfo;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import ch.e2e.builder.trace.testcase.event.TestcaseRunFinishedEvent;
import ch.e2e.builder.trace.testcase.response.MockInfo;
import ch.e2e.builder.trace.tools.NamespacesManager;
import ch.e2e.builder.trace.tree.RefreshSynchronousTreeEvent;
import ch.e2e.dom.DomUtilities;
import ch.e2e.event.EventController;
import ch.e2e.io.FilesNotDeletedException;
import ch.e2e.util.StringTools;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TestcaseRunTransaction
extends E2EBuilderTransaction {
    private E2EBuilderModule module;
    private Collection<? extends TestcaseRunListener> runListeners;

    public TestcaseRunTransaction(E2EBuilderModule module, Collection<? extends TestcaseRunListener> runListeners) {
        this.module = module;
        this.runListeners = runListeners;
    }

    public String getDescription() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public Object doTransaction(Object transactionData) {
        AbstractSynchronousTestcase testcase = (AbstractSynchronousTestcase)transactionData;
        testcase.setLastRunInfos();
        try {
            testcase.clearResult();
        }
        catch (FilesNotDeletedException e) {
            for (File file : e.getFiles()) {
                String msg = this.module.getTranslation("could.not.delete." + (file.isDirectory() ? "directory" : "file"));
                this.module.showError(StringTools.replaceProperty((String)msg, (String)"file", (String)file.getPath()));
            }
        }
        testcase.saveRequest();
        this.fireStartedEvents((Testcase)testcase);
        SynchronousTestcaseRequest request = RequestPool.getInstance().createRequest(testcase);
        long start = System.currentTimeMillis();
        SOAPResponse response = HttpClient.performRequest((SynchronousTestcaseRequest)request);
        long stop = System.currentTimeMillis();
        if (response == null) {
            NamespacesManager namespacesManager = null;
            try {
                namespacesManager = testcase.getRequest().getNamespacesManager();
            }
            catch (IOException iOException) {
            }
            catch (SAXException sAXException) {
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
            response = new SOAPFault("RESPONSE_01", "Unknown Error", namespacesManager);
        }
        String msg = "Done. " + (stop - start) + " ms";
        testcase.setResponse(response);
        MockInfo mockInfo = response.getMockInfo();
        if (mockInfo != null && mockInfo.containsErrors()) {
            this.showMockInfo(mockInfo, testcase);
        }
        Logging.logger.finer(msg);
        this.module.showStatusMessage(msg);
        return testcase;
    }

    private void showMockInfo(MockInfo mockInfo, AbstractSynchronousTestcase testcase) {
        String internalTitle = this.module.getTranslation("mock.backends.warning.dialog.internaltitle", "Unused Mockups");
        String subtitle = this.module.getTranslation("mock.backends.warning.dialog.subtitle", "");
        String msg = this.module.getTranslation("mock.backends.summary");
        if (msg == null) {
            msg = mockInfo.getSummary();
        } else {
            HashMap<String, Integer> properties = new HashMap<String, Integer>(2);
            properties.put("mockupsUsed", mockInfo.getNumberOfMockupsUsed());
            properties.put("mockups", mockInfo.getNumberOfMockups());
            msg = StringTools.replaceProperties((String)msg, properties);
        }
        StringBuilder info = new StringBuilder(msg);
        for (MockInfo.Error error : mockInfo.getErrors()) {
            info.append("\n");
            msg = this.module.getTranslation("mock.backends.error.code." + error.getCode());
            if (msg == null) {
                info.append(error.getError());
                continue;
            }
            String componentInfo = this.findComponentInfo(testcase, error.getComponent());
            info.append(StringTools.replaceProperty((String)msg, (String)"component", (String)(componentInfo == null ? error.getComponent() : componentInfo)));
        }
        E2EBuilderInfoDialog.warning((String)internalTitle, (String)subtitle, (String)info.toString());
    }

    private String findComponentInfo(AbstractSynchronousTestcase testcase, String id) {
        String result = null;
        File adapterInfos = new File(testcase.getAdapterInfoHome(), "adapter.template.ids");
        if (adapterInfos.exists()) {
            try {
                Document adapterInfosDocument = DomUtilities.parse((File)adapterInfos, (boolean)false, (boolean)false, (boolean)false);
                NodeList infoElements = adapterInfosDocument.getDocumentElement().getElementsByTagName("UniqueId");
                int length = infoElements.getLength();
                for (int i = 0; result == null && i < length; ++i) {
                    AdapterTemplateInfo adapterInfo = new AdapterTemplateInfo((Element)infoElements.item(i));
                    if (!adapterInfo.getId().equals(id)) continue;
                    result = adapterInfo.getName() + " [" + adapterInfo.getPackage() + "]";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public void prepareTransaction() {
        this.module.clearMessageView();
    }

    public void setTransactionResult(Object result) {
        EventController.fire((EventObject)new RefreshSynchronousTreeEvent((Object)this, (TestcaseObject)result));
        this.fireFinishedEvents((Testcase)result);
    }

    public boolean doErrorHandling(Throwable error) {
        this.module.showError(error.toString());
        Logging.logger.throwing(((Object)((Object)this)).getClass().getName(), "doErrorHandling", error);
        this.fireFinishedEvents(null);
        return true;
    }

    private void fireStartedEvents(Testcase testcase) {
        if (this.runListeners != null) {
            for (TestcaseRunListener testcaseRunListener : this.runListeners) {
                testcaseRunListener.runStarted(testcase);
            }
        }
    }

    private void fireFinishedEvents(Testcase testcase) {
        EventController.fire((EventObject)new TestcaseRunFinishedEvent((Object)this, 1, testcase));
        if (this.runListeners != null) {
            for (TestcaseRunListener testcaseRunListener : this.runListeners) {
                testcaseRunListener.runFinished(testcase);
            }
        }
    }
}

