/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.tools;

import ch.e2e.builder.base.application.E2EBuilder;
import ch.e2e.resource.Properties;
import ch.e2e.test.TestType;
import ch.e2e.test.TypeFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class TestClassFactory {
    private static TestClassFactory factory;
    private ArrayList<Properties> properties = new ArrayList();
    private HashMap<String, TestType> testActions;
    private HashMap<String, TestType> optionContainer;
    private HashMap<String, TestType> resultTests;

    private TestClassFactory() {
    }

    public static TestClassFactory getInstance() {
        if (factory == null) {
            factory = new TestClassFactory();
        }
        return factory;
    }

    public void init() {
        File[] jarfiles = E2EBuilder.getInstance().getParentApplication().getTestJarfiles();
        File[] manifestfiles = E2EBuilder.getInstance().getParentApplication().getTestManifestFiles();
        this.readPropertiesFiles(jarfiles, manifestfiles);
        this.readTestClasses();
    }

    public ArrayList<Properties> getProperties() {
        return this.properties;
    }

    public HashMap<String, TestType> getTestActions() {
        return this.testActions;
    }

    public List<TestType> getTestsWithCreateAction() {
        ArrayList<TestType> actions = new ArrayList<TestType>();
        for (TestType type : this.testActions.values()) {
            if (type.getCreateAction() == null) continue;
            actions.add(type);
        }
        return actions;
    }

    public HashMap<String, TestType> getOptionContainer() {
        return this.optionContainer;
    }

    public HashMap<String, TestType> getResultTests() {
        return this.resultTests;
    }

    private void readPropertiesFiles(File[] jarfiles, File[] manifestfiles) {
        for (File file : jarfiles) {
            try {
                JarFile jarfile = new JarFile(file);
                Manifest manifest = jarfile.getManifest();
                if (manifest == null) {
                    System.out.println("Could not find a manifest in " + jarfile.getName());
                    continue;
                }
                Attributes testProperties = manifest.getMainAttributes();
                String propertiesName = testProperties.getValue("Test-Info-Properties");
                if (propertiesName == null) continue;
                this.properties.add(new Properties(propertiesName));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (manifestfiles != null) {
            for (File file : manifestfiles) {
                try {
                    Manifest manifest = new Manifest(new FileInputStream(file));
                    Attributes testProperties = manifest.getMainAttributes();
                    String propertiesName = testProperties.getValue("Test-Info-Properties");
                    if (propertiesName == null) continue;
                    this.properties.add(new Properties(propertiesName));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void readTestClasses() {
        for (Properties properties : TestClassFactory.getInstance().getProperties()) {
            TypeFactory.getInstance().addTypes(properties, Boolean.getBoolean("ch.e2e.builder.regtest.ignoreCreateFlag"), Boolean.getBoolean("ch.e2e.builder.regtest.ignoreOptionsFlag"));
        }
        this.testActions = new HashMap();
        this.resultTests = new HashMap();
        this.optionContainer = new HashMap();
        this.checkAddToLists(TypeFactory.getInstance().getGlobalResultTests());
        for (Properties properties : this.properties) {
            HashMap allClasses = TypeFactory.getInstance().getTypes(properties);
            this.checkAddToLists(allClasses);
        }
    }

    private void checkAddToLists(HashMap<String, TestType> classes) {
        for (String key : classes.keySet()) {
            TestType testType = classes.get(key);
            if (testType.isCreate()) {
                if (testType.isTask()) {
                    this.testActions.put(key, testType);
                } else if (testType.isTest()) {
                    this.testActions.put(key, testType);
                } else if (testType.isResultCompare()) {
                    this.resultTests.put(key, testType);
                }
            }
            if (!testType.isOptionsEditable()) continue;
            this.optionContainer.put(key, testType);
        }
    }
}

