/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.testsuite;

import ch.e2e.builder.base.io.UniqueIdService;
import ch.e2e.builder.regtest.testsuite.LibrariesRoot;
import ch.e2e.builder.regtest.testsuite.Library;
import ch.e2e.builder.regtest.testsuite.LibraryChildSuite;
import ch.e2e.builder.regtest.testsuite.TestSuiteUtilities;
import ch.e2e.builder.regtest.testsuite.Testcase;
import ch.e2e.builder.regtest.testsuite.TreeTestSuite;
import ch.e2e.builder.trace.tools.TraceTools;
import ch.e2e.test.E2ETestcase;
import ch.e2e.test.OptionContainer;
import ch.e2e.test.TestType;
import ch.e2e.test.Testable;
import ch.e2e.test.Utilities;
import ch.e2e.test.options.Option;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import junit.framework.Test;

public class LibraryUtilities {
    private static LibraryUtilities utilities;

    private LibraryUtilities() {
    }

    public static LibraryUtilities getInstance() {
        if (utilities == null) {
            utilities = new LibraryUtilities();
        }
        return utilities;
    }

    public Library replaceWithLibrary(TreeTestSuite testSuite, String name, LibrariesRoot libraries) throws Exception {
        Library library = new Library(name, libraries);
        libraries.add(library);
        this.replaceAndMoveData(testSuite, library);
        library.persistNoNotification();
        return library;
    }

    private void replaceAndMoveData(TreeTestSuite oldTestSuite, Library newTestSuite) throws TransformerException, IOException, XPathExpressionException {
        File projectHome = new File(System.getProperty("ch.e2e.builder.base.home"));
        File oldReferenceFolder = new File(projectHome, "regressiontest/reference/" + oldTestSuite.getPath());
        File newReferenceFolder = new File(projectHome, "regressiontest/reference/" + newTestSuite.getPath());
        File oldSourceFolder = new File(projectHome, "regressiontest/source/" + oldTestSuite.getPath());
        File newSourceFolder = new File(projectHome, "regressiontest/source/" + newTestSuite.getPath());
        newTestSuite.getProperties().put("library.output.folder", "${output.folder}");
        newTestSuite.getProperties().put("reference.folder", newReferenceFolder.getAbsolutePath());
        newTestSuite.getProperties().put("source.folder", newSourceFolder.getAbsolutePath());
        for (TestType key : oldTestSuite.getTestSuiteOptions().getKeys()) {
            OptionContainer container = oldTestSuite.getTestSuiteOptions().get(key);
            Utilities.insertProperties((OptionContainer)container, (Map)newTestSuite.getProperties());
            newTestSuite.getTestSuiteOptions().put(key, container);
        }
        for (Testable testable : oldTestSuite.getTestcases()) {
            if (testable instanceof Testcase) {
                Utilities.insertProperties((E2ETestcase)((Testcase)testable));
                TestSuiteUtilities.getInstance().moveTestcaseData((Testcase)testable, oldReferenceFolder, newReferenceFolder, oldSourceFolder, newSourceFolder);
                newTestSuite.addTest((Test)testable);
                Utilities.insertProperties((E2ETestcase)((Testcase)testable));
                continue;
            }
            if (!(testable instanceof TreeTestSuite)) continue;
            this.moveTestSuite((TreeTestSuite)testable, newTestSuite);
        }
    }

    private void moveTestSuite(TreeTestSuite testSuite, Library parent) throws TransformerException, IOException, XPathExpressionException {
        File testSuiteFolder = new File(parent.getTestSuiteFile().getParentFile(), testSuite.getTestSuiteFile().getParentFile().getName());
        testSuiteFolder.mkdirs();
        File newTestSuiteFile = new File(testSuiteFolder, testSuite.getTestSuiteFile().getName());
        LibraryChildSuite newTestSuite = parent.createChildSuite(testSuite.getName());
        newTestSuite.setTestSuiteFile(newTestSuiteFile);
        parent.addTest((Test)newTestSuite);
        testSuite.getTestSuiteFile().delete();
        this.replaceAndMoveData(testSuite, newTestSuite);
        newTestSuite.persistNoNotification();
    }

    private void replaceFolder(Collection<Option> values, String oldOutputPath, String newOutputPath) {
        for (Option option : values) {
            String value;
            if (option.getValue() != null && (value = option.getValue().toString()).startsWith(oldOutputPath)) {
                value = newOutputPath + value.substring(oldOutputPath.length());
                Object newValue = option.createValue(value);
                option.setValue(newValue);
            }
            this.replaceFolder(option.getOptions(), oldOutputPath, newOutputPath);
        }
    }

    private String createLibraryId(String name, LibrariesRoot librariesRoot) {
        HashMap<String, String> existingTestSuites = new HashMap<String, String>();
        for (TreeTestSuite testable : librariesRoot) {
            existingTestSuites.put(testable.getName(), testable.getTestSuiteFile().getParentFile().getName());
        }
        String prefix = TraceTools.createPrefix((String)name);
        return UniqueIdService.createUniqueId((String)name, (String)prefix, existingTestSuites);
    }
}

