/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui;

import ch.e2e.builder.base.gui.E2EBuilderQuestionDialog;
import ch.e2e.builder.base.io.XMLFileFilter;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.base.project.event.ProjectEvent;
import ch.e2e.builder.base.project.event.ProjectListener;
import ch.e2e.builder.regtest.event.AddOptionsEvent;
import ch.e2e.builder.regtest.event.CreateLibraryEvent;
import ch.e2e.builder.regtest.event.CreateTestSuiteEvent;
import ch.e2e.builder.regtest.event.CreateTestcaseEvent;
import ch.e2e.builder.regtest.event.DataChangesAcceptedEvent;
import ch.e2e.builder.regtest.event.DeleteTestSuiteEvent;
import ch.e2e.builder.regtest.event.DeleteTestcaseEvent;
import ch.e2e.builder.regtest.event.EditTestPreferencesEvent;
import ch.e2e.builder.regtest.event.ImportLibraryEvent;
import ch.e2e.builder.regtest.event.ImportTestSuiteEvent;
import ch.e2e.builder.regtest.event.ImportTestcaseEvent;
import ch.e2e.builder.regtest.event.RemoveOptionsEvent;
import ch.e2e.builder.regtest.event.RenameTestSuiteEvent;
import ch.e2e.builder.regtest.event.RenameTestcaseEvent;
import ch.e2e.builder.regtest.event.SelectTestcaseEvent;
import ch.e2e.builder.regtest.event.SortTestSuiteEvent;
import ch.e2e.builder.regtest.event.TestSuiteTreeChangedEvent;
import ch.e2e.builder.regtest.event.TestSuiteTreeReloadEvent;
import ch.e2e.builder.regtest.event.UseAsLibraryEvent;
import ch.e2e.builder.regtest.gui.LibrarySelectionDialog;
import ch.e2e.builder.regtest.gui.OptionsDialog;
import ch.e2e.builder.regtest.gui.SelectOptionTypeDialog;
import ch.e2e.builder.regtest.gui.TestSelectionDialog;
import ch.e2e.builder.regtest.gui.TestSuiteCellEditor;
import ch.e2e.builder.regtest.gui.TestSuiteNameFinder;
import ch.e2e.builder.regtest.gui.TestSuiteSelectionDialog;
import ch.e2e.builder.regtest.gui.TestSuiteSettings;
import ch.e2e.builder.regtest.gui.TestSuiteToMoveSelection;
import ch.e2e.builder.regtest.gui.TestSuiteTreeCellRenderer;
import ch.e2e.builder.regtest.gui.TestTransferEvent;
import ch.e2e.builder.regtest.gui.TestTransferHandler;
import ch.e2e.builder.regtest.gui.TestTransferListener;
import ch.e2e.builder.regtest.gui.TestcasePreferencesDialog;
import ch.e2e.builder.regtest.model.TestSelection;
import ch.e2e.builder.regtest.model.TestSuiteRendererPreferences;
import ch.e2e.builder.regtest.model.TestSuiteRootTreeModel;
import ch.e2e.builder.regtest.model.TreePathElement;
import ch.e2e.builder.regtest.testsuite.LibrariesRoot;
import ch.e2e.builder.regtest.testsuite.Library;
import ch.e2e.builder.regtest.testsuite.TestSuiteOptions;
import ch.e2e.builder.regtest.testsuite.Testcase;
import ch.e2e.builder.regtest.testsuite.TestcaseFactory;
import ch.e2e.builder.regtest.testsuite.TraceTestcase;
import ch.e2e.builder.regtest.testsuite.TreeTestSuite;
import ch.e2e.builder.regtest.tools.ResponseLogReader;
import ch.e2e.builder.trace.testcase.LogFile;
import ch.e2e.builder.trace.testcase.TraceSettings;
import ch.e2e.dom.DomUtilities;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.event.EventExecutionVetoException;
import ch.e2e.swing.Tree;
import ch.e2e.swing.renderer.RendererPreferences;
import ch.e2e.test.E2ETestcase;
import ch.e2e.test.OptionContainer;
import ch.e2e.test.TestType;
import ch.e2e.test.Testable;
import ch.e2e.test.Utilities;
import ch.e2e.util.StringTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class TestSuiteTreeView
extends JPanel
implements TreeSelectionListener,
ProjectListener,
TestTransferListener {
    private Tree tree;
    private TestSuiteRootTreeModel treeModel;
    private E2EBuilderModule module;
    private SelectOptionTypeDialog optionTypeDialog;
    private XMLFileFilter xmlFileFilter;
    private TreePath[] selectionPaths = null;

    public TestSuiteTreeView(E2EBuilderModule module) {
        super(new BorderLayout());
        this.module = module;
        this.createGui(module);
        this.addEventHandler(module);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.tree.setEnabled(enabled);
        if (!enabled) {
            this.tree.clearSelection();
        }
    }

    public void refresh() {
        this.treeModel.reload();
        this.tree.expandRow(1);
        this.tree.expandRow(0);
        this.tree.setSelectionPath(this.createTreePath(this.treeModel.getTestSuiteRoot()));
    }

    public void addTreeSelectionListener(TreeSelectionListener listener) {
        this.tree.addTreeSelectionListener(listener);
    }

    private Tree createTree(E2EBuilderModule module) {
        this.treeModel = new TestSuiteRootTreeModel(module);
        TestSuiteRendererPreferences preferences = new TestSuiteRendererPreferences(this.treeModel);
        TestSuiteTreeCellRenderer renderer = new TestSuiteTreeCellRenderer(preferences);
        this.tree = new Tree((RendererPreferences)preferences, (TreeCellRenderer)((Object)renderer));
        this.tree.setCellEditor((TreeCellEditor)((Object)new TestSuiteCellEditor(this.tree, preferences)));
        this.tree.setEditable(true);
        this.tree.setInvokesStopCellEditing(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setRootVisible(true);
        this.tree.setShowsRootHandles(true);
        this.tree.setDragEnabled(true);
        TestTransferHandler transferHandler = new TestTransferHandler();
        transferHandler.addTestTransferListener(this);
        this.tree.setDropMode(DropMode.ON);
        this.tree.setTransferHandler((TransferHandler)transferHandler);
        return this.tree;
    }

    private void addEventHandler(E2EBuilderModule module) {
        module.addProjectListener((ProjectListener)this);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                TestSuiteTreeView.this.createLibrary();
            }
        }, CreateLibraryEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                TestSuiteTreeView.this.createTestSuite(((CreateTestSuiteEvent)event).getParent(), ((CreateTestSuiteEvent)event).getIndex());
            }
        }, CreateTestSuiteEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                TestSuiteTreeView.this.importTestSuite(((ImportTestSuiteEvent)event).getParent(), ((ImportTestSuiteEvent)event).getIndex());
            }
        }, ImportTestSuiteEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                TestSuiteTreeView.this.sortTestSuite(((SortTestSuiteEvent)event).getTestsuite());
            }
        }, SortTestSuiteEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                TestSuiteTreeView.this.importTestcase(((ImportTestcaseEvent)event).getParent(), ((ImportTestcaseEvent)event).getIndex());
            }
        }, ImportTestcaseEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                TestSuiteTreeView.this.createTestcase(((CreateTestcaseEvent)event).getParent(), ((CreateTestcaseEvent)event).getIndex());
            }
        }, CreateTestcaseEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                TestSuiteTreeView.this.renameTestcase(((RenameTestcaseEvent)event).getTestcase());
            }
        }, RenameTestcaseEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                TestSuiteTreeView.this.deleteTestcase(((DeleteTestcaseEvent)event).getTestcase());
            }
        }, DeleteTestcaseEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                TestSuiteTreeView.this.selectTestcase(((SelectTestcaseEvent)event).getTestcase());
            }
        }, SelectTestcaseEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                TestSuiteTreeView.this.renameTestSuite(((RenameTestSuiteEvent)event).getTestsuite());
            }
        }, RenameTestSuiteEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                TestSuiteTreeView.this.deleteTestSuite(((DeleteTestSuiteEvent)event).getTestsuite());
            }
        }, DeleteTestSuiteEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                TestSuiteTreeView.this.includeLibrary(((ImportLibraryEvent)event).getTestsuite(), ((ImportLibraryEvent)event).getIndex());
            }
        }, ImportLibraryEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                TestSuiteTreeView.this.useAsLibrary(((UseAsLibraryEvent)event).getTestsuite());
            }
        }, UseAsLibraryEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                TestSuiteTreeView.this.addOptions(((AddOptionsEvent)event).getTestsuiteOptions());
            }
        }, AddOptionsEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                TestSuiteTreeView.this.removeOptions(((RemoveOptionsEvent)event).getOptions());
            }
        }, RemoveOptionsEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                TestSuiteTreeView.this.treeChanged((TreePathElement)((TestSuiteTreeChangedEvent)event).getTestable());
            }
        }, TestSuiteTreeChangedEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                TestSuiteTreeView.this.dataChangesAccepted((Testcase)((DataChangesAcceptedEvent)event).getTestcase());
            }
        }, DataChangesAcceptedEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                TestSuiteTreeView.this.editTestPreferences(((EditTestPreferencesEvent)event).getTest());
            }
        }, EditTestPreferencesEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                Testable owner = ((TestSuiteTreeReloadEvent)event).getOptionContainer().getOwner();
                TreePath path = TestSuiteTreeView.this.treeChanged(((TreeTestSuite)owner).getTestSuiteOptions());
                TestSuiteTreeView.this.update((TreeTestSuite)owner);
                TestSuiteTreeView.this.treeModel.refresh();
                TestSuiteTreeView.this.selectPath(path);
            }
        }, TestSuiteTreeReloadEvent.class);
        this.addActions();
    }

    private void importTestcase(TreeTestSuite parent, int index) {
        TestSelectionDialog.TestcaseListSelection result = TestSelectionDialog.getInstance(this.module).selectTestcases(parent, index);
        if (result != null) {
            boolean changed = false;
            int length = result.getTestcases().size();
            for (int i = 0; i < length; ++i) {
                TraceTestcase testcase = result.getTestcases().get(i);
                try {
                    boolean importTestcase = true;
                    HashMap<String, String> properties = new HashMap<String, String>();
                    properties.put("test.name", testcase.getName());
                    TraceSettings settings = testcase.getTraceSettings();
                    if (this.containsTrace(testcase)) {
                        importTestcase = E2EBuilderQuestionDialog.doYesNoQuestion((String)StringTools.replaceProperties((String)this.module.getTranslation("test.trace.enabled.question.dialog.title"), properties), (String)StringTools.replaceProperties((String)this.module.getTranslation("test.trace.enabled.question.dialog.subtitle"), properties), (String)StringTools.replaceProperties((String)this.module.getTranslation("test.trace.enabled.question.dialog.question"), properties));
                    } else {
                        settings.setTraceLevel(TraceSettings.TraceLevel.None);
                        settings.setEnabled(false);
                    }
                    if (!importTestcase) continue;
                    result.getParent().importTestcase(testcase, result.getIndex() + i, result.isOverrideReferenceData());
                    changed = true;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (changed) {
                this.testSuitePathChanged(parent);
            }
        }
    }

    private boolean containsTrace(TraceTestcase testcase) {
        LogFile responseLog = testcase.getResponseLog();
        ResponseLogReader logReader = new ResponseLogReader(responseLog);
        return logReader.containsTrace();
    }

    private void createTestcase(TreeTestSuite parent, int index) {
        try {
            TreeTestSuite settingsParent = null;
            List<TestcaseFactory.TestcaseSettings> testcaseSettingsList = TestcaseFactory.getInstance().createTestcase(parent, index, this.module);
            for (TestcaseFactory.TestcaseSettings settings : testcaseSettingsList) {
                settings.getParent().insertTestcase(settings.getTestcase(), settings.getIndex());
                settingsParent = settings.getParent();
            }
            if (settingsParent != null) {
                this.selectPath(this.treeChanged(settingsParent));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteTestcase(Testcase test) {
        TreeTestSuite parent = (TreeTestSuite)test.getParent();
        if (this.askForDelete(test.getName(), parent.getName(), "Testcase")) {
            parent.deleteTestcase(test);
            this.testSuitePathChanged(test.getParent());
        }
    }

    private boolean askForDelete(String name, String parent, String testType) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("test.type", testType);
        properties.put("test.name", name);
        properties.put("test.parent", parent);
        String title = StringTools.replaceProperties((String)this.module.getTranslation("test.delete.question.dialog.title"), properties);
        String subtitle = StringTools.replaceProperties((String)this.module.getTranslation("test.delete.question.dialog.subtitle"), properties);
        String question = StringTools.replaceProperties((String)this.module.getTranslation("test.delete.question.dialog.question"), properties);
        return E2EBuilderQuestionDialog.doYesNoQuestion((String)title, (String)subtitle, (String)question);
    }

    private void renameTestcase(Testcase test) {
        String oldName = test.getName();
        if (TestcasePreferencesDialog.getInstance(this.module).rename(test, false)) {
            test.persist(oldName);
        }
    }

    private void selectTestcase(Testcase test) {
        TreePath path = this.createTreePath(test);
        this.selectPath(path);
    }

    private void deleteTestSuite(TreeTestSuite test) {
        if (test.isLibrary() && LibrariesRoot.isInLibraryTree(test)) {
            LibrariesRoot parent = this.treeModel.getLibraries();
            if (this.askForDelete(test.getName(), "Libraries", "Testsuite")) {
                this.treeModel.getLibraries().remove(test);
                ((Library)test).delete();
                TreePath path = this.treeChanged(parent);
                this.treeModel.refresh();
                this.selectPath(path);
            }
        } else {
            TreePathElement parent = (TreePathElement)test.getParent();
            if (this.askForDelete(test.getName(), ((TreeTestSuite)parent).getName(), "Testsuite")) {
                ((TreeTestSuite)parent).deleteTestSuite(test);
                TreePath path = this.treeChanged(parent);
                this.treeModel.refresh();
                this.selectPath(path);
            }
        }
    }

    private void includeLibrary(TreeTestSuite test, int index) {
        TreeTestSuite library = LibrarySelectionDialog.selectLibrary(this.treeModel.getLibraries(), this.module);
        if (library != null) {
            try {
                test.importLibrary(library, index);
                TreePath path = this.treeChanged(test);
                this.treeModel.refresh();
                this.selectPath(path);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void useAsLibrary(TreeTestSuite test) {
        TestSuiteSettings settings = TestSuiteNameFinder.getInstance(this.module).findLibraryName(test.getName(), this.treeModel.getLibraries());
        if (settings != null) {
            try {
                TreeTestSuite library = ((TreeTestSuite)test.getParent()).replaceWithLibrary(test, settings.getName(), this.treeModel.getLibraries());
                TreePath path = this.treeChanged((TreePathElement)test.getParent());
                this.treeModel.refresh();
                TreePath libraryPath = this.treeChanged(library);
                this.selectPath(libraryPath);
                this.selectPath(path);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void addOptions(TestSuiteOptions options) {
        TestType type;
        if (this.optionTypeDialog == null) {
            this.optionTypeDialog = new SelectOptionTypeDialog(this.module);
        }
        if ((type = this.optionTypeDialog.selectOptionType(options)) != null) {
            try {
                OptionContainer optionContainer = type.newInstance();
                optionContainer.setOwner((Testable)options.getParent());
                optionContainer.getNameOption().clearDependencies();
                optionContainer.getNameOption().setValue(null);
                optionContainer.getNameOption().setDefaultValue(null);
                optionContainer.getNameOption().setVisible(false);
                Utilities.mergeOptions((OptionContainer)options.getParent().getInheritedOptions(type, false), (OptionContainer)optionContainer);
                if (OptionsDialog.getInstance(this.module).editOptions(optionContainer, true, true)) {
                    options.put(type, optionContainer);
                    TreePath path = this.treeChanged(options);
                    this.treeModel.refresh();
                    this.selectPath(path);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void removeOptions(OptionContainer optionContainer) {
        try {
            TreeTestSuite options = (TreeTestSuite)optionContainer.getOwner();
            if (this.askForDelete('<' + optionContainer.getType().getName() + '>', options.getName(), "Options")) {
                options.removeOptions(optionContainer);
                TreePath path = this.treeChanged(options.getTestSuiteOptions());
                this.update((TreeTestSuite)optionContainer.getOwner());
                this.treeModel.refresh();
                this.selectPath(path);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void moveOptions(OptionContainer optionContainer, TestSuiteOptions newParentOptions) {
        if (!newParentOptions.getParent().isLibrary() || newParentOptions.getParent().getParent() == null) {
            try {
                TreeTestSuite oldOwner = (TreeTestSuite)optionContainer.getOwner();
                if (!oldOwner.isLibrary() || oldOwner.getParent() == null) {
                    oldOwner.removeOptions(optionContainer);
                    newParentOptions.put(optionContainer.getType(), optionContainer);
                    optionContainer.setOwner((Testable)newParentOptions.getParent());
                    newParentOptions.getParent().persistOptions(optionContainer);
                    this.treeChanged(oldOwner.getTestSuiteOptions());
                    TreePath path = this.treeChanged(newParentOptions);
                    this.update(oldOwner);
                    this.update(newParentOptions.getParent());
                    this.treeModel.refresh();
                    this.selectPath(path);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void update(TreeTestSuite testsuite) {
        if (testsuite.isLibrary()) {
            String name = testsuite.getName();
            try {
                List<TreeTestSuite> testSuites = this.treeModel.getTestSuiteRoot().findTestSuites(this.treeModel.getTestSuiteRoot(), name);
                for (TreeTestSuite testSuite : testSuites) {
                    ((TreeTestSuite)testSuite.getParent()).deleteTestSuite(testSuite);
                    ((TreeTestSuite)testSuite.getParent()).importLibrary(testsuite, 0);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void renameTestSuite(TreeTestSuite test) {
        TreePath path = this.createTreePath(test);
        this.tree.startEditingAtPath(path);
    }

    private TreePath treeChanged(TreePathElement testable) {
        testable = this.getFirstTreePathElementFromSelection(testable);
        TreePath path = this.createTreePath(testable);
        this.treeModel.fireTreeStructureChanged(path);
        return path;
    }

    private TreePathElement getFirstTreePathElementFromSelection(TreePathElement testable) {
        Testable firstChild;
        TestSelection selection;
        if (testable instanceof TestSelection && (selection = (TestSelection)testable).getChildCount() > 0 && (firstChild = (Testable)selection.get(0)) instanceof TreePathElement) {
            testable = (TreePathElement)firstChild;
        }
        return testable;
    }

    private void selectPath(TreePath path) {
        this.tree.expandPath(path);
        this.tree.setSelectionPath(path);
        this.tree.scrollPathToVisible(path);
    }

    private void importTestSuite(TreeTestSuite parent, int index) {
        TestSelectionDialog.TestcaseContainerSelection result = TestSuiteSelectionDialog.getInstance(this.module).selectTestSuite(parent, index == 0);
        if (result != null) {
            try {
                TreeTestSuite newTestSuite = result.getParent().importTestSuite(result.getTestcaseContainer(), result.getIndex(), result.isOverrideReferenceData());
                this.testSuiteAdded(result.getParent(), newTestSuite);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void createTestSuite(TreeTestSuite parent, int index) {
        TestSuiteSettings settings = TestSuiteNameFinder.getInstance(this.module).findTestSuiteName("TestSuite", parent, index == 0);
        if (settings != null) {
            try {
                TreeTestSuite newTestSuite = settings.getParent().createNewTestsuite(settings.getName(), settings.getIndex());
                this.testSuiteAdded(settings.getParent(), newTestSuite);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void sortTestSuite(TreeTestSuite testSuite) {
        testSuite.sortByName();
        this.testSuitePathChanged(testSuite);
    }

    private void createLibrary() {
        TestSuiteSettings settings = TestSuiteNameFinder.getInstance(this.module).findLibraryName("Library", this.treeModel.getLibraries());
        if (settings != null) {
            try {
                Library library = new Library(settings.getName(), this.treeModel.getLibraries());
                this.treeModel.getLibraries().add(library);
                TreePath path = this.treeChanged(this.treeModel.getLibraries());
                this.treeModel.refresh();
                this.selectPath(path);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void testSuiteAdded(TreePathElement parent, TreeTestSuite newTestSuite) {
        this.treeChanged(parent);
        this.selectPath(this.treeChanged(newTestSuite));
    }

    private void testSuitePathChanged(Object parent) {
        if (((TreePathElement)parent).isLeaf()) {
            parent = ((TreePathElement)parent).getTreeParent();
        }
        ArrayList<Object> path = new ArrayList<Object>();
        path.add(parent);
        while (((TreePathElement)parent).getTreeParent() != null) {
            parent = ((TreePathElement)parent).getTreeParent();
            path.add(0, parent);
        }
        path.add(0, this.treeModel.getRoot());
        TreePath treePath = new TreePath(path.toArray());
        this.tree.clearSelection();
        this.treeModel.fireTreeStructureChanged(new TreePath(this.treeModel.getRoot()));
        this.tree.expandRow(1);
        this.tree.expandPath(treePath);
        this.tree.setSelectionPath(treePath);
        this.selectionPaths = new TreePath[]{treePath};
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        if (event.getNewLeadSelectionPath() != null) {
            boolean isOldSelectionInLibrary;
            Object selected = event.getNewLeadSelectionPath().getLastPathComponent();
            boolean multiSelection = this.tree.getSelectionPaths() != null && this.tree.getSelectionPaths().length > 1;
            boolean isLibraryElement = selected instanceof TreePathElement && LibrariesRoot.isInLibraryTree((TreePathElement)selected);
            boolean isTestable = selected instanceof Testable;
            boolean isInSelection = this.selectionPaths != null && isTestable && this.isAlreadySelected((Testable)selected);
            Object oldSelection = event.getOldLeadSelectionPath() == null ? null : event.getOldLeadSelectionPath().getLastPathComponent();
            boolean bl = isOldSelectionInLibrary = oldSelection != null && oldSelection instanceof TreePathElement && LibrariesRoot.isInLibraryTree((TreePathElement)oldSelection);
            if (multiSelection && (!isTestable || isInSelection || isLibraryElement || isOldSelectionInLibrary)) {
                this.tree.removeTreeSelectionListener((TreeSelectionListener)this);
                this.tree.setSelectionPaths(this.selectionPaths);
                this.tree.addTreeSelectionListener((TreeSelectionListener)this);
            } else {
                this.selectionPaths = this.tree.getSelectionPaths();
            }
        }
    }

    private boolean isAlreadySelected(Testable test) {
        boolean result = false;
        for (int i = 0; i < this.selectionPaths.length && !result; ++i) {
            if (!(this.selectionPaths[i].getLastPathComponent() instanceof TreeTestSuite)) continue;
            result = ((TreeTestSuite)this.selectionPaths[i].getLastPathComponent()).containsTestable(test);
        }
        return result;
    }

    private void dataChangesAccepted(Testcase testcase) {
        this.treeChanged(testcase);
    }

    private void editTestPreferences(Testcase test) {
        String oldName = test.getName();
        if (TestcasePreferencesDialog.getInstance(this.module).editPreferences(test, false)) {
            test.persist(oldName);
        }
    }

    private void createGui(E2EBuilderModule module) {
        this.tree = this.createTree(module);
        this.tree.addTreeSelectionListener((TreeSelectionListener)this);
        this.tree.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        this.tree.setShowsRootHandles(true);
        this.tree.setRootVisible(false);
        this.tree.getSelectionModel().setSelectionMode(4);
        this.add((Component)new JScrollPane((Component)this.tree, 20, 30), "Center");
    }

    public void doBeforeChanging(ProjectEvent event) throws EventExecutionVetoException {
    }

    public void projectSettingsChange(ProjectEvent event) {
    }

    public void doBeforeProjectOpen(ProjectEvent event) {
    }

    public void doAfterProjectOpen(ProjectEvent event) {
    }

    public void projectOpened(ProjectEvent event) {
        File projectHome = event.getProject().getProjectHome();
        if (projectHome != null) {
            System.setProperty("project.folder", projectHome.getAbsolutePath());
            File testSuiteFolder = new File(projectHome, "regressiontest/testsuite");
            File rootTestSuite = new File(testSuiteFolder, "testsuite.xml");
            try {
                this.checkRootTestSuite(rootTestSuite);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            File librariesFolder = new File(projectHome, "regressiontest/testsuite/libraries");
            if (!librariesFolder.exists()) {
                librariesFolder.mkdirs();
            }
            this.treeModel.setRoot(projectHome);
            this.tree.expandRow(1);
            this.tree.expandRow(0);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TestSuiteTreeView.this.selectPath(TestSuiteTreeView.this.createTreePath(TestSuiteTreeView.this.treeModel.getTestSuiteRoot()));
                }
            });
        }
    }

    @Override
    public void moveTest(TestTransferEvent event) {
        this.move(event.getTestToMove(), event.getTestBefore());
    }

    @Override
    public void moveOptions(TestTransferEvent event) {
        this.moveOptions(event.getOptionContainer(), event.getNewOptions());
    }

    private void checkRootTestSuite(File rootTestSuite) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException, TransformerException {
        Document testSuiteDocument = !rootTestSuite.exists() ? DomUtilities.parseFromClasspath((String)"ch/e2e/builder/regtest/properties/testsuite.root.template.xml", (boolean)false, (boolean)false, (boolean)false) : DomUtilities.parse((File)rootTestSuite, (boolean)false, (boolean)false, (boolean)false);
        Element property = (Element)DomUtilities.selectNode((Node)testSuiteDocument.getDocumentElement(), (String)"/testcases/property[@name='project.folder']");
        if (property != null) {
            property.getParentNode().removeChild(property);
        }
        DomUtilities.serialize((File)rootTestSuite, (Document)testSuiteDocument, (boolean)true);
    }

    public TreePath createTreePath(TreePathElement testable) {
        ArrayList<Object> pathElements = new ArrayList<Object>();
        if (testable != null) {
            pathElements.add(testable);
            while (testable.getTreeParent() != null) {
                testable = (TreePathElement)testable.getTreeParent();
                pathElements.add(0, testable);
            }
        }
        pathElements.add(0, this.treeModel.getRoot());
        return new TreePath(pathElements.toArray());
    }

    private void move(Testable testToMove, Testable testBefore) {
        TreeTestSuite oldParent = (TreeTestSuite)testToMove.getParent();
        TreeTestSuite newParent = null;
        int index = 0;
        if (testBefore instanceof TreeTestSuite) {
            if (testBefore.equals(this.treeModel.getTestSuiteRoot())) {
                newParent = this.treeModel.getTestSuiteRoot();
                index = 0;
            } else if (((TreeTestSuite)testBefore).isLibrary() && LibrariesRoot.isInLibraryTree((TreeTestSuite)testBefore) || testBefore.getParent().equals(this.treeModel.getTestSuiteRoot())) {
                newParent = (TreeTestSuite)testBefore;
                index = 0;
            } else if (testToMove instanceof TreeTestSuite && ((TreeTestSuite)testToMove).isLibrary()) {
                newParent = (TreeTestSuite)testToMove.getParent();
                index = newParent.getIndexOfTest(testBefore) + 1;
            } else {
                TestSuiteSettings settings = TestSuiteToMoveSelection.getInstance(this.module).selectTestSuiteToMoveTo(testToMove, (TreeTestSuite)testBefore);
                if (settings != null) {
                    newParent = settings.getParent();
                    index = settings.getIndex();
                }
            }
        } else {
            newParent = (TreeTestSuite)testBefore.getParent();
            index = newParent.getIndexOfTest(testBefore) + 1;
        }
        if (newParent != null) {
            if (newParent.equals(oldParent)) {
                newParent.move(testToMove, index);
            } else {
                try {
                    if (testToMove instanceof TreeTestSuite) {
                        oldParent.removeTestSuite((TreeTestSuite)testToMove);
                        newParent.moveTestcaseData((TreeTestSuite)testToMove);
                        newParent.insertTestSuite((TreeTestSuite)testToMove, index);
                    } else {
                        Utilities.insertProperties((E2ETestcase)((Testcase)testToMove));
                        oldParent.removeTestcase((Testcase)testToMove);
                        newParent.moveTestcaseData((Testcase)testToMove, oldParent);
                        newParent.insertTestcase((Testcase)testToMove, index);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (LibrariesRoot.isInLibraryTree(oldParent) || LibrariesRoot.isInLibraryTree(newParent)) {
                this.treeChanged(this.treeModel.getLibraries());
            }
            if (!LibrariesRoot.isInLibraryTree(oldParent) || !LibrariesRoot.isInLibraryTree(newParent)) {
                this.treeChanged(this.treeModel.getTestSuiteRoot());
            }
            this.tree.expandPath(this.createTreePath(oldParent));
            TreePath newPath = this.createTreePath(newParent);
            this.tree.expandPath(newPath);
            TreePath selectionPath = newPath.pathByAddingChild(testToMove);
            int row = this.tree.getRowForPath(selectionPath);
            this.tree.setSelectionRow(row);
        }
    }

    private void addActions() {
        InputMap inputMap = this.tree.getInputMap(0);
        ActionMap actionMap = this.tree.getActionMap();
        this.addDeleteAction(inputMap, actionMap);
        this.addRenameAction(inputMap, actionMap);
    }

    private void addDeleteAction(InputMap inputMap, ActionMap actionMap) {
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "regtest.tree.node.delete");
        actionMap.put("regtest.tree.node.delete", new AbstractAction("regtest.tree.node.delete"){

            @Override
            public void actionPerformed(ActionEvent event) {
                TreePath path = TestSuiteTreeView.this.tree.getSelectionPath();
                if (path != null) {
                    TreeTestSuite testSuite;
                    Testcase testcase;
                    if (path.getLastPathComponent() instanceof Testcase && (LibrariesRoot.isInLibraryTree(testcase = (Testcase)path.getLastPathComponent()) || !testcase.isInLibrary())) {
                        TestSuiteTreeView.this.deleteTestcase(testcase);
                    }
                    if (path.getLastPathComponent() instanceof TreeTestSuite && (LibrariesRoot.isInLibraryTree(testSuite = (TreeTestSuite)path.getLastPathComponent()) || !testSuite.isInLibrary() && !testSuite.isLibrary())) {
                        TestSuiteTreeView.this.deleteTestSuite(testSuite);
                    }
                }
            }
        });
    }

    private void addRenameAction(InputMap inputMap, ActionMap actionMap) {
        inputMap.put(KeyStroke.getKeyStroke(113, 0), "regtest.tree.node.rename");
        actionMap.put("regtest.tree.node.rename", new AbstractAction("regtest.tree.node.rename"){

            @Override
            public void actionPerformed(ActionEvent event) {
                TreePath path = TestSuiteTreeView.this.tree.getSelectionPath();
                if (path != null) {
                    if (path.getLastPathComponent() instanceof Testcase) {
                        TestSuiteTreeView.this.renameTestcase((Testcase)path.getLastPathComponent());
                    }
                    if (path.getLastPathComponent() instanceof TreeTestSuite) {
                        TestSuiteTreeView.this.renameTestSuite((TreeTestSuite)path.getLastPathComponent());
                    }
                }
            }
        });
    }

    private XMLFileFilter getXmlFileFilter() {
        if (this.xmlFileFilter == null) {
            this.xmlFileFilter = new XMLFileFilter(this.module.getTranslation("library.file.description"));
        }
        return this.xmlFileFilter;
    }
}

