/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.resource;

import ch.e2e.resource.MultiMapProperties;
import ch.e2e.resource.Properties;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Hashtable;
import java.util.MissingResourceException;
import javax.swing.ImageIcon;

public class ImageLoader {
    private static ImageLoader imageLoader = new ImageLoader();
    private Properties properties;
    private ClassLoader classLoader;
    private Hashtable imageTable = new Hashtable();

    public ImageLoader(String properties) {
        this(properties, ImageLoader.class.getClassLoader());
    }

    public ImageLoader(String properties, ClassLoader classLoader) {
        try {
            this.properties = new MultiMapProperties(properties, "image_maps", classLoader);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    public ImageLoader(Properties properties) {
        this(properties, ImageLoader.class.getClassLoader());
    }

    public ImageLoader(Properties properties, ClassLoader classLoader) {
        this.properties = properties;
        this.classLoader = classLoader;
    }

    public ImageLoader() {
        this(ImageLoader.class.getClassLoader());
    }

    public ImageLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static ImageIcon loadIcon(String iconName, boolean createEmptyImage) {
        return ImageLoader.loadIcon(iconName, createEmptyImage, ImageLoader.imageLoader.classLoader);
    }

    public static ImageIcon loadIcon(String iconName, boolean createEmptyImage, ClassLoader classLoader) {
        return imageLoader.getIcon(iconName, createEmptyImage, classLoader);
    }

    public static Image loadImage(String imageName, boolean createEmptyImage) {
        return ImageLoader.loadImage(imageName, createEmptyImage, ImageLoader.imageLoader.classLoader);
    }

    public static Image loadImage(String imageName, boolean createEmptyImage, ClassLoader classLoader) {
        return imageLoader.getImage(imageName, createEmptyImage, classLoader);
    }

    public ImageIcon getIcon(String iconName, boolean createEmptyImage) {
        return this.getIcon(iconName, createEmptyImage, this.classLoader);
    }

    public ImageIcon getIcon(String iconName, boolean createEmptyImage, ClassLoader classLoader) {
        Image image = this.getImage(iconName, createEmptyImage, classLoader);
        if (image != null) {
            return new ImageIcon(image);
        }
        return null;
    }

    public Image getImage(String imageName, boolean createEmptyImage) {
        return this.getImage(imageName, createEmptyImage, this.classLoader);
    }

    public Image getImage(String imageName, boolean createEmptyImage, ClassLoader classLoader) {
        Image image = (Image)this.imageTable.get(imageName);
        if (image == null) {
            image = this.createImage(imageName, createEmptyImage, classLoader);
        }
        return image;
    }

    private Image createImage(String imageName, boolean createEmptyImage, ClassLoader classLoader) {
        String realImageName = imageName;
        if (this.properties != null) {
            try {
                realImageName = this.properties.getString(imageName);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        Image image = null;
        URL url = classLoader.getResource(realImageName);
        if (url != null) {
            image = Toolkit.getDefaultToolkit().createImage(url);
        } else if (createEmptyImage) {
            image = Toolkit.getDefaultToolkit().createImage(new byte[]{0});
        }
        if (image != null) {
            image.flush();
            this.imageTable.put(imageName, image);
        }
        return image;
    }
}

