/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.io;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;

public class SequenceReader
extends Reader {
    private Enumeration<Reader> readers;
    private Reader currentReader;

    public SequenceReader(Enumeration<Reader> readers) {
        this.readers = readers;
        try {
            this.nextReader();
        }
        catch (IOException e) {
            throw new Error("panic");
        }
    }

    public SequenceReader(Reader ... readers) {
        this(Collections.enumeration(Arrays.asList(readers)));
    }

    @Override
    public int read() throws IOException {
        if (this.currentReader == null) {
            return -1;
        }
        int c = this.currentReader.read();
        if (c == -1) {
            this.nextReader();
            return this.read();
        }
        return c;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.currentReader == null) {
            return -1;
        }
        if (cbuf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int n = this.currentReader.read(cbuf, off, len);
        if (n <= 0) {
            this.nextReader();
            return this.read(cbuf, off, len);
        }
        return n;
    }

    final void nextReader() throws IOException {
        if (this.currentReader != null) {
            this.currentReader.close();
        }
        if (this.readers.hasMoreElements()) {
            this.currentReader = this.readers.nextElement();
            if (this.currentReader == null) {
                throw new NullPointerException();
            }
        } else {
            this.currentReader = null;
        }
    }

    @Override
    public boolean ready() throws IOException {
        return this.currentReader != null && this.currentReader.ready();
    }

    @Override
    public void close() throws IOException {
        do {
            this.nextReader();
        } while (this.currentReader != null);
    }
}

