/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.functors;

import ch.e2e.functors.Predicate;
import ch.e2e.functors.Transformer;

public class TransformedPredicate<T, U>
implements Predicate<T> {
    private final Predicate<? super U> predicate;
    private final Transformer<? super T, ? extends U> transformer;

    public TransformedPredicate(Transformer<? super T, ? extends U> transformer, Predicate<? super U> predicate) {
        this.predicate = predicate;
        this.transformer = transformer;
    }

    public static <T, U> TransformedPredicate<T, U> newPredicate(Transformer<? super T, ? extends U> transformer, Predicate<? super U> predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException("Argument 'predicate' must not be null.");
        }
        if (transformer == null) {
            throw new IllegalArgumentException("Argument 'transformer' must not be null.");
        }
        return new TransformedPredicate<T, U>(transformer, predicate);
    }

    @Override
    public boolean evaluate(T object) {
        U transformedObject = this.transformer.transform(object);
        return this.predicate.evaluate(transformedObject);
    }
}

