/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.functors;

import ch.e2e.functors.Predicate;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FilterIterator<E>
implements Iterator<E> {
    private final Iterator<E> iterator;
    private final Predicate<? super E> predicate;
    private E next;

    public FilterIterator(Iterator<E> iterator, Predicate<? super E> predicate) {
        this.iterator = iterator;
        this.predicate = predicate;
        this.next = this.tryGetNext();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public E next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        E result = this.next;
        this.next = this.tryGetNext();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public Iterator<E> getIterator() {
        return this.iterator;
    }

    public Predicate<? super E> getPredicate() {
        return this.predicate;
    }

    private E tryGetNext() {
        while (this.iterator.hasNext()) {
            E element = this.iterator.next();
            if (this.predicate != null && !this.predicate.evaluate(element)) continue;
            return element;
        }
        return null;
    }
}

