/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.models;

import ch.e2e.builder.compiler.models.E2EBridgeModelGenerator;
import ch.e2e.dom.DomUtilities;
import ch.e2e.transformer.TransformerLoader;
import ch.e2e.util.ArgumentParser;
import java.io.File;
import java.io.IOException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class E2EBridgeBaseParser {
    public static void main(String[] args) throws Exception {
        ArgumentParser argsParser = new ArgumentParser(args);
        TransformerLoader transformerLoader = new TransformerLoader(new File("src/main/xslt"), E2EBridgeModelGenerator.class.getClassLoader());
        Templates parseTemplate = transformerLoader.getTemplates(new File("templates/MD 18.0/parse.xsl"));
        Transformer parseTransformer = parseTemplate.newTransformer();
        File sourceFile = new File("templates/MD 18.0/E2E Bridge Base edit.xml");
        File baseFile = new File("templates/MD 18.0/E2E Bridge Base parsed edit.xml");
        DOMResult result = new DOMResult();
        parseTransformer.transform(new StreamSource(sourceFile), result);
        DomUtilities.serialize((File)baseFile, (Node)result.getNode(), (boolean)true);
        Document baseDocumentation = DomUtilities.parse((File)baseFile, (boolean)false, (boolean)false, (boolean)false);
        Element rootElement = baseDocumentation.getDocumentElement();
        Node node = rootElement.getFirstChild();
        while (node != null) {
            Node next = node.getNextSibling();
            String nodeName = node.getNodeName();
            if (nodeName != null) {
                if (nodeName.equals("ebm:package")) {
                    Node name = node.getAttributes().getNamedItem("name");
                    if (name != null && (name.getNodeValue().equals("Base Components") || name.getNodeValue().equals("Base Types"))) {
                        E2EBridgeBaseParser.doPackage(node, new File("src/main/resources/ch/e2e/builder/compiler/models/base"));
                    } else {
                        System.out.println(name);
                    }
                } else if (!nodeName.equals("#text")) {
                    System.out.println(nodeName);
                }
            }
            node = next;
        }
    }

    static void doPackage(Node node, File base) throws TransformerException, IOException {
        String name = node.getAttributes().getNamedItem("name").getNodeValue();
        File dir = new File(base, name);
        dir.mkdir();
        Node child = node.getFirstChild();
        while (child != null) {
            Node next = child.getNextSibling();
            String nodeName = child.getNodeName();
            if (nodeName != null) {
                if (nodeName.equals("ebm:package")) {
                    E2EBridgeBaseParser.doPackage(child, dir);
                } else if (nodeName.equals("ebm:class")) {
                    E2EBridgeBaseParser.doElement("class", child, dir);
                } else if (nodeName.equals("ebm:enumeration")) {
                    E2EBridgeBaseParser.doElement("enumeration", child, dir);
                } else if (nodeName.equals("ebm:node")) {
                    E2EBridgeBaseParser.doElement("node", child, dir);
                } else if (nodeName.equals("ebm:signal")) {
                    E2EBridgeBaseParser.doElement("signal", child, dir);
                } else if (nodeName.equals("ebm:component")) {
                    E2EBridgeBaseParser.doElement("component", child, dir);
                } else if (nodeName.equals("ebm:artifact")) {
                    E2EBridgeBaseParser.doElement("artifact", child, dir);
                } else if (nodeName.equals("ebm:interface")) {
                    E2EBridgeBaseParser.doElement("interface", child, dir);
                } else if (!(nodeName.equals("#text") || nodeName.equals("ebm:comment") || nodeName.equals("ebm:appliedStereotype"))) {
                    System.out.println(nodeName);
                }
            }
            child = next;
        }
        Document doc = DomUtilities.newDocument();
        Element newNode = (Element)doc.importNode(node, true);
        E2EBridgeBaseParser.addNamespaces(newNode);
        doc.appendChild(newNode);
        DomUtilities.serialize((File)new File(dir, name + ".package.xml"), (Document)doc, (boolean)true);
        node.getParentNode().removeChild(node);
    }

    static void doElement(String type, Node node, File base) throws TransformerException, IOException {
        File canonical;
        String name = node.getAttributes().getNamedItem("name").getNodeValue();
        Document doc = DomUtilities.newDocument();
        Element newNode = (Element)doc.importNode(node, true);
        E2EBridgeBaseParser.addNamespaces(newNode);
        doc.appendChild(newNode);
        String fullname = name.replace("/", "_") + "." + type.toLowerCase() + ".xml";
        File file = new File(base, fullname);
        if (file.exists() && !(canonical = file.getCanonicalFile()).getName().equals(fullname)) {
            file = new File(base, name.replace("/", "_") + "_." + type.toLowerCase() + ".xml");
        }
        DomUtilities.serialize((File)file, (Document)doc, (boolean)true);
        node.getParentNode().removeChild(node);
    }

    static void doClass(Node node, File base) throws TransformerException, IOException {
        String name = node.getAttributes().getNamedItem("name").getNodeValue();
        Document doc = DomUtilities.newDocument();
        Element newNode = (Element)doc.importNode(node, true);
        E2EBridgeBaseParser.addNamespaces(newNode);
        doc.appendChild(newNode);
        DomUtilities.serialize((File)new File(base, name + ".class.xml"), (Document)doc, (boolean)true);
        node.getParentNode().removeChild(node);
    }

    static void addNamespaces(Element elt) {
        elt.setAttribute("xmlns:ebm", "http://e2e.ch/bridge/models");
        elt.setAttribute("xmlns:xmi", "http://schema.omg.org/spec/XMI");
    }
}

