/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.swing.tree;

import ch.e2e.builder.base.gui.E2EBuilderInfoDialog;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.base.project.event.ProjectListener;
import ch.e2e.builder.trace.gui.event.MockBackendEvent;
import ch.e2e.builder.trace.gui.event.SelectUmlObjectEvent;
import ch.e2e.builder.trace.gui.testcase.TestcaseTransferHandler;
import ch.e2e.builder.trace.gui.tree.TestcaseTreeEvent;
import ch.e2e.builder.trace.gui.tree.TestcaseTreeListener;
import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcase;
import ch.e2e.builder.trace.testcase.TestcaseContainer;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import ch.e2e.builder.trace.testcase.TestcaseRoot;
import ch.e2e.builder.trace.tree.DefaultTestcaseTreeListener;
import ch.e2e.builder.trace.tree.DeleteWsdlEvent;
import ch.e2e.builder.trace.tree.RefreshSynchronousTreeEvent;
import ch.e2e.builder.trace.tree.RenameWsdlEvent;
import ch.e2e.builder.trace.tree.RunTestcaseRejectedEvent;
import ch.e2e.builder.trace.tree.TreeNodeChangedEvent;
import ch.e2e.builder.traceviewer.importer.ImportTestcasesEvent;
import ch.e2e.builder.traceviewer.importer.TestcasesImporter;
import ch.e2e.builder.traceviewer.swing.MainPanel;
import ch.e2e.builder.traceviewer.swing.tree.TestcaseTreeModel;
import ch.e2e.builder.traceviewer.swing.tree.TreeView;
import ch.e2e.builder.traceviewer.testcase.SynchronousTestcase;
import ch.e2e.builder.traceviewer.testcase.SynchronousTestcaseRoot;
import ch.e2e.builder.traceviewer.testcase.WSDLFolder;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.event.EventExecutionVetoException;
import ch.e2e.swing.Tree;
import ch.e2e.util.StringTools;
import java.awt.event.ActionEvent;
import java.util.EventObject;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;

public class SynchronousTreeView
extends TreeView {
    private TestcaseTreeListener testcaseListener;

    public SynchronousTreeView(SynchronousTestcaseRoot root, MainPanel mainPanel, E2EBuilderModule module) {
        super((TestcaseRoot)root, mainPanel, module);
        module.addProjectListener((ProjectListener)this);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) throws EventExecutionVetoException {
                RunTestcaseRejectedEvent e = (RunTestcaseRejectedEvent)event;
                if (e.getSource().equals(SynchronousTreeView.this.getModule())) {
                    HashMap<String, String> properties = new HashMap<String, String>();
                    properties.put("name", e.getTestcase().getName());
                    String message = StringTools.replaceProperties((String)SynchronousTreeView.this.getModule().getTranslation("tracer.testcase.running"), properties);
                    E2EBuilderInfoDialog.info((String)message);
                }
            }
        }, RunTestcaseRejectedEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) throws EventExecutionVetoException {
                new TestcasesImporter(SynchronousTreeView.this.getModule()).execute(event);
            }
        }, ImportTestcasesEvent.class);
    }

    @Override
    protected Tree createTree(TestcaseRoot root) {
        Tree tree = super.createTree(root);
        tree.setDragEnabled(true);
        tree.setTransferHandler((TransferHandler)new TestcaseTransferHandler(this.testcaseListener));
        return tree;
    }

    @Override
    protected void selectDiagram(SelectUmlObjectEvent event) {
        if (event.getTestcase() instanceof SynchronousTestcase) {
            super.selectDiagram(event);
        }
    }

    @Override
    protected TestcaseTreeModel newTreeModel(TestcaseRoot root) {
        this.testcaseListener = new DefaultTestcaseTreeListener(this.getModule(), null, true);
        return new TestcaseTreeModel(root, this.getModule(), this.testcaseListener);
    }

    @Override
    protected void addEventHandler() {
        this.addActions();
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) throws EventExecutionVetoException {
                SynchronousTreeView.this.refreshTree(event);
            }
        }, RefreshSynchronousTreeEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) throws EventExecutionVetoException {
                TestcaseObject node = ((TreeNodeChangedEvent)event).getNode();
                TestcaseContainer parent = node.getParent();
                int index = parent.getIndexOfChild((Object)node);
                SynchronousTreeView.this.getModel().nodeChanged(new TreePath(parent.getPath()), index, node);
            }
        }, TreeNodeChangedEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) throws EventExecutionVetoException {
                SynchronousTreeView.this.testcaseListener.mockBackendsManually(new TestcaseTreeEvent(event.getSource(), ((MockBackendEvent)event).getAdapter()));
            }
        }, MockBackendEvent.class);
    }

    private void addActions() {
        InputMap inputMap = this.getTree().getInputMap(0);
        ActionMap actionMap = this.getTree().getActionMap();
        this.addDeleteAction(inputMap, actionMap);
        this.addCopyAction(inputMap, actionMap);
        this.addPasteAction(inputMap, actionMap);
        this.addRenameAction(inputMap, actionMap);
    }

    private void addPasteAction(InputMap inputMap, ActionMap actionMap) {
        KeyStroke pasteStroke = KeyStroke.getKeyStroke(86, 2);
        inputMap.put(pasteStroke, "tracerviewer.tree.node.paste");
        actionMap.put("tracerviewer.tree.node.paste", TransferHandler.getPasteAction());
    }

    private void addCopyAction(InputMap inputMap, ActionMap actionMap) {
        inputMap.put(KeyStroke.getKeyStroke(67, 2), "tracerviewer.tree.node.copy");
        actionMap.put("tracerviewer.tree.node.copy", TransferHandler.getCopyAction());
    }

    private void addDeleteAction(InputMap inputMap, ActionMap actionMap) {
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "tracerviewer.tree.node.delete");
        actionMap.put("tracerviewer.tree.node.delete", new AbstractAction("tracerviewer.tree.node.delete"){

            @Override
            public void actionPerformed(ActionEvent event) {
                TreePath path = SynchronousTreeView.this.getSelectionPath();
                if (path != null) {
                    Object node = path.getLastPathComponent();
                    if (node instanceof WSDLFolder) {
                        EventController.fire((EventObject)new DeleteWsdlEvent((Object)this, path));
                    } else if (node instanceof AbstractSynchronousTestcase) {
                        SynchronousTreeView.this.testcaseListener.deleteTestcase(new TestcaseTreeEvent((Object)this, (AbstractSynchronousTestcase)node));
                    }
                }
            }
        });
    }

    private void addRenameAction(InputMap inputMap, ActionMap actionMap) {
        inputMap.put(KeyStroke.getKeyStroke(113, 0), "tracerviewer.tree.node.rename");
        actionMap.put("tracerviewer.tree.node.rename", new AbstractAction("tracerviewer.tree.node.rename"){

            @Override
            public void actionPerformed(ActionEvent event) {
                TreePath path = SynchronousTreeView.this.getSelectionPath();
                if (path != null) {
                    Object node = path.getLastPathComponent();
                    if (node instanceof AbstractSynchronousTestcase) {
                        SynchronousTreeView.this.testcaseListener.renameTestcase(new TestcaseTreeEvent((Object)this, (AbstractSynchronousTestcase)node));
                    } else if (node instanceof WSDLFolder) {
                        EventController.fire((EventObject)new RenameWsdlEvent((Object)this, path));
                    }
                }
            }
        });
    }
}

