/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.swing;

import ch.e2e.builder.base.application.E2EBuilderTransaction;
import ch.e2e.builder.base.application.abstracts.DoTransactionEvent;
import ch.e2e.builder.base.gui.ComponentFactory;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.traceviewer.execute.AsynchronousRequest;
import ch.e2e.builder.traceviewer.execute.AsynchronousTransaction;
import ch.e2e.builder.traceviewer.execute.DeleteObjectRequest;
import ch.e2e.builder.traceviewer.execute.GetObjectRequest;
import ch.e2e.builder.traceviewer.execute.ListObjectsRequest;
import ch.e2e.builder.traceviewer.swing.StateObjectDetailsDialog;
import ch.e2e.builder.traceviewer.testcase.AbstractAsyncTestcaseFolder;
import ch.e2e.builder.traceviewer.testcase.PersistentStateTestcaseFolder;
import ch.e2e.dom.DomUtilities;
import ch.e2e.event.EventController;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathExpression;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StatesView
extends JPanel {
    private static final String XPATH_OBJECT = "PState/Objects/Object";
    private static XPathExpression objectExpression;
    private PersistentStateTestcaseFolder testcase;
    private ListObjectsTransaction listObjectsTransaction;
    private GetObjectTransaction getObjectTransaction;
    private DeleteObjectTransaction deleteObjectTransaction;
    private E2EBuilderModule traceViewer;
    private JPanel center;
    private TreeMap<String, ArrayList<StateObject>> stateObjects;
    private StateObjectDetailsDialog stateObjectDetails;

    public StatesView(PersistentStateTestcaseFolder testcase, E2EBuilderModule traceViewer) {
        this.traceViewer = traceViewer;
        this.testcase = testcase;
        this.listObjectsTransaction = new ListObjectsTransaction(traceViewer);
        this.getObjectTransaction = new GetObjectTransaction(traceViewer);
        this.deleteObjectTransaction = new DeleteObjectTransaction(traceViewer);
        this.stateObjects = new TreeMap();
        this.createGui();
        this.listObjects(true);
    }

    public void refresh() {
    }

    private void setStateObjects() {
        this.center.removeAll();
        this.center.setLayout(new GridBagLayout());
        GridBagConstraints stateConstraints = new GridBagConstraints();
        stateConstraints.gridx = 0;
        stateConstraints.fill = 2;
        stateConstraints.anchor = 12;
        stateConstraints.weightx = 1.0;
        int i = 1;
        GridBagConstraints objectConstraints = new GridBagConstraints();
        objectConstraints.fill = 0;
        objectConstraints.insets = new Insets(0, 0, 0, 15);
        ArrayList<JLabel> names = new ArrayList<JLabel>();
        for (String state : this.stateObjects.keySet()) {
            ArrayList<StateObject> stateObjects = this.stateObjects.get(state);
            JPanel objectsPanel = new JPanel(new GridLayout(stateObjects.size(), 1));
            String stateBorderPrefix = this.traceViewer.getTranslation("pstate.object.state.border.title.prefix");
            TitledBorder border = new TitledBorder(stateBorderPrefix + state);
            border.setTitleFont(border.getTitleFont().deriveFont(1, border.getTitleFont().getSize2D() + 1.0f));
            objectsPanel.setBorder(border);
            for (final StateObject stateObject : stateObjects) {
                objectConstraints.gridwidth = 1;
                JPanel objectPanel = new JPanel(new GridBagLayout());
                objectConstraints.weightx = 0.0;
                JLabel name = new JLabel(stateObject.name);
                objectPanel.add((Component)name, objectConstraints);
                names.add(name);
                JLabel owner = new JLabel(stateObject.owner, 2);
                owner.setBackground(Color.LIGHT_GRAY);
                owner.setOpaque(true);
                objectConstraints.fill = 2;
                objectConstraints.weightx = 1.0;
                objectPanel.add((Component)owner, objectConstraints);
                objectConstraints.weightx = 0.0;
                JButton details = ComponentFactory.createButton((String)"pstate.object.details.button", (E2EBuilderModule)this.traceViewer);
                details.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        StatesView.this.showDetails(stateObject);
                    }
                });
                objectPanel.add((Component)details, objectConstraints);
                JButton delete = ComponentFactory.createButton((String)"pstate.object.delete.button", (E2EBuilderModule)this.traceViewer);
                delete.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        StatesView.this.deleteStateObject(stateObject);
                    }
                });
                objectConstraints.gridwidth = 0;
                objectPanel.add((Component)delete, objectConstraints);
                objectsPanel.add((Component)objectPanel, objectConstraints);
            }
            stateConstraints.weighty = i == this.stateObjects.size() ? 1.0 : 0.0;
            this.center.add((Component)objectsPanel, stateConstraints);
            ++i;
        }
        int width = 0;
        for (JLabel label : names) {
            width = Math.max(width, label.getPreferredSize().width);
        }
        for (JLabel label : names) {
            label.setPreferredSize(new Dimension(width, label.getPreferredSize().height));
        }
        SwingUtilities.updateComponentTreeUI(this);
    }

    private void showDetails(StateObject stateObject) {
        GetObjectRequest request = new GetObjectRequest((AbstractAsyncTestcaseFolder)this.testcase, stateObject.id);
        EventController.fire((EventObject)new DoTransactionEvent((Object)this, (E2EBuilderTransaction)this.getObjectTransaction, (Object)request));
    }

    private void deleteStateObject(StateObject stateObject) {
        DeleteObjectRequest request = new DeleteObjectRequest((AbstractAsyncTestcaseFolder)this.testcase, stateObject.id);
        EventController.fire((EventObject)new DoTransactionEvent((Object)this, (E2EBuilderTransaction)this.deleteObjectTransaction, (Object)request));
    }

    private void createGui() {
        this.setLayout(new BorderLayout());
        this.center = new JPanel();
        this.add((Component)new JScrollPane(this.center), "Center");
        JButton refresh = ComponentFactory.createButton((String)"pstate.object.list.refresh.button", (E2EBuilderModule)this.traceViewer);
        JPanel buttonPanel = new JPanel(new FlowLayout(0));
        buttonPanel.setBorder(new EmptyBorder(3, 5, 3, 0));
        buttonPanel.add(refresh);
        refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatesView.this.listObjects(false);
            }
        });
        this.add((Component)buttonPanel, "South");
    }

    private void listObjects(boolean ignoreErrors) {
        ListObjectsRequest request = new ListObjectsRequest((AbstractAsyncTestcaseFolder)this.testcase);
        this.listObjectsTransaction.setIgnoreErrors(ignoreErrors);
        EventController.fire((EventObject)new DoTransactionEvent((Object)this, (E2EBuilderTransaction)this.listObjectsTransaction, (Object)request));
    }

    private StateObjectDetailsDialog getDetailsDialog() {
        if (this.stateObjectDetails == null) {
            this.stateObjectDetails = new StateObjectDetailsDialog(this.traceViewer);
        }
        return this.stateObjectDetails;
    }

    static {
        try {
            XPath xpath = DomUtilities.newXPath();
            objectExpression = xpath.compile(XPATH_OBJECT);
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
    }

    private class StateObject {
        private String name;
        private String id;
        private String owner;
        private String state;

        private StateObject(Element objectElement) {
            this.name = DomUtilities.getTextValue((Element)objectElement, (String)"Name", (String)"");
            this.id = DomUtilities.getTextValue((Element)objectElement, (String)"Id", (String)"");
            this.owner = DomUtilities.getTextValue((Element)objectElement, (String)"Owner", (String)"");
            this.state = DomUtilities.getTextValue((Element)objectElement, (String)"StateName", (String)"");
            int index = this.state.indexOf("...");
            if (index != -1) {
                this.state = this.state.substring(0, index);
            }
        }
    }

    public class DeleteObjectTransaction
    extends AsynchronousTransaction {
        public DeleteObjectTransaction(E2EBuilderModule traceViewer) {
            super(traceViewer);
        }

        public void setTransactionResult(Object result) {
            super.setTransactionResult(result);
            StatesView.this.listObjects(false);
        }
    }

    public class GetObjectTransaction
    extends AsynchronousTransaction {
        public GetObjectTransaction(E2EBuilderModule traceViewer) {
            super(traceViewer);
        }

        public void setTransactionResult(Object result) {
            super.setTransactionResult(result);
            Document response = ((AsynchronousRequest)result).getResponse();
            if (response != null) {
                StatesView.this.getDetailsDialog().showDetails(response);
            }
        }
    }

    public class ListObjectsTransaction
    extends AsynchronousTransaction {
        private boolean ignoreErrors;

        public ListObjectsTransaction(E2EBuilderModule traceViewer) {
            super(traceViewer);
        }

        public void setTransactionResult(Object result) {
            super.setTransactionResult(result);
            Document response = ((AsynchronousRequest)result).getResponse();
            if (response != null) {
                try {
                    NodeList objects = (NodeList)objectExpression.evaluate(response, XPathConstants.NODESET);
                    StatesView.this.stateObjects.clear();
                    int length = objects.getLength();
                    for (int i = 0; i < length; ++i) {
                        StateObject stateObject = new StateObject((Element)objects.item(i));
                        ArrayList<StateObject> stateObjects = (ArrayList<StateObject>)StatesView.this.stateObjects.get(stateObject.state);
                        if (stateObjects == null) {
                            stateObjects = new ArrayList<StateObject>();
                            StatesView.this.stateObjects.put(stateObject.state, stateObjects);
                        }
                        stateObjects.add(stateObject);
                    }
                    StatesView.this.setStateObjects();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public boolean doErrorHandling(Throwable error) {
            return this.ignoreErrors || super.doErrorHandling(error);
        }

        public void setIgnoreErrors(boolean ignoreErrors) {
            this.ignoreErrors = ignoreErrors;
        }
    }
}

