/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.xslt;

import ch.e2e.bridge.server.JavaVirtualMachine;
import ch.e2e.bridge.server.session.Session;
import ch.e2e.bridge.server.xslt.XSLTScript;
import ch.e2e.bridge.server.xslt.XSLTTransformerFactory;
import ch.e2e.resource.Properties;
import java.io.File;
import java.io.IOException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;

public class TransformerLoader {
    private static TransformerLoader transformerLoader;
    private final GenericKeyedObjectPool<XSLTScript, Transformer> transformerPool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)new XSLTTransformerFactory());

    private TransformerLoader() {
        Properties properties = new Properties(new File(JavaVirtualMachine.getJarfilesPath(), "xsltTransformerPool.properties"));
        this.transformerPool.setMinIdle((int)properties.getInteger("min.idle", 1L));
        this.transformerPool.setMaxIdle((int)properties.getInteger("max.idle", 5L));
        this.transformerPool.setMaxActive((int)properties.getInteger("max.active", 5L));
        this.transformerPool.setMaxTotal((int)properties.getInteger("max.total", -1L));
        this.transformerPool.setMinEvictableIdleTimeMillis((long)((int)properties.getInteger("min.evictable.idle.time", 600000L)));
        this.transformerPool.setTimeBetweenEvictionRunsMillis((long)((int)properties.getInteger("time.between.eviction.time.runs", 540000L)));
        this.transformerPool.setNumTestsPerEvictionRun((int)properties.getInteger("num.tests.per.eviction.run", 3L));
    }

    public static TransformerLoader getInstance() {
        if (transformerLoader == null) {
            transformerLoader = new TransformerLoader();
        }
        return transformerLoader;
    }

    public Transformer borrowTransformer(XSLTScript script, Session session) throws Exception {
        script.setSession(session);
        return (Transformer)this.transformerPool.borrowObject((Object)script);
    }

    public void returnTransformer(XSLTScript script, Transformer transformer) throws Exception {
        transformer.clearParameters();
        this.transformerPool.returnObject((Object)script, (Object)transformer);
    }

    public Transformer newTransformer(String transformerFactory) throws TransformerConfigurationException, IOException {
        Transformer transformer;
        if (transformerFactory == null) {
            TransformerFactory factory = TransformerFactory.newInstance();
            transformer = factory.newTransformer();
        } else {
            transformer = XSLTTransformerFactory.getTransformerFactory(transformerFactory).newTransformer();
        }
        return transformer;
    }
}

