/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.session;

import ch.e2e.bridge.server.BridgeError;
import ch.e2e.bridge.server.JavaAddOn;
import ch.e2e.bridge.server.Logger;
import ch.e2e.bridge.server.MapEntry;
import ch.e2e.bridge.server.MapEntryWrapper;
import ch.e2e.bridge.server.Wrapper;
import ch.e2e.bridge.server.dataitem.Item;
import ch.e2e.bridge.server.dataitem.RecordItem;
import ch.e2e.bridge.server.session.SessionLogger;
import ch.e2e.bridge.server.session.SessionObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public final class Session {
    private Map<String, JavaAddOn> addOns = new HashMap<String, JavaAddOn>();
    private Set<Item> sessionItems = new HashSet<Item>();
    private Map<Object, Wrapper> wrappers = new HashMap<Object, Wrapper>();
    private Map<Long, Integer> referencedItems = new HashMap<Long, Integer>();
    private Map<Object, SessionObject> sessionObjects = new HashMap<Object, SessionObject>();
    private Logger logger;
    private String sessionId;
    private Long nativeSession;

    private static native void dumpAddOnComponentIOEntry(long var0, String var2, String var3, byte[] var4);

    private static native void dumpAddOnComponentIOExit(long var0, byte[] var2);

    private static native String nativeGetCorrelationID(long var0, boolean var2);

    private static native String nativeGetTransactionID(long var0);

    private static native String nativeGetInstanceName(long var0);

    private static native String nativeGetHostName(long var0);

    Session(String sessionId) {
        this.sessionId = sessionId;
    }

    Session(long nativeSession) {
        this(String.valueOf(nativeSession));
        this.logger = new Logger(nativeSession);
        this.nativeSession = nativeSession;
    }

    public void putSessionObject(Object key, SessionObject value) {
        this.sessionObjects.put(key, value);
    }

    public SessionObject getSessionObject(Object key) {
        return this.sessionObjects.get(key);
    }

    public void addError(String category, String domain, String code, String description) {
        if (this.logger != null) {
            this.logger.addError(category, domain, code, description);
        }
    }

    public void addError(BridgeError error) {
        if (this.logger != null) {
            this.logger.addError(error.getCategory(), error.getDomain(), error.getCode(), error.getDescription());
        }
    }

    public void log(long logLevel, String category, String domain, String code, String description) {
        if (this.logger != null) {
            this.logger.log(logLevel, category, domain, code, description);
        }
    }

    public void logTransaction(long level, boolean state, String domain, String type, String description, String value) {
        if (this.logger != null) {
            this.logger.logTransaction(level, state ? "OK" : "ERROR", domain, type, description, value);
        }
    }

    public void logTransaction(long level, boolean state, String domain, String type, String description, String value, String correlationID) {
        if (this.logger != null) {
            this.logger.logTransaction(level, state ? "OK" : "ERROR", domain, type, description, value, correlationID);
        }
    }

    public void logEnter(long level, boolean state, String domain, String description, String value) {
        if (this.logger != null) {
            this.logger.logTransaction(level, state ? "OK" : "ERROR", domain, "IO_ENTER", description, value);
        }
    }

    public void logEnter(long level, boolean state, String domain, String description, String value, String correlationID) {
        if (this.logger != null) {
            this.logger.logTransaction(level, state ? "OK" : "ERROR", domain, "IO_ENTER", description, value, correlationID);
        }
    }

    public void logExit(long level, boolean state, String domain, String description, String value) {
        if (this.logger != null) {
            this.logger.logTransaction(level, state ? "OK" : "ERROR", domain, "IO_EXIT", description, value);
        }
    }

    public void logExit(long level, boolean state, String domain, String description, String value, String correlationID) {
        if (this.logger != null) {
            this.logger.logTransaction(level, state ? "OK" : "ERROR", domain, "IO_EXIT", description, value, correlationID);
        }
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public JavaAddOn findAddOn(String name, String classname, int id) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        String key = classname + '_' + id;
        JavaAddOn addOn = this.addOns.get(key);
        if (addOn == null) {
            Class<?> addOnClass = Class.forName(classname);
            Constructor<?> constructor = addOnClass.getConstructor(String.class, Session.class);
            addOn = (JavaAddOn)constructor.newInstance(name, this);
            this.addOns.put(classname, addOn);
        }
        return addOn;
    }

    void commit() {
        for (SessionObject sessionObject : this.sessionObjects.values()) {
            sessionObject.commit(this.sessionId);
        }
        this.sessionObjects.clear();
        this.clear();
    }

    void rollback() {
        for (SessionObject sessionObject : this.sessionObjects.values()) {
            sessionObject.rollback(this.sessionId);
        }
        this.sessionObjects.clear();
        this.clear();
    }

    public void clear() {
        for (Item item : this.sessionItems) {
            item.release();
        }
        this.sessionItems.clear();
        for (Map.Entry entry : this.referencedItems.entrySet()) {
            for (int i = 0; i < (Integer)entry.getValue(); ++i) {
                Item.nativeGetReferenceCount((Long)entry.getKey());
            }
        }
        this.referencedItems.clear();
        this.addOns.clear();
        this.wrappers.clear();
    }

    public void addItem(Item item) {
        this.sessionItems.add(item);
    }

    public void removeItem(Item item) {
        this.sessionItems.remove(item);
    }

    public Wrapper fillWrapper(Object object, Class wrapperClass) {
        Wrapper wrapper = null;
        if (object != null) {
            wrapper = this.wrappers.get(object);
            if (wrapper == null) {
                try {
                    Constructor constructor = wrapperClass.getConstructor(Session.class);
                    wrapper = (Wrapper)constructor.newInstance(this);
                    this.wrappers.put(object, wrapper);
                }
                catch (Exception e) {
                    SessionLogger.getInstance().error("0", e);
                }
            }
            if (wrapper != null) {
                wrapper.fill(object);
            }
        }
        return wrapper;
    }

    public MapEntryWrapper fillWrapper(MapEntry entry, Class wrapperClass) {
        MapEntryWrapper wrapper = null;
        if (entry != null) {
            wrapper = (MapEntryWrapper)this.wrappers.get(entry);
            if (wrapper == null) {
                try {
                    Constructor constructor = wrapperClass.getConstructor(Session.class);
                    wrapper = (MapEntryWrapper)constructor.newInstance(this);
                    this.wrappers.put(entry, wrapper);
                }
                catch (Exception e) {
                    SessionLogger.getInstance().error("0", e);
                }
            }
            if (wrapper != null) {
                wrapper.fill(entry.getKey(), entry.getValue());
            }
        }
        return wrapper;
    }

    public Wrapper getWrapper(Object object) {
        return this.wrappers.get(object);
    }

    public Wrapper fillWrapper(Object object, RecordItem item, Class wrapperClass) {
        Wrapper wrapper = this.wrappers.get(object);
        if (wrapper == null) {
            try {
                Constructor constructor = wrapperClass.getConstructor(RecordItem.class, Session.class);
                wrapper = (Wrapper)constructor.newInstance(item, this);
                this.wrappers.put(object, wrapper);
            }
            catch (Exception e) {
                SessionLogger.getInstance().error("0", e);
            }
        }
        if (wrapper != null) {
            wrapper.fill(object);
        }
        return wrapper;
    }

    public Object createObject(RecordItem item, Class wrapperClass) {
        Object object = null;
        Wrapper wrapper = null;
        try {
            Constructor constructor = wrapperClass.getConstructor(RecordItem.class, Session.class);
            wrapper = (Wrapper)constructor.newInstance(item, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (wrapper != null) {
            object = wrapper.toObject();
            this.wrappers.put(object, wrapper);
        }
        return object;
    }

    public void addReferencedItem(long nativeItem) {
        Integer referenceCounter = this.referencedItems.get(nativeItem);
        int count = referenceCounter == null ? 0 : referenceCounter;
        this.referencedItems.put(nativeItem, ++count);
    }

    public void dumpIOEntry(String type, String target, byte[] input) {
        if (this.nativeSession != null) {
            Session.dumpAddOnComponentIOEntry(this.nativeSession, type, target, input);
        }
    }

    public void dumpIOExit(byte[] output) {
        if (this.nativeSession != null) {
            Session.dumpAddOnComponentIOExit(this.nativeSession, output);
        }
    }

    public String getCorrelationId(boolean create) {
        if (this.nativeSession != null) {
            return Session.nativeGetCorrelationID(this.nativeSession, create);
        }
        return null;
    }

    public String getTransactionId() {
        return this.nativeGetValueOrNull(Session::nativeGetTransactionID);
    }

    public String getHostName() {
        return this.nativeGetValueOrNull(Session::nativeGetHostName);
    }

    public String getInstanceName() {
        return this.nativeGetValueOrNull(Session::nativeGetInstanceName);
    }

    private <R> R nativeGetValueOrNull(Function<Long, R> callback) {
        if (this.nativeSession != null) {
            try {
                return callback.apply(this.nativeSession);
            }
            catch (UnsatisfiedLinkError e) {
                SessionLogger.getInstance().debug("native callback", String.format("Runtime doesn't implement native callback '%s'.", e.getMessage()));
            }
        }
        return null;
    }
}

