/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.dataitem;

import ch.e2e.bridge.server.dataitem.IntegerItem;
import ch.e2e.bridge.server.dataitem.SimpleItem;
import ch.e2e.bridge.server.dataitem.StringItem;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;

public class FloatItem
extends SimpleItem {
    private static native long nativeCreate();

    private static native double nativeGetValueAsdouble(long var0);

    private static native void nativeSetValueFromdouble(long var0, double var2);

    private static native long nativeConvertToStringItem(long var0);

    private static native long nativeGetDividend(long var0);

    private static native long nativeGetDivisor(long var0);

    private static native void nativeSetValue(long var0, long var2);

    private static native void nativeSetValueFromIntegers(long var0, long var2, long var4);

    private static native void nativeAdd(long var0, long var2);

    private static native void nativeSubtract(long var0, long var2);

    private static native void nativeMultiply(long var0, long var2);

    private static native void nativeDivide(long var0, long var2);

    private static native void nativeChangeSign(long var0);

    private static native void nativeSetSign(long var0, boolean var2);

    private static native byte nativeCompare(long var0, long var2);

    private static native boolean nativeIsPositive(long var0);

    private static native boolean nativeIsNull(long var0);

    private static native byte[] nativeConvertToString(long var0, long var2);

    private static native boolean nativeConvertFromString(long var0, byte[] var2);

    FloatItem() {
        super(FloatItem.nativeCreate());
    }

    FloatItem(long nativeItem) {
        super(nativeItem);
    }

    public StringItem convertToStringItem() {
        return new StringItem(FloatItem.nativeConvertToStringItem(this.getNativeItem()));
    }

    public IntegerItem getDividend() {
        return new IntegerItem(FloatItem.nativeGetDividend(this.getNativeItem()));
    }

    public IntegerItem getDivisor() {
        return new IntegerItem(FloatItem.nativeGetDivisor(this.getNativeItem()));
    }

    @Override
    public double doubleValue() {
        return FloatItem.nativeGetValueAsdouble(this.getNativeItem());
    }

    @Override
    public Double getValueAsDouble() {
        return FloatItem.nativeGetValueAsdouble(this.getNativeItem());
    }

    @Override
    public BigDecimal getValueAsBigDecimal() {
        return BigDecimal.valueOf(FloatItem.nativeGetValueAsdouble(this.getNativeItem()));
    }

    @Override
    public float floatValue() {
        return (float)FloatItem.nativeGetValueAsdouble(this.getNativeItem());
    }

    @Override
    public Float getValueAsFloat() {
        return Float.valueOf((float)FloatItem.nativeGetValueAsdouble(this.getNativeItem()));
    }

    @Override
    public Object getValue() {
        return BigDecimal.valueOf(FloatItem.nativeGetValueAsdouble(this.getNativeItem()));
    }

    @Override
    public void setValue(float value) {
        FloatItem.nativeSetValueFromdouble(this.getNativeItem(), value);
    }

    @Override
    public void setValue(double value) {
        FloatItem.nativeSetValueFromdouble(this.getNativeItem(), value);
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof BigDecimal) {
            try {
                this.convertFromString(value.toString());
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        } else if (value instanceof Number) {
            FloatItem.nativeSetValueFromdouble(this.getNativeItem(), ((Number)value).doubleValue());
        } else {
            super.setValue(value);
        }
    }

    public void setValue(FloatItem value) {
        FloatItem.nativeSetValue(this.getNativeItem(), value.getNativeItem());
    }

    public void setValue(IntegerItem dividendItem, IntegerItem divisorItem) {
        FloatItem.nativeSetValueFromIntegers(this.getNativeItem(), dividendItem.getNativeItem(), divisorItem.getNativeItem());
    }

    public void add(FloatItem value) {
        FloatItem.nativeAdd(this.getNativeItem(), value.getNativeItem());
    }

    public void subtract(FloatItem value) {
        FloatItem.nativeSubtract(this.getNativeItem(), value.getNativeItem());
    }

    public void multiply(FloatItem value) {
        FloatItem.nativeMultiply(this.getNativeItem(), value.getNativeItem());
    }

    public void divide(FloatItem value) {
        FloatItem.nativeDivide(this.getNativeItem(), value.getNativeItem());
    }

    public void changeSign() {
        FloatItem.nativeChangeSign(this.getNativeItem());
    }

    public void setSign(boolean sign) {
        FloatItem.nativeSetSign(this.getNativeItem(), sign);
    }

    public byte compare(FloatItem value) {
        return FloatItem.nativeCompare(this.getNativeItem(), value.getNativeItem());
    }

    public boolean isPositive() {
        return FloatItem.nativeIsPositive(this.getNativeItem());
    }

    public boolean isNull() {
        return FloatItem.nativeIsNull(this.getNativeItem());
    }

    public String convertToString(long fractionLength) throws UnsupportedEncodingException {
        return new String(FloatItem.nativeConvertToString(this.getNativeItem(), fractionLength), StandardCharsets.UTF_8);
    }

    public boolean convertFromString(String value) throws UnsupportedEncodingException {
        return FloatItem.nativeConvertFromString(this.getNativeItem(), value.getBytes(StandardCharsets.UTF_8));
    }
}

