/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.testcase;

import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcase;
import ch.e2e.builder.trace.testcase.TraceSettings;
import ch.e2e.builder.trace.tools.TypeMapper;
import ch.e2e.dom.DomUtilities;
import ch.e2e.io.FileUtilities;
import ch.e2e.resource.Properties;
import java.io.File;
import java.io.IOException;
import java.util.MissingResourceException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TestcaseConverter {
    static void convertOldProperties(Properties properties, AbstractSynchronousTestcase testcase) {
        String location = null;
        try {
            location = properties.getString("last_run_location").trim();
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            testcase.setCustomLocation(properties.getString("custom_location"));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        testcase.setUseCustomLocation(location != null && location.equals(testcase.getCustomLocation()));
        try {
            TraceSettings trace = testcase.getTraceSettings();
            String traceLevel = properties.getString("trace_level");
            if (!traceLevel.equals("None")) {
                trace.setEnabled(true);
                if (traceLevel.equals("Full")) {
                    trace.setTraceLevel(TraceSettings.TraceLevel.Full);
                } else {
                    trace.setTraceLevel(TraceSettings.TraceLevel.Moderate);
                }
            } else {
                trace.setEnabled(false);
                trace.setTraceLevel(TraceSettings.TraceLevel.Moderate);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            testcase.setDescription(properties.getString("description"));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        testcase.saveProperties();
    }

    static void convertOldRequestFile(File oldRequest, AbstractSynchronousTestcase testcase) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        if (testcase.isRPCEncoding()) {
            Document newRequest = DomUtilities.newDocument((String)"Request");
            Element newRequestElement = newRequest.getDocumentElement();
            Document requestDocument = DomUtilities.parse((File)oldRequest, (boolean)false, (boolean)false);
            Element oldRequestElement = requestDocument.getDocumentElement();
            TestcaseConverter.convertRequestElement(newRequestElement, oldRequestElement);
            DomUtilities.serialize((File)testcase.getRequestFile(), (Document)newRequest, (boolean)true);
        } else {
            FileUtilities.copyFile((File)oldRequest, (File)testcase.getRequestFile());
        }
    }

    static void convertRequestElement(Element newRequest, Element oldRequestDocument) {
        Element body = (Element)oldRequestDocument.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body").item(0);
        Node oldRequest = null;
        NodeList children = body.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length && oldRequest == null; ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            oldRequest = (Element)child;
        }
        newRequest.setAttribute("name", oldRequest.getLocalName());
        newRequest.setAttribute("namespace", oldRequest.getNamespaceURI());
        newRequest.setAttribute("prefix", oldRequest.getPrefix());
        Element parameterElement = newRequest.getOwnerDocument().createElement("Parameter");
        TestcaseConverter.appendChildren((Element)oldRequest, parameterElement, oldRequestDocument);
        newRequest.appendChild(parameterElement);
    }

    private static void appendChildren(Element oldParent, Element newParent, Element oldRequest) {
        NodeList children = oldParent.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            TestcaseConverter.convertParameter((Element)child, oldRequest, newParent);
        }
    }

    private static void convertParameter(Element oldParameter, Element oldRequest, Element newParent) {
        Element newParameter = newParent.getOwnerDocument().createElement(oldParameter.getLocalName());
        if (oldParameter.hasAttributeNS("http://schemas.xmlsoap.org/soap/encoding/", "arrayType")) {
            int index;
            String arrayType = oldParameter.getAttributeNS("http://schemas.xmlsoap.org/soap/encoding/", "arrayType");
            String prefix = (arrayType = arrayType.substring(0, arrayType.length() - 2)).substring(0, index = arrayType.indexOf(58));
            if (prefix.equals("xsd")) {
                newParameter.setAttribute("arrayType", TypeMapper.xsd2BridgeType((String)arrayType.substring(index + 1)));
            } else {
                String namespace = oldRequest.getAttribute("xmlns:" + prefix);
                newParameter.setAttribute("namespace", namespace);
                newParameter.setAttribute("prefix", prefix);
                newParameter.setAttribute("arrayType", arrayType.substring(index + 1));
            }
            newParameter.setAttribute("type", "Base Types.Array");
            TestcaseConverter.appendChildren(oldParameter, newParameter, oldRequest);
        } else {
            int index;
            String type = oldParameter.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
            String prefix = type.substring(0, index = type.indexOf(58));
            if (prefix.equals("xsd")) {
                String value;
                String newType = TypeMapper.xsd2BridgeType((String)type.substring(index + 1));
                newParameter.setAttribute("type", newType);
                String string = value = oldParameter.hasChildNodes() ? oldParameter.getFirstChild().getNodeValue().trim() : "";
                if (value.length() > 0) {
                    if (newType.equals("Base Types.Boolean") && value.length() == 1) {
                        value = value.equals("0") ? "false" : "true";
                    }
                    newParameter.appendChild(newParameter.getOwnerDocument().createTextNode(value));
                }
            } else {
                String namespace = oldRequest.getAttribute("xmlns:" + prefix);
                newParameter.setAttribute("namespace", namespace);
                newParameter.setAttribute("prefix", prefix);
                newParameter.setAttribute("type", type.substring(index + 1));
                TestcaseConverter.appendChildren(oldParameter, newParameter, oldRequest);
            }
        }
        newParent.appendChild(newParameter);
    }
}

