/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.testcase;

import ch.e2e.builder.base.io.UniqueIdService;
import ch.e2e.builder.base.io.WrongIDFileVersionException;
import ch.e2e.builder.trace.request.BearerTokenCredentials;
import ch.e2e.builder.trace.testcase.AbstractAsynchronousTestcase;
import ch.e2e.builder.trace.testcase.TestcaseContainer;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import ch.e2e.builder.trace.testcase.TraceSettings;
import ch.e2e.builder.traceviewer.testcase.AsynchronousFolder;
import ch.e2e.builder.traceviewer.testcase.AsynchronousTestcaseTemplate;
import ch.e2e.builder.traceviewer.testcase.Identifier;
import ch.e2e.io.FileUtilities;
import ch.e2e.resource.Properties;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;

public abstract class AbstractAsyncTestcaseFolder
extends TestcaseContainer {
    private static final String TESTCASE_PROPERTIES = "testcase.properties";
    private static final String TRACING_UNKOWN = "async.testcase.folder.tracing.unkown";
    private static final String TRACING_DISABLED = "async.testcase.folder.tracing.disabled";
    private static final String TRACING_ENABLED = "async.testcase.folder.tracing.enabled";
    private static final String TRACING_TOOLTIP = "async.testcase.folder.tracing.tooltip";
    private static final String NO_TRACING_TOOLTIP = "async.testcase.folder.no.tracing.tooltip";
    private static final String UNKNOWN_TRACING_TOOLTIP = "async.testcase.folder.unknown.tracing.tooltip";
    private File home;
    private LocationType selectedLocationType = LocationType.SYSTEM;
    private String systemLocation;
    private String customLocation;
    private boolean useOAuth2 = false;
    private String oAuth2Username;
    private String oAuth2Password;
    private String bridgeLocation;
    private String bridgeUser;
    private String bridgePassword;
    private List<Identifier> identifiers = new ArrayList<Identifier>();
    private final String classifier;
    private Properties properties;
    private Map<String, String> uniqueIds;
    private File idFile;
    private List<String> primaryKeyNames;
    private Configuration proposedConfiguration;
    private Configuration configuration;
    public static final Configuration EMPTY_CONFIGURATION = new Configuration();

    public AbstractAsyncTestcaseFolder(AsynchronousTestcaseTemplate template, File home, File idFile) throws FileNotFoundException {
        this(template);
        this.home = home;
        this.idFile = idFile;
        this.initializeUniqueIds();
        File propertiesFile = new File(home, TESTCASE_PROPERTIES);
        if (propertiesFile.exists()) {
            this.loadProperties();
        } else {
            this.properties = new Properties(propertiesFile);
            this.saveProperties();
        }
        this.loadChildren();
    }

    private AbstractAsyncTestcaseFolder(AsynchronousTestcaseTemplate template) {
        super(template.getName(), template.getTestcaseFolderType());
        this.classifier = template.getType();
        this.systemLocation = template.getLocation();
        this.primaryKeyNames = template.getPrimaryKeyNames();
        this.proposedConfiguration = new Configuration();
    }

    public abstract AbstractAsynchronousTestcase createTestcase(File var1, Identifier var2);

    protected abstract AbstractAsynchronousTestcase createTestcase(File var1) throws FileNotFoundException;

    public File getHome() {
        return this.home;
    }

    protected void setHome(File newHome) {
        this.home = new File(newHome, this.home.getName());
        this.idFile = new File(this.home, this.idFile.getName());
        for (TestcaseObject o : this.getChildren().values()) {
            if (!(o instanceof AbstractAsynchronousTestcase)) continue;
            ((AbstractAsynchronousTestcase)o).setHome(this.home);
        }
    }

    public Object getChild(int index) {
        return this.getSortedChildren().get(index);
    }

    public int getIndexOfChild(Object child) {
        return this.getSortedChildren().indexOf(child);
    }

    protected List<TestcaseObject> getSortedChildren() {
        ArrayList<TestcaseObject> list = new ArrayList<TestcaseObject>(this.getChildren().values());
        Collections.sort(list);
        return list;
    }

    public int getType() {
        return super.getType() + this.getTypeOffset();
    }

    public String getTracingInfo() {
        switch (this.getTypeOffset()) {
            default: {
                return TRACING_UNKOWN;
            }
            case 1: {
                return TRACING_DISABLED;
            }
            case 2: 
        }
        return TRACING_ENABLED;
    }

    private int getTypeOffset() {
        if (!this.hasConfiguration()) {
            return 0;
        }
        if (this.configuration.isEmpty()) {
            return 1;
        }
        return 2;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof AbstractAsyncTestcaseFolder) {
            result = this.home.equals(((AbstractAsyncTestcaseFolder)((Object)obj)).home);
        }
        return result;
    }

    public int hashCode() {
        return this.getClassifier().hashCode();
    }

    public String getServiceName() {
        AsynchronousFolder root = this.findImportRoot();
        return root == null ? null : root.getServiceName();
    }

    private void setServiceName(String serviceName) {
        AsynchronousFolder root = this.findImportRoot();
        if (root != null) {
            root.setServiceName(serviceName);
        }
    }

    private AsynchronousFolder findImportRoot() {
        for (TestcaseContainer parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof AsynchronousFolder)) continue;
            return (AsynchronousFolder)parent;
        }
        return null;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getLocation() {
        switch (this.selectedLocationType) {
            default: {
                return this.systemLocation;
            }
            case CUSTOM: {
                return this.customLocation;
            }
            case BRIDGE: 
        }
        return this.bridgeLocation;
    }

    public String getCustomLocation() {
        return this.customLocation;
    }

    public void setCustomLocation(String customLocation) {
        this.customLocation = customLocation;
    }

    public boolean isUseOAuth2() {
        return this.useOAuth2;
    }

    public void setUseOAuth2(boolean useOAuth2) {
        this.useOAuth2 = useOAuth2;
    }

    public String getOAuth2Username() {
        return this.oAuth2Username;
    }

    public void setOAuth2Username(String oAuth2Username) {
        this.oAuth2Username = oAuth2Username;
    }

    public String getOAuth2Password() {
        return this.oAuth2Password;
    }

    public void setOAuth2Password(String oAuth2Password) {
        this.oAuth2Password = oAuth2Password;
    }

    public LocationType getSelectedLocationType() {
        return this.selectedLocationType;
    }

    public void setSelectedLocationType(LocationType selectedLocationType) {
        this.selectedLocationType = selectedLocationType;
    }

    public String getSystemLocation() {
        return this.systemLocation;
    }

    public String getBridgeLocation() {
        return this.bridgeLocation;
    }

    public void setBridgeLocation(String bridgeLocation) {
        this.bridgeLocation = bridgeLocation;
        this.setServiceName(bridgeLocation.substring(bridgeLocation.lastIndexOf(47) + 1));
    }

    public void maybeFixBridgeLocation() {
        if (this.bridgeLocation != null) {
            int pos = this.bridgeLocation.lastIndexOf(47) + 1;
            String serviceName = this.bridgeLocation.substring(pos);
            String rootServiceName = this.getServiceName();
            if (!rootServiceName.equals(serviceName)) {
                this.bridgeLocation = this.bridgeLocation.substring(0, pos) + rootServiceName;
                this.saveProperties();
            }
        }
    }

    public String getBridgeUser() {
        return this.bridgeUser;
    }

    public void setBridgeUser(String bridgeUser) {
        this.bridgeUser = bridgeUser;
    }

    public String getBridgePassword() {
        return this.bridgePassword;
    }

    public void setBridgePassword(String bridgePassword) {
        this.bridgePassword = bridgePassword;
    }

    public Credentials getCredentials() {
        if (this.selectedLocationType.equals((Object)LocationType.BRIDGE) && this.getBridgeUser() != null) {
            return new UsernamePasswordCredentials(this.getBridgeUser(), this.getBridgePassword());
        }
        if (this.selectedLocationType.equals((Object)LocationType.CUSTOM) && this.isUseOAuth2()) {
            return new BearerTokenCredentials(this.getLocation(), this.getOAuth2Username(), this.getOAuth2Password());
        }
        return null;
    }

    public List<String> getPrimaryKeyNames() {
        return this.primaryKeyNames;
    }

    public List<Identifier> getIdentifiers() {
        return this.identifiers;
    }

    public void setIdentifiers(List<Identifier> identifiers) {
        this.identifiers = identifiers;
    }

    public TraceSettings.TraceLevel getTraceLevel() {
        return this.hasConfiguration() ? this.configuration.traceLevel : null;
    }

    public Integer getTraceMaxSize() {
        return this.hasConfiguration() ? Integer.valueOf(this.configuration.traceMaxSize) : null;
    }

    public Collection<String> getInspectionIds() {
        return this.hasConfiguration() ? this.configuration.inspectionsIds : Collections.emptyList();
    }

    public TraceSettings.TraceLevel getProposedTraceLevel() {
        return this.proposedConfiguration.traceLevel;
    }

    public int getProposedTraceMaxSize() {
        return this.proposedConfiguration.traceMaxSize;
    }

    public Collection<String> getProposedInspectionIds() {
        return this.proposedConfiguration.inspectionsIds;
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void removeConfiguration() {
        this.configuration = null;
    }

    public Configuration getProposedConfiguration() {
        return this.proposedConfiguration;
    }

    public void setProposedConfiguration(Configuration proposedConfiguration) {
        this.proposedConfiguration = proposedConfiguration;
    }

    public String getTooltip() {
        int type = this.getType();
        String tooltip = type == 23 ? TRACING_TOOLTIP : (type == 22 ? NO_TRACING_TOOLTIP : UNKNOWN_TRACING_TOOLTIP);
        return tooltip;
    }

    public AbstractAsynchronousTestcase getTestcase(Identifier identifier) {
        String key = this.getKey(identifier);
        String id = this.uniqueIds.get(key);
        return id == null ? null : (AbstractAsynchronousTestcase)this.get(id);
    }

    public AbstractAsynchronousTestcase createTestcase(Identifier identifier) {
        String key = this.getKey(identifier);
        String uniqueId = UniqueIdService.createUniqueId((String)key, this.uniqueIds);
        UniqueIdService.saveIds(this.uniqueIds, (File)this.idFile);
        File testcaseHome = new File(this.home, uniqueId);
        testcaseHome.mkdirs();
        return this.createTestcase(testcaseHome, identifier);
    }

    private String getKey(Identifier identifier) {
        return identifier.getIdentifier();
    }

    public void delete() {
        FileUtilities.silentDeleteDirectory((File)this.home);
    }

    public void saveProperties() {
        if (this.customLocation == null || this.customLocation.isEmpty()) {
            this.properties.removeProperty("location.custom");
        } else {
            this.properties.setProperty("location.custom", this.customLocation);
        }
        if (this.useOAuth2) {
            this.properties.setProperty("use.oauth2", true);
        } else {
            this.properties.removeProperty("use.oauth2");
        }
        if (this.oAuth2Username == null || this.oAuth2Username.isEmpty()) {
            this.properties.removeProperty("oauth2.user");
        } else {
            this.properties.setProperty("oauth2.user", this.oAuth2Username);
        }
        if (this.oAuth2Password == null || this.oAuth2Password.isEmpty()) {
            this.properties.removeProperty("oauth2.password");
        } else {
            this.properties.setProperty("oauth2.password", Base64.getEncoder().encodeToString(this.oAuth2Password.getBytes(StandardCharsets.UTF_8)));
        }
        if (this.bridgeLocation == null || this.bridgeLocation.isEmpty()) {
            this.properties.removeProperty("location.https");
        } else {
            this.properties.setProperty("location.https", this.bridgeLocation);
        }
        if (this.bridgeUser == null || this.bridgeUser.isEmpty()) {
            this.properties.removeProperty("https.user");
        } else {
            this.properties.setProperty("https.user", this.bridgeUser);
        }
        if (this.getLocation() == null) {
            this.properties.removeProperty("location");
        } else {
            this.properties.setProperty("location", this.getLocation());
        }
        if (this.getProposedTraceLevel() == TraceSettings.TraceLevel.None) {
            this.properties.removeProperty("trace.mode");
        } else {
            this.properties.setProperty("trace.mode", (long)this.getProposedTraceLevel().getMode());
        }
        if (this.getProposedTraceMaxSize() == -1) {
            this.properties.removeProperty("trace.maxsize");
        } else {
            this.properties.setProperty("trace.maxsize", (long)this.getProposedTraceMaxSize());
        }
        if (this.getProposedInspectionIds().isEmpty()) {
            this.properties.removeProperty("inspection");
        } else {
            this.properties.setProperty("inspection", this.getProposedInspectionIds().toArray(new String[this.getProposedInspectionIds().size()]));
        }
        try {
            this.properties.write(false);
        }
        catch (IOException e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(((Object)((Object)this)).getClass().getName(), "setupProperties", e);
        }
    }

    private void loadProperties() throws FileNotFoundException {
        String password;
        File propertiesFile = new File(this.home, TESTCASE_PROPERTIES);
        if (propertiesFile.exists()) {
            this.properties = new Properties(propertiesFile);
            this.loadLocationInfo(this.properties);
            this.useOAuth2 = this.properties.getBoolean("use.oauth2", false);
            this.oAuth2Username = this.properties.getProperty("oauth2.user");
            String encodedPassword = this.properties.getProperty("oauth2.password");
            password = null;
            if (encodedPassword != null) {
                try {
                    password = new String(Base64.getDecoder().decode(encodedPassword), StandardCharsets.UTF_8);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        } else {
            throw new FileNotFoundException();
        }
        this.oAuth2Password = password;
        this.bridgeUser = this.properties.getProperty("https.user");
        this.proposedConfiguration = new Configuration(TraceSettings.TraceLevel.valueOf((int)Integer.parseInt(this.properties.getProperty("trace.mode", String.valueOf(TraceSettings.TraceLevel.None.getMode())))), Integer.parseInt(this.properties.getProperty("trace.maxsize", "-1")), Arrays.asList(this.properties.getStringArray("inspection", new String[0])));
    }

    private void loadLocationInfo(Properties properties) {
        this.customLocation = properties.getProperty("location.custom");
        this.bridgeLocation = properties.getProperty("location.https");
        this.selectedLocationType = LocationType.SYSTEM;
        String selectedLocation = properties.getProperty("location");
        if (selectedLocation != null) {
            if (selectedLocation.equals(this.customLocation)) {
                this.selectedLocationType = LocationType.CUSTOM;
            } else if (selectedLocation.equals(this.bridgeLocation)) {
                this.selectedLocationType = LocationType.BRIDGE;
            }
        }
    }

    private void loadChildren() {
        if (this.idFile.exists()) {
            ArrayList<String> pathsToBeRemoved = new ArrayList<String>();
            for (String key : this.uniqueIds.keySet()) {
                File folder = new File(this.home, this.uniqueIds.get(key));
                if (folder.exists()) {
                    try {
                        this.createTestcase(folder);
                    }
                    catch (FileNotFoundException fileNotFoundException) {}
                    continue;
                }
                pathsToBeRemoved.add(key);
            }
            if (!pathsToBeRemoved.isEmpty()) {
                for (String path : pathsToBeRemoved) {
                    this.uniqueIds.remove(path);
                }
                UniqueIdService.saveIds(this.uniqueIds, (File)this.idFile);
            }
        }
    }

    private void initializeUniqueIds() {
        try {
            this.uniqueIds = UniqueIdService.loadUniqueIds((File)this.idFile);
        }
        catch (WrongIDFileVersionException e) {
            this.idFile.delete();
        }
    }

    public Key computeKey() {
        return new Key(this.getClassifier(), this.getLocation());
    }

    public static enum LocationType {
        SYSTEM,
        CUSTOM,
        BRIDGE;

    }

    public static class Key {
        private final String classifier;
        private final String location;

        private Key(String classifier, String location) {
            this.classifier = classifier;
            this.location = location;
        }

        public int hashCode() {
            return (this.classifier + this.location).hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Key && this.classifier.equals(((Key)obj).classifier) && this.location.equals(((Key)obj).location);
        }
    }

    public static class Configuration {
        public final TraceSettings.TraceLevel traceLevel;
        public final int traceMaxSize;
        public final Collection<String> inspectionsIds;

        public Configuration(TraceSettings.TraceLevel traceLevel, int traceMaxSize, Collection<String> inspectionsIds) {
            this.traceLevel = traceLevel;
            this.traceMaxSize = traceMaxSize;
            this.inspectionsIds = inspectionsIds;
        }

        private Configuration() {
            this(TraceSettings.TraceLevel.None, -1, Collections.emptyList());
        }

        public boolean isEmpty() {
            return this.traceLevel == TraceSettings.TraceLevel.None;
        }
    }
}

