/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.xsltinterface;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.base.error.BuilderError;
import ch.e2e.builder.base.error.BuilderFatalError;
import ch.e2e.builder.base.error.BuilderWarning;
import ch.e2e.builder.base.message.SendErrorEvent;
import ch.e2e.builder.base.message.SendFatalErrorEvent;
import ch.e2e.builder.base.message.SendWarningEvent;
import ch.e2e.builder.base.tools.Utilities;
import ch.e2e.builder.compiler.error.ConfigurationError;
import ch.e2e.builder.compiler.error.ConfigurationFatalError;
import ch.e2e.builder.compiler.error.ConfigurationWarning;
import ch.e2e.builder.compiler.error.EALError;
import ch.e2e.builder.compiler.error.EALFatalError;
import ch.e2e.builder.compiler.error.EALWarning;
import ch.e2e.builder.compiler.xsltinterface.Logging;
import ch.e2e.event.EventController;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;

public class XSLTOutput
extends ch.e2e.builder.base.xsltinterface.XSLTOutput
implements Logging {
    public static void reset() {
        module = "compiler";
        messageView = "compiler.message.view";
    }

    public static void sendDescriptorMessage(String code, String type, String umlLocation, String parameter, String configuration) {
        XSLTOutput.sendDescriptorMessage(code, type, umlLocation, parameter, configuration, null);
    }

    public static void sendDescriptorMessage(String code, String type, String umlLocation, String parameter, String configuration, String taskId) {
        if (type.equals("info")) {
            XSLTOutput.info((String)code, (Map)Utilities.createParameterMap((String)parameter));
        } else if (type.equals("warning")) {
            XSLTOutput.descriptorWarning(code, umlLocation, parameter, configuration, taskId);
        } else if (type.equals("error")) {
            XSLTOutput.descriptorError(code, umlLocation, parameter, configuration, taskId);
        } else if (type.equals("fatalError")) {
            XSLTOutput.descriptorFatalError(code, umlLocation, parameter, configuration, taskId);
        }
    }

    private static void descriptorError(String code, String location, String parameter, String configuration) {
        XSLTOutput.descriptorError(code, location, parameter, configuration, null);
    }

    private static void descriptorError(String code, String location, String parameter, String configuration, String taskId) {
        ConfigurationError error = new ConfigurationError(code, Utilities.createParameterMap((String)parameter), location, configuration);
        error = XSLTOutput.getXsltErrorHandler((String)taskId).error((AbstractBuilderError)error);
        if (error != null && taskId == null) {
            EventController.fire((EventObject)new SendErrorEvent((Object)(XSLTOutput.getXsltAction() == null ? XSLTOutput.class : XSLTOutput.getXsltAction()), (BuilderError)error, module, messageView));
        }
    }

    private static void descriptorWarning(String code, String location, String parameter, String configuration) {
        XSLTOutput.descriptorWarning(code, location, parameter, configuration, null);
    }

    private static void descriptorWarning(String code, String location, String parameter, String configuration, String taskId) {
        ConfigurationWarning warning = new ConfigurationWarning(code, Utilities.createParameterMap((String)parameter), location, configuration);
        warning = XSLTOutput.getXsltErrorHandler((String)taskId).warning((BuilderWarning)warning);
        if (warning != null && taskId == null) {
            EventController.fire((EventObject)new SendWarningEvent((Object)(XSLTOutput.getXsltAction() == null ? XSLTOutput.class : XSLTOutput.getXsltAction()), (BuilderWarning)warning, module, messageView));
        }
    }

    private static void descriptorFatalError(String code, String umlLocation, String parameter, String configuration) {
        XSLTOutput.descriptorFatalError(code, umlLocation, parameter, configuration, null);
    }

    private static void descriptorFatalError(String code, String umlLocation, String parameter, String configuration, String taskId) {
        ConfigurationFatalError error = new ConfigurationFatalError(code, Utilities.createParameterMap((String)parameter), umlLocation, configuration);
        error = XSLTOutput.getXsltErrorHandler((String)taskId).fatalError((BuilderFatalError)error);
        if (error != null && taskId == null) {
            EventController.fire((EventObject)new SendFatalErrorEvent((Object)(XSLTOutput.getXsltAction() == null ? XSLTOutput.class : XSLTOutput.getXsltAction()), (BuilderFatalError)error, module, messageView));
        }
    }

    public static void sendEALMessage(String code, String type, String umlLocation, Integer line, Integer column, String parameter) {
        XSLTOutput.sendEALMessage(code, type, umlLocation, line, column, parameter, null);
    }

    public static void sendEALMessage(String code, String type, String umlLocation, Integer line, Integer column, String parameter, String taskId) {
        XSLTOutput.sendEALMessage(code, type, umlLocation, "", line, column, parameter, taskId);
    }

    public static void sendEALMessage(String code, String type, String umlLocation, String originalElement, Integer line, Integer column, String parameter, String taskId) {
        if (type.equals("info")) {
            XSLTOutput.info((String)code, (Map)Utilities.createParameterMap((String)parameter));
        } else if (type.equals("warning")) {
            XSLTOutput.ealWarning(code, umlLocation, originalElement, line, column, parameter, taskId);
        } else if (type.equals("error")) {
            XSLTOutput.ealError(code, umlLocation, originalElement, line, column, parameter, taskId);
        } else if (type.equals("fatalError")) {
            XSLTOutput.ealFatalError(code, umlLocation, originalElement, line, column, parameter, taskId);
        }
    }

    private static void ealError(String code, String location, Integer line, Integer column, String parameter) {
        XSLTOutput.ealError(code, location, line, column, parameter, null);
    }

    private static void ealError(String code, String location, Integer line, Integer column, String parameter, String taskId) {
        XSLTOutput.ealError(code, location, "", line, column, parameter, taskId);
    }

    private static void ealError(String code, String location, String originalLocation, Integer line, Integer column, String parameter, String taskId) {
        EALError error = new EALError(code, Utilities.createParameterMap((String)parameter), location, originalLocation, line, column);
        error = XSLTOutput.getXsltErrorHandler((String)taskId).error((AbstractBuilderError)error);
        if (error != null && taskId == null) {
            EventController.fire((EventObject)new SendErrorEvent((Object)(XSLTOutput.getXsltAction() == null ? XSLTOutput.class : XSLTOutput.getXsltAction()), (BuilderError)error, module, messageView));
        }
    }

    private static void ealWarning(String code, String location, Integer line, Integer column, String parameter) {
        XSLTOutput.ealWarning(code, location, line, column, parameter, null);
    }

    private static void ealWarning(String code, String location, Integer line, Integer column, String parameter, String taskId) {
        XSLTOutput.ealWarning(code, location, "", line, column, parameter, taskId);
    }

    private static void ealWarning(String code, String location, String originalLocation, Integer line, Integer column, String parameter, String taskId) {
        EALWarning warning = new EALWarning(code, Utilities.createParameterMap((String)parameter), location, originalLocation, line, column);
        warning = XSLTOutput.getXsltErrorHandler((String)taskId).warning((BuilderWarning)warning);
        if (warning != null && taskId == null) {
            EventController.fire((EventObject)new SendWarningEvent((Object)(XSLTOutput.getXsltAction() == null ? XSLTOutput.class : XSLTOutput.getXsltAction()), (BuilderWarning)warning, module, messageView));
        }
    }

    private static void ealFatalError(String code, String umlLocation, Integer line, Integer column, String parameter) {
        XSLTOutput.ealFatalError(code, umlLocation, line, column, parameter, null);
    }

    private static void ealFatalError(String code, String location, Integer line, Integer column, String parameter, String taskId) {
        XSLTOutput.ealFatalError(code, location, "", line, column, parameter, taskId);
    }

    private static void ealFatalError(String code, String location, String originalLocation, Integer line, Integer column, String parameter, String taskId) {
        EALFatalError error = new EALFatalError(code, Utilities.createParameterMap((String)parameter), location, originalLocation, line, column);
        error = XSLTOutput.getXsltErrorHandler((String)taskId).fatalError((BuilderFatalError)error);
        if (error != null && taskId == null) {
            EventController.fire((EventObject)new SendFatalErrorEvent((Object)(XSLTOutput.getXsltAction() == null ? XSLTOutput.class : XSLTOutput.getXsltAction()), (BuilderFatalError)error, module, messageView));
        }
    }

    public static void creatingPackage(String packageType, String packageName) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        parameterMap.put("package.type", packageType);
        parameterMap.put("package.name", packageName);
        XSLTOutput.info((String)"create.package", parameterMap);
    }
}

