/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.utils;

import java.util.Optional;

public class EnvUtils {
    public static int get(String key, int defaultValue) {
        try {
            return Integer.parseInt(System.getenv(key));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String get(String key, String defaultValue) {
        String res = System.getenv(key);
        if (res != null) {
            return res;
        }
        return defaultValue;
    }

    public static boolean get(String key, boolean defaultValue) {
        return Optional.ofNullable(System.getenv(key)).map(Boolean::parseBoolean).orElse(defaultValue);
    }
}

