/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.compiler.uml.BridgeNodeInstance;
import ch.e2e.builder.compiler.uml.DeploymentElement;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.NodeContainerDescription;
import ch.e2e.builder.compiler.uml.UmlElement;
import java.util.ArrayList;
import javax.swing.Icon;

public class NodeContainer
extends DeploymentElement {
    private boolean selectable;
    private Icon icon;

    public NodeContainer(NodeContainerDescription description, UmlElement parent, Helpers helpers) {
        super(description.getStereotype(), helpers);
        this.setParent(parent);
        this.setName(description.getName());
        this.icon = description.getIcon();
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public boolean isSelectable() {
        return this.selectable;
    }

    @Override
    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    public ArrayList<UmlElement> getAllNodeChildClassifer() {
        ArrayList<UmlElement> result = new ArrayList<UmlElement>();
        for (UmlElement node : this.getChildren()) {
            result.addAll(((BridgeNodeInstance)node).getAllChildClassifer());
        }
        return result;
    }

    public boolean containsNode(BridgeNodeInstance node) {
        boolean found = false;
        int length = this.getChildren().size();
        for (int i = 0; i < length && !found; ++i) {
            found = this.getChildren().get(i).getName().equals(node.getName());
        }
        return found;
    }
}

