/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.serviceRepository;

import ch.e2e.builder.compiler.serviceRepository.types.Container;
import ch.e2e.builder.compiler.serviceRepository.types.core.Context;
import ch.e2e.builder.compiler.serviceRepository.types.core.ContextRequest;
import ch.e2e.builder.compiler.serviceRepository.types.core.ControlContainerRequest;
import ch.e2e.builder.compiler.serviceRepository.types.core.PasRequest;
import ch.e2e.builder.compiler.serviceRepository.types.core.PasResponse;
import ch.e2e.builder.compiler.serviceRepository.types.core.User;
import ch.e2e.builder.compiler.serviceRepository.types.events.ControlContainerResponse;
import ch.e2e.builder.compiler.serviceRepository.types.events.DeployContainerRequest;
import ch.e2e.builder.compiler.serviceRepository.types.events.DeployContainerResponse;
import ch.e2e.builder.compiler.serviceRepository.types.events.ListContainersRequest;
import ch.e2e.builder.compiler.serviceRepository.types.events.control.RemoveOptions;
import ch.e2e.builder.compiler.utils.ClientUtils;
import ch.e2e.builder.compiler.utils.EnvUtils;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJaxbJsonProvider;

public class ServiceRepositoryService {
    private static final String SERVICE_REPOSITORY_PROTOCOL = EnvUtils.get("SERVICE_REPOSITORY_PROTOCOL ", "http");
    private static final String SERVICE_REPOSITORY_HOSTNAME = EnvUtils.get("SERVICE_REPOSITORY_HOSTNAME", "service-repository");
    private static final String SERVICE_REPOSITORY_PORT = EnvUtils.get("SERVICE_REPOSITORY_PORT", "3017");
    private static final String SERVICE_REPOSITORY_BASE_URL = SERVICE_REPOSITORY_PROTOCOL + "://" + SERVICE_REPOSITORY_HOSTNAME + ":" + SERVICE_REPOSITORY_PORT;
    private static final String CONTAINER_CONTROL_EVENT_NAME = "dockerControlContainer";
    private static final String CONTAINER_DEPLOY_EVENT_NAME = "dockerDeployContainer";
    private static final String CONTAINER_LIST_EVENT_NAME = "dockerListContainers";

    public List<Container> getContainers() throws Exception {
        return this.getContainers(null);
    }

    public List<Container> getContainers(ListContainersRequest.Filters filters) throws Exception {
        ListContainersRequest payload = new ListContainersRequest();
        payload.setFilters(filters);
        return this.request(CONTAINER_LIST_EVENT_NAME, payload, new GenericType<PasResponse<List<Container>>>(){});
    }

    public List<Container> getXumlDevContainers() throws Exception {
        ListContainersRequest payload = new ListContainersRequest();
        payload.getFilters().getLabel().add("com.scheer-pas.custom-label.xumlDev");
        return this.request(CONTAINER_LIST_EVENT_NAME, payload, new GenericType<PasResponse<List<Container>>>(){});
    }

    public ControlContainerResponse removeContainer(String id) throws Exception {
        ControlContainerRequest<RemoveOptions> payload = new ControlContainerRequest<RemoveOptions>();
        payload.setId(id);
        payload.setAction("remove");
        payload.setOptions(new RemoveOptions());
        ((RemoveOptions)payload.getOptions()).setForce(true);
        return this.request(CONTAINER_CONTROL_EVENT_NAME, payload, new GenericType<PasResponse<ControlContainerResponse>>(){});
    }

    public DeployContainerResponse deployContainer(String image, String name, String hostname) throws Exception {
        DeployContainerRequest payload = new DeployContainerRequest();
        payload.setImage(image);
        payload.setName(name);
        payload.setHostname(hostname);
        return this.request(CONTAINER_DEPLOY_EVENT_NAME, payload, new GenericType<PasResponse<DeployContainerResponse>>(){});
    }

    public <Req, Res> Res request(String event, Req payload, GenericType<PasResponse<Res>> responseEntityType) throws Exception {
        ContextRequest contextRequest = new ContextRequest();
        contextRequest.setClientUuid(EnvUtils.get("SYSTEM_PREFIX", "pas"));
        Context context = new Context();
        context.setRequest(contextRequest);
        context.setUser(new User());
        PasRequest<Req> request = new PasRequest<Req>();
        request.setPayload(payload);
        request.setContext(context);
        request.setEvent(event);
        Client client = ClientUtils.getClient();
        Response response = client.target(SERVICE_REPOSITORY_BASE_URL).path("").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).buildPost(Entity.json(request)).invoke();
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            throw new Exception(response.getStatusInfo().getReasonPhrase());
        }
        InputStream ins = (InputStream)response.getEntity();
        JacksonJaxbJsonProvider provider = new JacksonJaxbJsonProvider();
        PasResponse responseBody = (PasResponse)provider.readFrom(responseEntityType.getRawType(), responseEntityType.getType(), new Annotation[0], MediaType.APPLICATION_JSON_TYPE, response.getStringHeaders(), ins);
        if (!responseBody.getMessage().getType().equals("INFO")) {
            throw new Exception(responseBody.getMessage().getInternalInfo());
        }
        return (Res)responseBody.getPayload();
    }
}

