/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.library;

import ch.e2e.builder.base.project.E2EBuilderProject;
import ch.e2e.builder.compiler.document.importer.IDLImportSource;
import ch.e2e.builder.compiler.document.importer.library.LibraryDataModel;
import ch.e2e.builder.compiler.tools.TraceState;
import ch.e2e.builder.compiler.uml.BridgeComponent;
import ch.e2e.builder.compiler.uml.BridgePackage;
import ch.e2e.builder.compiler.uml.DataModel;
import ch.e2e.builder.compiler.uml.DeploymentElement;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.io.FileUtilities;
import ch.e2e.io.ZipUtilities;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Library
extends IDLImportSource {
    private static SimpleDateFormat dateFormatter = new SimpleDateFormat("dd.MM.yyyy HH:mm");
    private File file;
    private File projectFile;
    private String version;
    private long buildID;
    private int traceState;
    private BridgeComponent proxy;

    public static Document getLibraryInfo(File file) throws IOException, ParserConfigurationException, SAXException {
        ZipFile repository = new ZipFile(file);
        Document libraryInfo = repository.getEntry("library.interface") != null ? ZipUtilities.getZippedDocumentFromFile((ZipFile)repository, (String)"library.interface", (boolean)false, (boolean)false) : ZipUtilities.getZippedDocumentFromFile((ZipFile)repository, (String)"module.interface", (boolean)false, (boolean)false);
        return libraryInfo;
    }

    public Library(Element libraryElement, File importFolder, Helpers helpers) {
        super(libraryElement.getAttribute("library"), libraryElement, importFolder, helpers);
        this.version = libraryElement.getAttribute("version");
        try {
            this.buildID = Long.parseLong(libraryElement.getAttribute("buildID"));
        }
        catch (Exception e) {
            this.buildID = 0L;
        }
        this.file = new File(libraryElement.getAttribute("file"));
        File libsFolder = new File(E2EBuilderProject.getProjectFolderName(), "libs");
        this.projectFile = new File(libsFolder, this.getName() + ".lrep");
        this.readImportedLibraries(libraryElement.getElementsByTagName("Library"));
    }

    public Library(File file, File importFolder, Helpers helpers) throws IOException, ParserConfigurationException, SAXException {
        super(Library.getLibraryInfo(file).getDocumentElement().getAttribute("library"), Library.getLibraryInfo(file).getDocumentElement(), importFolder, helpers);
        this.file = file;
        this.buildID = Long.parseLong(this.getIdl().getAttribute("buildID"));
        this.version = this.getIdl().getAttribute("version");
        try {
            this.traceState = Integer.parseInt(this.getIdl().getAttribute("trace"));
        }
        catch (Exception ex) {
            this.traceState = 0;
        }
        File libsFolder = new File(E2EBuilderProject.getProjectFolderName(), "libs");
        this.projectFile = new File(libsFolder, this.getName() + ".lrep");
        this.readImportedLibraries(this.getIdl().getElementsByTagName("Library"));
    }

    private Library(String name, String version, long buildID, File importFolder, Helpers helpers) {
        super(name, importFolder, helpers);
        this.buildID = buildID;
        this.version = version;
        File libsFolder = new File(E2EBuilderProject.getProjectFolderName(), "libs");
        this.projectFile = new File(libsFolder, name + ".lrep");
    }

    @Override
    protected DataModel createDataModel() {
        return new LibraryDataModel(this.getName(), this.getImportFolder(), this.getHelpers());
    }

    public String getDate() {
        return dateFormatter.format(new Date(this.buildID));
    }

    public long getBuildID() {
        return this.buildID;
    }

    public File getFile() {
        return this.file;
    }

    public File getProjectFile() {
        return this.projectFile;
    }

    @Override
    public String getDevelopmentFilename() {
        return this.projectFile.getName();
    }

    public String getFilename() {
        return this.file.getName();
    }

    public String getPath() {
        return FileUtilities.getAbsolutePath((File)this.file.getParentFile());
    }

    public String getVersion() {
        return this.version;
    }

    public Element toElement(Document ownerDocument) {
        Element library = ownerDocument.createElement("Library");
        library.setAttribute("name", this.getName());
        if (this.file != null) {
            library.setAttribute("path", FileUtilities.getAbsolutePath((File)this.file));
        }
        library.setAttribute("version", this.version);
        library.setAttribute("buildID", String.valueOf(this.buildID));
        return library;
    }

    public String toString() {
        return this.getName();
    }

    public int getTraceState() {
        return this.traceState;
    }

    public void setTraceState(int traceState) {
        this.traceState = traceState;
    }

    private void readImportedLibraries(NodeList libraries) {
        int length = libraries.getLength();
        for (int i = 0; i < length; ++i) {
            Element library = (Element)libraries.item(i);
            String name = library.getAttribute("name");
            long buildID = Long.parseLong(library.getAttribute("buildID"));
            String version = library.getAttribute("version");
            this.addImportedElement(new Library(name, version, buildID, this.getImportFolder(), this.getHelpers()));
        }
    }

    public BridgeComponent getLibraryProxy() {
        if (this.proxy == null) {
            this.proxy = new BridgeComponent(this.getIdl().getAttribute("library"), this.getHelpers().getStereotypeFactory().getStereotype("E2ELibraryProxy"), this.getHelpers());
            String version = this.getIdl().hasAttribute("version") ? this.getIdl().getAttribute("version") : null;
            this.proxy.setPropertyValueQuietly("version", version);
        }
        return this.proxy;
    }

    @Override
    protected void createProxyComponents(DataModel dataModel, BridgePackage components) {
        String name = this.getIdl().getAttribute("library");
        BridgeComponent proxy = this.getLibraryProxy();
        BridgePackage bridgePackage = this.getHelpers().getPackagesFactory().getPackage(components, "Libraries", this.getHelpers().getStereotypeFactory().getStereotype("Repository"));
        components.addPackage(bridgePackage);
        proxy.setOwningPackage(bridgePackage);
        dataModel.addElement(proxy);
        DeploymentElement proxyDeployment = new DeploymentElement(name, proxy, this.getHelpers());
        proxyDeployment.setOwningPackage(bridgePackage);
        proxyDeployment.setPropertyValueQuietly("trace", TraceState.getDisplayString(this.getTraceState()));
        String buildID = this.getIdl().hasAttribute("buildID") ? this.getIdl().getAttribute("buildID") : null;
        proxyDeployment.setPropertyValueQuietly("buildID", buildID);
        dataModel.addElement(proxyDeployment);
    }
}

