/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.source;

import ch.e2e.builder.compiler.build.tasks.handler.Selector;
import ch.e2e.builder.compiler.build.tasks.handler.SourceCreator;
import ch.e2e.builder.compiler.build.tasks.source.Logging;
import ch.e2e.builder.compiler.build.tasks.source.Source;
import ch.e2e.builder.compiler.build.tasks.source.SourceFactory;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class SimpleSourceFactory
extends SourceFactory {
    Selector selector;
    SourceCreator sourceCreator;
    Double priority;

    public SimpleSourceFactory(Selector selector, SourceCreator sourceCreator) {
        this(selector, sourceCreator, SourceManager.DEFAULT_PRIORITY);
    }

    public SimpleSourceFactory(Selector selector, SourceCreator sourceCreator, Double priority) {
        this.selector = selector;
        this.sourceCreator = sourceCreator;
        this.priority = priority;
    }

    public SimpleSourceFactory(Selector selector, Class<? extends Source> sourceClass) {
        this(selector, sourceClass, SourceManager.DEFAULT_PRIORITY);
    }

    public SimpleSourceFactory(Selector selector, Class<? extends Source> sourceClass, Double priority) {
        this(selector, (File file, SourceManager sourceManager) -> {
            try {
                Constructor<? extends Source> constructor = SimpleSourceFactory.getConstructor(sourceClass, SourceManager.class, File.class);
                if (constructor != null) {
                    return constructor.newInstance(sourceManager, file);
                }
                constructor = SimpleSourceFactory.getConstructor(sourceClass, File.class, SourceManager.class);
                if (constructor != null) {
                    return constructor.newInstance(file, sourceManager);
                }
                constructor = SimpleSourceFactory.getConstructor(sourceClass, SourceManager.class);
                if (constructor != null) {
                    return constructor.newInstance(sourceManager);
                }
                constructor = SimpleSourceFactory.getConstructor(sourceClass, File.class);
                if (constructor != null) {
                    return constructor.newInstance(file);
                }
                constructor = SimpleSourceFactory.getConstructor(sourceClass, new Class[0]);
                if (constructor != null) {
                    return constructor.newInstance(new Object[0]);
                }
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
            return null;
        }, priority);
    }

    public SimpleSourceFactory(Class<? extends Source> sourceClass) throws NoSuchMethodException {
        this(sourceClass, SourceManager.DEFAULT_PRIORITY);
    }

    public SimpleSourceFactory(Class<? extends Source> sourceClass, Double priority) {
        this((String id) -> {
            try {
                Method select = sourceClass.getMethod("select", String.class);
                if (!Modifier.isStatic(select.getModifiers())) {
                    Logging.logger.warning("'select' method is not static on class " + sourceClass.getCanonicalName());
                    return false;
                }
                if (Boolean.class.isAssignableFrom(select.getReturnType())) {
                    return (Boolean)select.invoke(null, id);
                }
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
            return false;
        }, sourceClass, priority);
    }

    static Constructor<? extends Source> getConstructor(Class<? extends Source> sourceClass, Class<?> ... parameterTypes) {
        try {
            return sourceClass.getConstructor(parameterTypes);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            return null;
        }
    }

    @Override
    public Boolean matchId(String id) {
        return this.selector.select(id);
    }

    @Override
    public Source createSource(File file, SourceManager sourceManager) throws Exception {
        return this.sourceCreator.create(file, sourceManager);
    }

    @Override
    public Double getPriority() {
        return this.priority;
    }
}

