/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.libraries;

import ch.e2e.builder.compiler.build.tasks.constants.Files;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import java.io.File;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class LibrariesHelper {
    public static final String LIB_PAS_Platform = "PAS Platform";
    public static final String LIB_PAS_Form_Elements = "PAS Form Elements";

    public static Set<String> getLibrariesNameSet(SourceManager sourceManager) {
        return LibrariesHelper.getLibrariesNameSet(sourceManager, true);
    }

    public static Set<String> getLibrariesNameSet(SourceManager sourceManager, boolean includeCompilerLibraries) {
        HashSet<String> result = new HashSet<String>();
        File librariesFolder = new File(sourceManager.getProjectFolder(), "libs");
        if (librariesFolder.exists() && librariesFolder.isDirectory()) {
            for (File file : Objects.requireNonNull(librariesFolder.listFiles((dir, name) -> name.endsWith(".library.json")))) {
                result.add(file.getName().replace(".library.json", ""));
            }
        }
        if (includeCompilerLibraries) {
            result.addAll(LibrariesHelper.getCompilerLibrariesNameSet());
        }
        return result;
    }

    public static Set<String> getCompilerLibrariesNameSet() {
        return new HashSet<String>(){
            {
                this.add(LibrariesHelper.LIB_PAS_Platform);
                this.add(LibrariesHelper.LIB_PAS_Form_Elements);
            }
        };
    }

    public static Set<String> getDescriptorsSourceSet(SourceManager sourceManager) {
        return LibrariesHelper.getDescriptorsSourceSet(sourceManager, true);
    }

    public static Set<String> getDescriptorsSourceSet(SourceManager sourceManager, boolean includeCompilerLibraries) {
        return LibrariesHelper.getLibrariesNameSet(sourceManager, includeCompilerLibraries).stream().map(Files::libs_LIBRARY__library_descriptor_xml).collect(Collectors.toSet());
    }
}

