/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public abstract class ZipTask
extends CacheAbleTask {
    public ZipTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected String getDestinationFileExtension() {
        return ".zip";
    }

    private void putSourceInZipEntry(ZipOutputStream zs, Path sourcePath, String zipEntryPath) {
        if (this.doFilter(sourcePath)) {
            try {
                zs.putNextEntry(new ZipEntry(zipEntryPath.replaceAll("\\\\", "/")));
                Files.copy(sourcePath, zs);
                zs.closeEntry();
            }
            catch (IOException e) {
                this.getErrorHandler().error((Throwable)e);
            }
        }
    }

    protected Path[] getInputFolderPaths() {
        return new Path[]{this.getSourceManager().getWorkFolder().toPath().resolve(this.getDestinationFilePathWithoutExtension())};
    }

    protected Map<String, File> getInputFiles() {
        return new HashMap<String, File>();
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        try {
            Files.deleteIfExists(this.getDestinationFile().toPath());
            Files.createDirectories(this.getDestinationFile().getParentFile().toPath(), new FileAttribute[0]);
            Path destinationPath = Files.createFile(this.getDestinationFile().toPath(), new FileAttribute[0]);
            try (ZipOutputStream zs = new ZipOutputStream(Files.newOutputStream(destinationPath, new OpenOption[0]));){
                for (Path inputPath : this.getInputFolderPaths()) {
                    Files.walk(inputPath, new FileVisitOption[0]).forEach(path -> this.putSourceInZipEntry(zs, (Path)path, inputPath.relativize((Path)path).toString()));
                }
                for (Map.Entry entry : this.getInputFiles().entrySet()) {
                    this.putSourceInZipEntry(zs, ((File)entry.getValue()).toPath(), (String)entry.getKey());
                }
            }
        }
        catch (Exception e) {
            this.getErrorHandler().error((Throwable)e);
        }
    }

    protected boolean doFilter(Path path) {
        return !Files.isDirectory(path, new LinkOption[0]);
    }
}

