/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui.junit;

import ch.e2e.ant.gui.junit.BaseTestRunner;
import ch.e2e.resource.ImageLoader;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import junit.framework.TestFailure;

public class FailureListCellRenderer
extends DefaultListCellRenderer {
    private Icon failureIcon;
    private Icon errorIcon;

    public FailureListCellRenderer() {
        this.loadIcons();
    }

    void loadIcons() {
        this.failureIcon = ImageLoader.loadIcon((String)"ch/e2e/gui/junit/failure.gif", (boolean)true);
        this.errorIcon = ImageLoader.loadIcon((String)"ch/e2e/gui/junit/error.gif", (boolean)true);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int modelIndex, boolean isSelected, boolean cellHasFocus) {
        Component c = super.getListCellRendererComponent((JList<?>)list, value, modelIndex, isSelected, cellHasFocus);
        TestFailure failure = (TestFailure)value;
        String text = failure.failedTest().toString();
        String msg = failure.exceptionMessage();
        if (msg != null) {
            text = text + ":" + BaseTestRunner.truncate(msg);
        }
        if (failure.isFailure()) {
            if (this.failureIcon != null) {
                this.setIcon(this.failureIcon);
            }
        } else if (this.errorIcon != null) {
            this.setIcon(this.errorIcon);
        }
        this.setText(text);
        this.setToolTipText(text);
        return c;
    }
}

