/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui.junit;

import ch.e2e.ant.gui.junit.BaseTestRunner;
import ch.e2e.ant.gui.junit.JUnitGuiRegistry;
import ch.e2e.test.Testable;
import java.awt.Component;
import java.awt.Font;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

public class FailureDetailView {
    private JList list;

    public FailureDetailView() {
        JUnitGuiRegistry.getInstance().registerGui(this);
    }

    public void testSelected(Testable test) {
        this.clear();
    }

    public Component getComponent() {
        if (this.list == null) {
            this.list = new JList(new StackTraceListModel());
            this.list.setFont(new Font("Dialog", 0, 12));
            this.list.setSelectionMode(0);
            this.list.setVisibleRowCount(5);
            this.list.setCellRenderer(new StackEntryRenderer());
        }
        return this.list;
    }

    public void showFailure(String trace) {
        this.getModel().setTrace(BaseTestRunner.getFilteredTrace(trace));
    }

    public void clear() {
        this.getModel().clear();
    }

    private StackTraceListModel getModel() {
        return (StackTraceListModel)this.list.getModel();
    }

    static class StackEntryRenderer
    extends DefaultListCellRenderer {
        StackEntryRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int modelIndex, boolean isSelected, boolean cellHasFocus) {
            String text = ((String)value).replace('\t', ' ');
            Component c = super.getListCellRendererComponent((JList<?>)list, text, modelIndex, isSelected, cellHasFocus);
            this.setText(text);
            this.setToolTipText(text);
            return c;
        }
    }

    static class StackTraceListModel
    extends AbstractListModel {
        private Vector fLines = new Vector(20);

        StackTraceListModel() {
        }

        @Override
        public Object getElementAt(int index) {
            return this.fLines.elementAt(index);
        }

        @Override
        public int getSize() {
            return this.fLines.size();
        }

        public void setTrace(String trace) {
            this.scan(trace);
            this.fireContentsChanged(this, 0, this.fLines.size());
        }

        public void clear() {
            this.fLines.removeAllElements();
            this.fireContentsChanged(this, 0, this.fLines.size());
        }

        private void scan(String trace) {
            this.fLines.removeAllElements();
            StringTokenizer st = new StringTokenizer(trace, "\n\r", false);
            while (st.hasMoreTokens()) {
                this.fLines.add(st.nextToken());
            }
        }
    }
}

