/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui.configuration.types.input;

import ch.e2e.ant.gui.configuration.types.input.DirectoryList;
import ch.e2e.ant.gui.configuration.types.input.InputElement;
import ch.e2e.swing.event.DirectoryActionListener;
import ch.e2e.swing.event.DirectorySelectedListener;
import ch.e2e.swing.filechooser.DirectoryField;
import ch.e2e.swing.filechooser.DirectoryTree;
import ch.e2e.swing.filechooser.SmallDirectoryButtonPanel;
import ch.e2e.swing.model.Directory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class DirectoryComboBox
extends InputElement {
    private int buttons;
    private boolean homeButton = false;
    private boolean newButton = false;
    private boolean upButton = false;
    private JComponent component;
    private ch.e2e.swing.filechooser.DirectoryComboBox comboBox;
    private SmallDirectoryButtonPanel buttonPanel;

    public void setHomeButton(boolean homeButton) {
        this.homeButton = homeButton;
        this.buttons |= homeButton ? 2 : 0;
    }

    public void setNewButton(boolean newButton) {
        this.newButton = newButton;
        this.buttons |= this.homeButton ? 4 : 0;
    }

    public void setUpButton(boolean upButton) {
        this.upButton = upButton;
        this.buttons |= this.homeButton ? 1 : 0;
    }

    @Override
    public JComponent getGuiElement() {
        if (this.component == null) {
            this.createComponent();
        }
        return this.component;
    }

    public void addDirectoryActionListener(DirectoryActionListener listener) {
        this.buttonPanel.addDirectoryActionListener(listener);
    }

    public void addDirectoryListener(DirectoryTree tree) {
        this.buttonPanel.addDirectorySelectedListener((DirectorySelectedListener)tree);
        this.comboBox.addDirectorySelectedListener((DirectorySelectedListener)tree);
        tree.addDirectorySelectedListener((DirectorySelectedListener)this.buttonPanel);
        tree.addDirectorySelectedListener((DirectorySelectedListener)this.comboBox);
    }

    public void addDirectoryListener(DirectoryField field) {
        this.buttonPanel.addDirectorySelectedListener((DirectorySelectedListener)field);
        this.comboBox.addDirectorySelectedListener((DirectorySelectedListener)field);
        field.addDirectorySelectedListener((DirectorySelectedListener)this.buttonPanel);
        field.addDirectorySelectedListener((DirectorySelectedListener)this.comboBox);
    }

    public void addDirectoryListener(DirectoryList field) {
        this.buttonPanel.addDirectorySelectedListener((DirectorySelectedListener)field);
        this.comboBox.addDirectorySelectedListener((DirectorySelectedListener)field);
        field.addDirectorySelectedListener((DirectorySelectedListener)this.buttonPanel);
        field.addDirectorySelectedListener((DirectorySelectedListener)this.comboBox);
    }

    public void setSelectedDirectory(File file) {
        this.comboBox.setSelectedDirectory(file);
    }

    public void addDirectorySelectedListener(DirectorySelectedListener listener) {
        this.comboBox.addDirectorySelectedListener(listener);
        this.buttonPanel.addDirectorySelectedListener(listener);
    }

    private void createComponent() {
        this.comboBox = new ch.e2e.swing.filechooser.DirectoryComboBox();
        if (this.homeButton || this.newButton || this.upButton) {
            this.component = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridwidth = 1;
            c.anchor = 17;
            c.weightx = 1.0;
            c.fill = 2;
            this.component.add((Component)this.comboBox, c);
            c.gridwidth = 0;
            c.fill = 0;
            c.weightx = 0.0;
            this.buttonPanel = new SmallDirectoryButtonPanel(this.buttons);
            this.buttonPanel.addDirectorySelectedListener((DirectorySelectedListener)this.comboBox);
            this.comboBox.addDirectorySelectedListener((DirectorySelectedListener)this.buttonPanel);
            this.comboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DirectoryComboBox.this.fireAction(e);
                }
            });
            this.component.add((Component)this.buttonPanel, c);
        } else {
            this.component = this.comboBox;
        }
        this.setFill("horizontal");
    }

    @Override
    public String getValue() {
        Directory directory = this.comboBox.getSelectedDirectory();
        return directory.getDir() == null ? null : directory.getDir().getAbsolutePath();
    }

    @Override
    public boolean isEnabled() {
        return this.comboBox.isEnabled();
    }

    @Override
    public void requestFocus() {
        this.comboBox.requestFocus();
    }

    @Override
    public int getFill() {
        return 2;
    }
}

